/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.transaction;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import io.squashql.BigQueryServiceAccountDatastore;
import io.squashql.BigQueryUtil;
import io.squashql.jackson.JacksonUtil;
import io.squashql.list.Lists;
import io.squashql.transaction.DataLoader;
import io.squashql.type.TableTypedField;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryDataLoader
implements DataLoader {
    private static final Logger log = LoggerFactory.getLogger(BigQueryDataLoader.class);
    private static final int MAX_SLEEPS = 5;
    final BigQuery bigquery;
    final String datasetName;

    public BigQueryDataLoader(BigQuery bigquery, String datasetName) {
        this.bigquery = bigquery;
        this.datasetName = datasetName;
    }

    public BigQuery getBigQuery() {
        return this.bigquery;
    }

    public void dropAndCreateInMemoryTable(String tableName, List<TableTypedField> fields) {
        TableId tableId = TableId.of((String)this.datasetName, (String)tableName);
        List<Field> fieldList = fields.stream().map(f -> {
            if (f.type().equals(Lists.LongList.class)) {
                return Field.of((String)f.name(), (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).toBuilder().setMode(Field.Mode.REPEATED).build();
            }
            if (f.type().equals(Lists.StringList.class)) {
                return Field.of((String)f.name(), (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).toBuilder().setMode(Field.Mode.REPEATED).build();
            }
            return Field.of((String)f.name(), (StandardSQLTypeName)BigQueryUtil.classToBigQueryType(f.type()), (Field[])new Field[0]);
        }).toList();
        Schema schema = Schema.of(fieldList);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)schema);
        TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDefinition).build();
        try {
            this.bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        }
        catch (BigQueryException e) {
            if (e.getCode() == 409 && e.getReason().equals("duplicate")) {
                this.bigquery.delete(tableId);
                this.bigquery.create(tableInfo, new BigQuery.TableOption[0]);
            }
            throw e;
        }
    }

    public void load(String store, List<Object[]> tuples) {
        List<TableTypedField> fields = BigQueryServiceAccountDatastore.getFieldsOrNull(this.bigquery, this.datasetName, store);
        ArrayList<InsertAllRequest.RowToInsert> list = new ArrayList<InsertAllRequest.RowToInsert>();
        for (Object[] tuple : tuples) {
            HashMap m = new HashMap();
            for (int i = 0; i < fields.size(); ++i) {
                TableTypedField field = fields.get(i);
                Iterator o = tuple[i];
                if (o != null) {
                    if (o.getClass().equals(LocalDate.class) || o.getClass().equals(LocalDateTime.class)) {
                        o = o.toString();
                    } else if (field.type().equals(Object.class)) {
                        o = JacksonUtil.serialize((Object)o);
                    }
                }
                m.put(field.name(), o);
            }
            list.add(InsertAllRequest.RowToInsert.of(m));
        }
        TableId tableId = TableId.of((String)this.datasetName, (String)store);
        Table table = this.bigquery.getTable(tableId, new BigQuery.TableOption[0]);
        int sleepTime = 1;
        int attempt = 0;
        while (true) {
            try {
                InsertAllResponse response = table.insert(list);
                if (response.hasErrors()) {
                    for (Map.Entry entry : response.getInsertErrors().entrySet()) {
                        System.out.println("Response error: \n" + entry.getValue());
                    }
                    throw new RuntimeException("error while inserting rows, see above");
                }
                return;
            }
            catch (BigQueryException exception) {
                try {
                    Thread.sleep(sleepTime * 1000);
                }
                catch (InterruptedException e) {
                    log.error("", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                if (attempt < 5) {
                    sleepTime <<= 1;
                    log.info("table.insert, retry {}", (Object)(++attempt));
                    continue;
                }
                log.info("table.insert after 5 attempts. Abort.");
                throw exception;
            }
            break;
        }
    }

    public void loadCsv(String table, String path, String delimiter, boolean header) {
        throw new RuntimeException("not impl. yet");
    }
}

