/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.query.database;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableResult;
import io.squashql.BigQueryDatastore;
import io.squashql.BigQueryUtil;
import io.squashql.jdbc.JdbcUtil;
import io.squashql.list.Lists;
import io.squashql.query.database.AQueryEngine;
import io.squashql.query.database.BigQueryQueryRewriter;
import io.squashql.query.database.DatabaseQuery;
import io.squashql.query.database.QueryRewriter;
import io.squashql.store.Datastore;
import io.squashql.table.ColumnarTable;
import io.squashql.table.RowTable;
import io.squashql.table.Table;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.collections.api.tuple.Pair;

public class BigQueryEngine
extends AQueryEngine<BigQueryDatastore> {
    public static final List<String> SUPPORTED_AGGREGATION_FUNCTIONS = List.of("any_value", "avg", "corr", "count", "covar_pop", "covar_samp", "min", "max", "stddev_pop", "stddev_samp", "sum", "var_pop", "var_samp", "variance");

    public BigQueryEngine(BigQueryDatastore datastore) {
        super((Datastore)datastore);
    }

    protected Table retrieveAggregates(DatabaseQuery query, String sql) {
        QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)sql).build();
        try {
            TableResult tableResult = ((BigQueryDatastore)this.datastore).getBigquery().query(queryConfig, new BigQuery.JobOption[0]);
            Schema schema = tableResult.getSchema();
            Pair result = BigQueryEngine.transformToColumnFormat((Collection)query.scope().columns(), (Collection)query.measures(), (List)schema.getFields(), (column, name) -> BigQueryUtil.bigQueryTypeToClass(column), tableResult.iterateAll().iterator(), (i, fieldValueList) -> BigQueryEngine.getTypeValue(fieldValueList, schema, i));
            return new ColumnarTable((List)result.getOne(), new HashSet(query.measures()), (List)result.getTwo());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Table executeRawSql(String sql) {
        QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)sql).build();
        try {
            TableResult tableResult = ((BigQueryDatastore)this.datastore).getBigquery().query(queryConfig, new BigQuery.JobOption[0]);
            Schema schema = tableResult.getSchema();
            Pair result = BigQueryEngine.transformToRowFormat((List)schema.getFields(), column -> column.getName(), column -> BigQueryUtil.bigQueryTypeToClass(column), tableResult.iterateAll().iterator(), (i, fieldValueList) -> BigQueryEngine.getTypeValue(fieldValueList, schema, i));
            return new RowTable((List)result.getOne(), (List)result.getTwo());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getTypeValue(FieldValueList fieldValues, Schema schema, int index) {
        FieldValue fieldValue = fieldValues.get(index);
        if (fieldValue.isNull()) {
            return null;
        }
        Field field = schema.getFields().get(index);
        if (field.getMode() == Field.Mode.REPEATED) {
            Class<?> listClass = BigQueryUtil.bigQueryTypeToClass(field);
            return JdbcUtil.streamToList(listClass, fieldValue.getRepeatedValue().stream().map(o -> {
                if (listClass.equals(Lists.DoubleList.class)) {
                    return o.getDoubleValue();
                }
                if (listClass.equals(Lists.LongList.class)) {
                    return o.getLongValue();
                }
                if (listClass.equals(Lists.LocalDateList.class)) {
                    return LocalDate.parse(o.getStringValue());
                }
                return o.getValue();
            }));
        }
        return switch (field.getType().getStandardType()) {
            case StandardSQLTypeName.BOOL -> (Object)fieldValue.getBooleanValue();
            case StandardSQLTypeName.INT64 -> (Object)fieldValue.getLongValue();
            case StandardSQLTypeName.FLOAT64 -> (Object)fieldValue.getDoubleValue();
            case StandardSQLTypeName.BYTES -> fieldValue.getBytesValue();
            case StandardSQLTypeName.DATE -> (Object)LocalDate.parse(fieldValue.getStringValue());
            default -> (Object)fieldValue.getValue();
        };
    }

    public List<String> supportedAggregationFunctions() {
        return SUPPORTED_AGGREGATION_FUNCTIONS;
    }

    public QueryRewriter queryRewriter() {
        return new BigQueryQueryRewriter(((BigQueryDatastore)this.datastore).getProjectId(), ((BigQueryDatastore)this.datastore).getDatasetName());
    }
}

