/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.query.database;

import io.squashql.query.BinaryOperator;
import io.squashql.query.database.QueryRewriter;
import io.squashql.query.database.SqlFunctions;
import io.squashql.query.database.SqlUtils;
import io.squashql.type.FunctionTypedField;
import io.squashql.type.TypedField;

public class BigQueryQueryRewriter
implements QueryRewriter {
    private final String projectId;
    private final String datasetName;

    public String functionExpression(FunctionTypedField ftf) {
        if (SqlFunctions.SUPPORTED_DATE_FUNCTIONS.contains(ftf.function())) {
            return String.format("EXTRACT(%s FROM %s)", ftf.function(), ftf.field().sqlExpression((QueryRewriter)this));
        }
        return super.functionExpression(ftf);
    }

    public String fieldName(String field) {
        return SqlUtils.backtickEscape((String)field);
    }

    public String tableName(String table) {
        return SqlUtils.backtickEscape((String)(this.projectId + "." + this.datasetName + "." + table));
    }

    public String escapeAlias(String alias) {
        return SqlUtils.backtickEscape((String)alias).replace("(", "_").replace(")", "_").replace(" ", "_");
    }

    public boolean usePartialRollupSyntax() {
        return false;
    }

    public String escapeSingleQuote(String s) {
        return SqlUtils.escapeSingleQuote((String)s, (String)"\\'");
    }

    public String grouping(TypedField f) {
        return this._select(f, false);
    }

    public String binaryOperation(BinaryOperator operator, String leftOperand, String rightOperand) {
        return switch (operator) {
            case BinaryOperator.DIVIDE -> "SAFE_DIVIDE" + "(" + leftOperand + ", " + rightOperand + ")";
            default -> super.binaryOperation(operator, leftOperand, rightOperand);
        };
    }

    public String arrayContains(TypedField field, Object value) {
        return value + " in unnest(" + field.sqlExpression((QueryRewriter)this) + ")";
    }

    public BigQueryQueryRewriter(String projectId, String datasetName) {
        this.projectId = projectId;
        this.datasetName = datasetName;
    }
}

