/*
 * Decompiled with CFR 0.152.
 */
package io.squashql;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import io.squashql.BigQueryDatastore;
import io.squashql.BigQueryServiceAccountDatastore;
import io.squashql.store.Store;
import java.sql.Date;
import java.time.Duration;
import java.util.Map;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;

public class BigQueryEndUserDatastore
implements BigQueryDatastore {
    private final OAuth2AuthorizedClientRepository authorizedClientRepository;
    private final Cache<String, Map<String, Store>> stores;
    private final String projectId;
    private final String datasetName;

    public BigQueryEndUserDatastore(OAuth2AuthorizedClientRepository authorizedClientRepository, String projectId, String datasetName) {
        this.authorizedClientRepository = authorizedClientRepository;
        this.projectId = projectId;
        this.datasetName = datasetName;
        this.stores = Caffeine.newBuilder().maximumSize(16L).expireAfterWrite(Duration.ofMinutes(5L)).build();
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getDatasetName() {
        return this.datasetName;
    }

    @Override
    public BigQuery getBigquery() {
        OAuth2AuthenticationToken token = this.getOAuth2AuthenticationToken();
        OAuth2AccessToken accessToken = this.authorizedClientRepository.loadAuthorizedClient(token.getAuthorizedClientRegistrationId(), (Authentication)token, null).getAccessToken();
        return (BigQuery)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setCredentials((Credentials)OAuth2Credentials.create((AccessToken)new AccessToken(accessToken.getTokenValue(), Date.from(accessToken.getExpiresAt()))))).setProjectId(this.projectId)).build().getService();
    }

    public Map<String, Store> storeByName() {
        OAuth2AuthenticationToken token = this.getOAuth2AuthenticationToken();
        return (Map)this.stores.get((Object)token.getPrincipal().getName(), name -> BigQueryServiceAccountDatastore.fetchStoresByName(this));
    }

    private OAuth2AuthenticationToken getOAuth2AuthenticationToken() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null) {
            throw new AuthenticationServiceException("not authenticated");
        }
        Authentication authentication = context.getAuthentication();
        if (authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken token = (OAuth2AuthenticationToken)authentication;
            return token;
        }
        throw new IllegalStateException("authentication type not expected: " + authentication.getClass());
    }
}

