/*
 * Decompiled with CFR 0.152.
 */
package io.squashql;

import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.StandardSQLTypeName;
import io.squashql.jdbc.JdbcUtil;
import io.squashql.list.Lists;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;

public final class BigQueryUtil {
    private BigQueryUtil() {
    }

    public static Class<?> bigQueryTypeToClass(Field field) {
        return BigQueryUtil._bigQueryTypeToClass(field, true);
    }

    private static Class<?> _bigQueryTypeToClass(Field field, boolean top) {
        if (top && field.getMode() == Field.Mode.REPEATED) {
            return JdbcUtil.getListClassFromElementClass(BigQueryUtil._bigQueryTypeToClass(field, false));
        }
        LegacySQLTypeName dataType = field.getType();
        return switch (dataType.getStandardType()) {
            case StandardSQLTypeName.BOOL -> Boolean.TYPE;
            case StandardSQLTypeName.INT64 -> Long.TYPE;
            case StandardSQLTypeName.FLOAT64 -> Double.TYPE;
            case StandardSQLTypeName.STRING -> String.class;
            case StandardSQLTypeName.BYTES -> Byte.TYPE;
            case StandardSQLTypeName.DATE -> LocalDate.class;
            case StandardSQLTypeName.DATETIME -> LocalDateTime.class;
            default -> Object.class;
        };
    }

    public static StandardSQLTypeName classToBigQueryType(Class<?> clazz) {
        StandardSQLTypeName type;
        if (clazz.equals(String.class)) {
            type = StandardSQLTypeName.STRING;
        } else if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            type = StandardSQLTypeName.FLOAT64;
        } else if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            type = StandardSQLTypeName.FLOAT64;
        } else if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            type = StandardSQLTypeName.INT64;
        } else if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            type = StandardSQLTypeName.INT64;
        } else if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            type = StandardSQLTypeName.BOOL;
        } else if (clazz.equals(LocalDate.class)) {
            type = StandardSQLTypeName.DATE;
        } else if (clazz.equals(LocalDateTime.class)) {
            type = StandardSQLTypeName.DATETIME;
        } else if (clazz.equals(Lists.LongList.class)) {
            type = StandardSQLTypeName.ARRAY;
        } else if (clazz.equals(Lists.StringList.class)) {
            type = StandardSQLTypeName.ARRAY;
        } else {
            throw new IllegalArgumentException("Unsupported field type " + clazz);
        }
        return type;
    }

    public static ServiceAccountCredentials createCredentialsFromFile(String path) {
        try {
            InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            if (resourceAsStream == null) {
                resourceAsStream = new FileInputStream(path);
            }
            return ServiceAccountCredentials.fromStream((InputStream)resourceAsStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ServiceAccountCredentials createCredentialsFromFileContent(String jsonKey) {
        try {
            return ServiceAccountCredentials.fromStream((InputStream)new ByteArrayInputStream(jsonKey.getBytes()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

