/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.query.database;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableResult;
import io.squashql.BigQueryDatastore;
import io.squashql.BigQueryUtil;
import io.squashql.jackson.JacksonUtil;
import io.squashql.query.Header;
import io.squashql.query.QueryExecutor;
import io.squashql.query.database.AQueryEngine;
import io.squashql.query.database.DatabaseQuery;
import io.squashql.query.database.QueryAwareQueryRewriter;
import io.squashql.query.database.QueryEngine;
import io.squashql.query.database.QueryRewriter;
import io.squashql.query.database.SQLTranslator;
import io.squashql.query.database.SqlUtils;
import io.squashql.query.dto.VirtualTableDto;
import io.squashql.store.Datastore;
import io.squashql.store.TypedField;
import io.squashql.table.ColumnarTable;
import io.squashql.table.RowTable;
import io.squashql.table.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

public class BigQueryEngine
extends AQueryEngine<BigQueryDatastore> {
    public static final List<String> SUPPORTED_AGGREGATION_FUNCTIONS = List.of("any_value", "avg", "corr", "count", "covar_pop", "covar_samp", "min", "max", "stddev_pop", "stddev_samp", "sum", "var_pop", "var_samp", "variance");

    public BigQueryEngine(BigQueryDatastore datastore) {
        super((Datastore)datastore, (QueryRewriter)new BigQueryQueryRewriter(datastore.getProjectId(), datastore.getDatasetName()));
    }

    protected String createSqlStatement(DatabaseQuery query, QueryExecutor.PivotTableContext context) {
        boolean hasRollup = !query.rollup.isEmpty();
        BigQueryQueryRewriter rewriter = (BigQueryQueryRewriter)this.queryRewriter;
        Function queryFieldSupplier = QueryExecutor.createQueryFieldSupplier((QueryEngine)this, (VirtualTableDto)query.virtualTableDto);
        if (!query.groupingSets.isEmpty()) {
            ArrayList l = new ArrayList(context.getRowFields());
            l.addAll(context.getColumnFields());
            ArrayList rollups = new ArrayList();
            rollups.add(l);
            for (int i = 0; i < context.getRowFields().size(); ++i) {
                ArrayList copy = new ArrayList(context.getRowFields());
                copy.addAll(i, context.getColumnFields());
                rollups.add(copy);
            }
            StringBuilder sb = new StringBuilder();
            String unionDistinct = " union distinct ";
            for (int i = 0; i < rollups.size(); ++i) {
                boolean isNotLast;
                DatabaseQuery deepCopy = (DatabaseQuery)JacksonUtil.deserialize((String)JacksonUtil.serialize((Object)query), DatabaseQuery.class);
                deepCopy.groupingSets = Collections.emptyList();
                deepCopy.rollup = (List)rollups.get(i);
                boolean bl = isNotLast = i < rollups.size() - 1;
                if (isNotLast) {
                    deepCopy.limit = -1;
                }
                sb.append(this.createSqlStatement(deepCopy, null));
                if (!isNotLast) continue;
                sb.append(unionDistinct);
            }
            return sb.toString();
        }
        if (!hasRollup) {
            return SQLTranslator.translate((DatabaseQuery)query, (Function)queryFieldSupplier, (QueryRewriter)rewriter);
        }
        SQLTranslator.checkRollupIsValid(query.select.stream().map(f -> this.queryRewriter.select(f)).toList(), query.rollup.stream().map(f -> this.queryRewriter.rollup(f)).toList());
        final QueryAwareQueryRewriter qr = new QueryAwareQueryRewriter((QueryRewriter)rewriter, query);
        BigQueryQueryRewriter newRewriter = new BigQueryQueryRewriter(rewriter.projectId, rewriter.datasetName){

            public String select(TypedField field) {
                Function quoter = SQLTranslator.getQuoteFn((TypedField)field);
                return String.format("coalesce(%s, %s)", qr.select(field), quoter.apply(BigQueryUtil.getNullValue(field.type())));
            }

            public String rollup(TypedField field) {
                Function quoter = SQLTranslator.getQuoteFn((TypedField)field);
                return String.format("coalesce(%s, %s)", qr.rollup(field), quoter.apply(BigQueryUtil.getNullValue(field.type())));
            }

            @Override
            public String getFieldFullName(TypedField f) {
                return qr.getFieldFullName(f);
            }
        };
        ArrayList missingColumnsInRollup = new ArrayList(query.select);
        missingColumnsInRollup.removeAll(query.rollup);
        DatabaseQuery deepCopy = (DatabaseQuery)JacksonUtil.deserialize((String)JacksonUtil.serialize((Object)query), DatabaseQuery.class);
        missingColumnsInRollup.addAll(query.rollup);
        deepCopy.rollup = missingColumnsInRollup;
        return SQLTranslator.translate((DatabaseQuery)deepCopy, (Function)queryFieldSupplier, q -> q.rollup.isEmpty() ? this.queryRewriter : newRewriter);
    }

    protected Table postProcessDataset(Table input, DatabaseQuery query) {
        ArrayList newValues;
        int rowIndex;
        List columnValues;
        if (query.rollup.isEmpty() && query.groupingSets.isEmpty()) {
            return input;
        }
        boolean isPartialRollup = !Set.copyOf(query.select).equals(Set.copyOf(query.rollup));
        ArrayList missingColumnsInRollup = new ArrayList(query.select);
        missingColumnsInRollup.removeAll(query.rollup);
        Set missingColumnsInRollupSet = missingColumnsInRollup.stream().map(SqlUtils::getFieldFullName).collect(Collectors.toSet());
        IntHashSet rowIndicesToRemove = new IntHashSet();
        for (int i = 0; i < input.headers().size(); ++i) {
            Header h = (Header)input.headers().get(i);
            columnValues = input.getColumn(i);
            if (i >= query.select.size()) continue;
            List baseColumnValues = input.getColumnValues(h.name());
            rowIndex = 0;
            while ((long)rowIndex < input.count()) {
                Object value = columnValues.get(rowIndex);
                if (value == null) {
                    baseColumnValues.set(rowIndex, "___total___");
                    if (query.groupingSets.isEmpty() && isPartialRollup && missingColumnsInRollupSet.contains(h.name())) {
                        rowIndicesToRemove.add(rowIndex);
                    }
                } else if (value.equals(BigQueryUtil.getNullValue(h.type()))) {
                    baseColumnValues.set(rowIndex, null);
                }
                ++rowIndex;
            }
        }
        if (!rowIndicesToRemove.isEmpty()) {
            newValues = new ArrayList(input.headers().size());
            for (int col = 0; col < input.headers().size(); ++col) {
                columnValues = input.getColumn(col);
                ArrayList newColumnValues = new ArrayList(columnValues.size() - rowIndicesToRemove.size());
                rowIndex = 0;
                while ((long)rowIndex < input.count()) {
                    if (!rowIndicesToRemove.contains(rowIndex)) {
                        newColumnValues.add(columnValues.get(rowIndex));
                    }
                    ++rowIndex;
                }
                newValues.add(newColumnValues);
            }
        } else {
            newValues = ((ColumnarTable)input).getColumns();
        }
        return new ColumnarTable(input.headers(), input.measures(), newValues);
    }

    protected Table retrieveAggregates(DatabaseQuery query, String sql) {
        QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)sql).build();
        try {
            TableResult tableResult = ((BigQueryDatastore)this.datastore).getBigquery().query(queryConfig, new BigQuery.JobOption[0]);
            Schema schema = tableResult.getSchema();
            Pair result = BigQueryEngine.transformToColumnFormat((DatabaseQuery)query, (List)schema.getFields(), (column, name) -> name, (column, name) -> BigQueryUtil.bigQueryTypeToClass(column.getType()), tableResult.iterateAll().iterator(), (i, fieldValueList) -> BigQueryEngine.getTypeValue(fieldValueList, schema, i), (QueryRewriter)this.queryRewriter);
            return new ColumnarTable((List)result.getOne(), new HashSet(query.measures), (List)result.getTwo());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Table executeRawSql(String sql) {
        QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)sql).build();
        try {
            TableResult tableResult = ((BigQueryDatastore)this.datastore).getBigquery().query(queryConfig, new BigQuery.JobOption[0]);
            Schema schema = tableResult.getSchema();
            Pair result = BigQueryEngine.transformToRowFormat((List)schema.getFields(), column -> column.getName(), column -> BigQueryUtil.bigQueryTypeToClass(column.getType()), tableResult.iterateAll().iterator(), (i, fieldValueList) -> BigQueryEngine.getTypeValue(fieldValueList, schema, i));
            return new RowTable((List)result.getOne(), (List)result.getTwo());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getTypeValue(FieldValueList fieldValues, Schema schema, int index) {
        FieldValue fieldValue = fieldValues.get(index);
        if (fieldValue.isNull()) {
            return null;
        }
        Field field = schema.getFields().get(index);
        return switch (field.getType().getStandardType()) {
            case StandardSQLTypeName.BOOL -> (Object)fieldValue.getBooleanValue();
            case StandardSQLTypeName.INT64 -> (Object)fieldValue.getLongValue();
            case StandardSQLTypeName.FLOAT64 -> (Object)fieldValue.getDoubleValue();
            case StandardSQLTypeName.BYTES -> fieldValue.getBytesValue();
            default -> (Object)fieldValue.getValue();
        };
    }

    public List<String> supportedAggregationFunctions() {
        return SUPPORTED_AGGREGATION_FUNCTIONS;
    }

    static class BigQueryQueryRewriter
    implements QueryRewriter {
        private final String projectId;
        private final String datasetName;

        BigQueryQueryRewriter(String projectId, String datasetName) {
            this.projectId = projectId;
            this.datasetName = datasetName;
        }

        public String getFieldFullName(TypedField f) {
            return SqlUtils.getFieldFullName((String)(f.store() == null ? null : this.tableName(f.store())), (String)this.fieldName(f.name()));
        }

        public String fieldName(String field) {
            return SqlUtils.backtickEscape((String)field);
        }

        public String tableName(String table) {
            return SqlUtils.backtickEscape((String)(this.projectId + "." + this.datasetName + "." + table));
        }

        public String measureAlias(String alias) {
            return SqlUtils.backtickEscape((String)alias).replace("(", "_").replace(")", "_").replace(" ", "_");
        }

        public boolean usePartialRollupSyntax() {
            return false;
        }

        public boolean useGroupingFunction() {
            return false;
        }
    }
}

