/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.transaction;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import io.squashql.BigQueryServiceAccountDatastore;
import io.squashql.BigQueryUtil;
import io.squashql.transaction.TransactionManager;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.collections.impl.list.immutable.ImmutableListFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryTransactionManager
implements TransactionManager {
    private static final Logger log = LoggerFactory.getLogger(BigQueryTransactionManager.class);
    private static final int MAX_SLEEPS = 5;
    final BigQuery bigquery;
    final String datasetName;

    public BigQueryTransactionManager(BigQuery bigquery, String datasetName) {
        this.bigquery = bigquery;
        this.datasetName = datasetName;
    }

    public BigQuery getBigQuery() {
        return this.bigquery;
    }

    public void dropAndCreateInMemoryTable(String tableName, List<io.squashql.store.Field> fields) {
        List list = ImmutableListFactoryImpl.INSTANCE.ofAll(fields).newWith((Object)new io.squashql.store.Field(tableName, "scenario", String.class)).castToList();
        TableId tableId = TableId.of((String)this.datasetName, (String)tableName);
        List<Field> fieldList = list.stream().map(f -> Field.of((String)f.name(), (StandardSQLTypeName)BigQueryUtil.classToBigQueryType(f.type()), (Field[])new Field[0])).toList();
        Schema schema = Schema.of(fieldList);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)schema);
        TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDefinition).build();
        try {
            this.bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        }
        catch (BigQueryException e) {
            if (e.getCode() == 409 && e.getReason().equals("duplicate")) {
                this.bigquery.delete(tableId);
                this.bigquery.create(tableInfo, new BigQuery.TableOption[0]);
            }
            throw e;
        }
    }

    public void load(String scenario, String store, List<Object[]> tuples) {
        this.ensureScenarioColumnIsPresent(store);
        List<io.squashql.store.Field> fields = BigQueryServiceAccountDatastore.getFieldsOrNull(this.bigquery, this.datasetName, store);
        ArrayList<InsertAllRequest.RowToInsert> list = new ArrayList<InsertAllRequest.RowToInsert>();
        for (Object[] tuple : tuples) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            for (int i = 0; i < fields.size(); ++i) {
                String name = fields.get(i).name();
                if (!name.equals("scenario")) {
                    Iterator o = tuple[i];
                    if (o != null && (o.getClass().equals(LocalDate.class) || o.getClass().equals(LocalDateTime.class))) {
                        o = o.toString();
                    }
                    m.put(name, o);
                    continue;
                }
                m.put(name, scenario);
            }
            list.add(InsertAllRequest.RowToInsert.of(m));
        }
        TableId tableId = TableId.of((String)this.datasetName, (String)store);
        Table table = this.bigquery.getTable(tableId, new BigQuery.TableOption[0]);
        int sleepTime = 1;
        int attempt = 0;
        while (true) {
            try {
                InsertAllResponse response = table.insert(list);
                if (response.hasErrors()) {
                    for (Map.Entry entry : response.getInsertErrors().entrySet()) {
                        System.out.println("Response error: \n" + entry.getValue());
                    }
                    throw new RuntimeException("error while inserting rows, see above");
                }
                return;
            }
            catch (BigQueryException exception) {
                try {
                    Thread.sleep(sleepTime * 1000);
                }
                catch (InterruptedException e) {
                    log.error("", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                if (attempt < 5) {
                    sleepTime <<= 1;
                    log.info("table.insert, retry " + ++attempt);
                    continue;
                }
                log.info("table.insert after 5 attempts. Abort.");
                throw exception;
            }
            break;
        }
    }

    private void ensureScenarioColumnIsPresent(String store) {
        List<io.squashql.store.Field> fields = BigQueryServiceAccountDatastore.getFieldsOrNull(this.bigquery, this.datasetName, store);
        boolean found = fields.stream().anyMatch(f -> f.name().equals("scenario"));
        if (!found) {
            throw new RuntimeException(String.format("%s field not found", "scenario"));
        }
    }

    public void loadCsv(String scenario, String store, String path, String delimiter, boolean header) {
        throw new RuntimeException("not impl. yet");
    }
}

