/*
 * Decompiled with CFR 0.152.
 */
package io.squashql;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.common.base.Suppliers;
import io.squashql.BigQueryDatastore;
import io.squashql.BigQueryUtil;
import io.squashql.store.Field;
import io.squashql.store.Store;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class BigQueryServiceAccountDatastore
implements BigQueryDatastore {
    private final Supplier<Map<String, Store>> stores;
    private final BigQuery bigquery;
    private final String projectId;
    private final String datasetName;

    public BigQueryServiceAccountDatastore(ServiceAccountCredentials credentials, String projectId, String datasetName) {
        this.projectId = projectId;
        this.datasetName = datasetName;
        BigQueryOptions build = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(projectId)).setCredentials((Credentials)credentials)).build();
        build.setThrowNotFound(true);
        this.bigquery = (BigQuery)build.getService();
        this.stores = Suppliers.memoize(() -> BigQueryServiceAccountDatastore.fetchStoresByName(this));
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getDatasetName() {
        return this.datasetName;
    }

    @Override
    public BigQuery getBigquery() {
        return this.bigquery;
    }

    public Map<String, Store> storesByName() {
        return this.stores.get();
    }

    public static Map<String, Store> fetchStoresByName(BigQueryDatastore datastore) {
        BigQuery bigquery = datastore.getBigquery();
        String datasetName = datastore.getDatasetName();
        return BigQueryServiceAccountDatastore.getTableNames(bigquery, datastore.getProjectId(), datasetName).stream().collect(HashMap::new, (map, table) -> {
            List<Field> fields = BigQueryServiceAccountDatastore.getFieldsOrNull(bigquery, datasetName, table);
            if (fields != null) {
                map.put(table, new Store(table, fields));
            }
        }, (x, y) -> {});
    }

    public static Collection<String> getTableNames(BigQuery query, String projectId, String datasetName) {
        Page tablePage = query.listTables(datasetName, new BigQuery.TableListOption[0]);
        HashSet<String> tableNames = new HashSet<String>();
        Iterator iterator = tablePage.getValues().iterator();
        while (iterator.hasNext()) {
            tableNames.add(((Table)iterator.next()).getTableId().getTable());
        }
        return tableNames;
    }

    public static List<Field> getFieldsOrNull(BigQuery query, String datasetName, String tableName) {
        ArrayList<Field> fields = new ArrayList<Field>();
        try {
            Schema schema = query.getTable(datasetName, tableName, new BigQuery.TableOption[0]).getDefinition().getSchema();
            for (com.google.cloud.bigquery.Field field : schema.getFields()) {
                fields.add(new Field(tableName, field.getName(), BigQueryUtil.bigQueryTypeToClass(field.getType())));
            }
            return fields;
        }
        catch (Exception e) {
            BigQueryException bqe;
            if (e instanceof BigQueryException && (bqe = (BigQueryException)((Object)e)).getCode() == 403) {
                return null;
            }
            throw e;
        }
    }
}

