/*
 * Decompiled with CFR 0.152.
 */
package io.squark.yggdrasil.maven.plugin;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.squark.yggdrasil.core.api.model.ProviderConfiguration;
import io.squark.yggdrasil.core.api.model.YggdrasilConfiguration;
import io.squark.yggdrasil.core.api.model.YggdrasilDependency;
import io.squark.yggdrasil.maven.provider.api.YggdrasilDependencyMavenUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.jetbrains.annotations.Nullable;

@Mojo(name="package-yggdrasil", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageYggdrasilMojo
extends AbstractMojo {
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(property="yggdrasil.classesDir", defaultValue="classes")
    private String classesDir;
    @Parameter(property="yggdrasil.configFile", defaultValue="classes/META-INF/yggdrasil.json")
    private String configFile;
    @Parameter(property="yggdrasil.dependencyResolutionProvider", defaultValue="maven")
    private String dependencyResolutionProviderString;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper mavenProjectHelper;
    @Parameter(defaultValue="${repositorySystem}")
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(readonly=true, defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(property="yggdrasil.manifest")
    private Map<String, Object> manifest;
    @Parameter(property="yggdrasil.mainClass")
    private String mainClass;
    @Parameter(property="yggdrasil.exclusions")
    private List<String> exclusions;
    @Parameter(property="yggdrasil.includeLogger", defaultValue="true")
    private boolean includeLogger;
    @Parameter(property="yggdrasil.providerConfigurations")
    private HashSet<ProviderConfiguration> providerConfigurations;
    @Parameter(property="yggdrasil.loadTransitiveProvidedDependencies", defaultValue="false")
    private boolean loadTransitiveProvidedDependencies;
    private List<String> addedResources = new ArrayList<String>();
    private Multimap<String, String> duplicates = HashMultimap.create();
    private Map<String, AddedTarget> addedJars = new HashMap<String, AddedTarget>();
    @Parameter(property="yggdrasil.nestedJarClassLoaderVersion", defaultValue="0.1.10")
    private String nestedJarClassLoaderVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File configFile = this.buildConfigurationFile();
        Manifest manifest = this.generateAndReturnManifest();
        try (JarOutputStream targetJarOutputStream = this.createTargetJar(manifest);){
            this.addProjectArtifactAndConfig(targetJarOutputStream, configFile);
            this.addCompileDependencies(targetJarOutputStream);
            this.addSelfDependencies(targetJarOutputStream);
            targetJarOutputStream.close();
            this.logDuplicates();
            this.mavenProjectHelper.attachArtifact(this.project, this.project.getArtifact().getType(), "yggdrasil", new File(this.outputDirectory + "/" + this.getTargetJarName()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create target jar", (Exception)e);
        }
    }

    private void addProjectArtifactAndConfig(JarOutputStream targetJarOutputStream, File configFile) throws MojoExecutionException {
        File baseDir = new File(this.outputDirectory, this.classesDir);
        if (baseDir.exists()) {
            try {
                File artifactFile = this.project.getArtifact().getFile();
                if (artifactFile == null) {
                    throw new MojoExecutionException("Could not find project artifact. Ran goal before package phase?");
                }
                String name = this.project.getArtifactId() + "-" + this.project.getVersion();
                JarEntry localJarEntry = new JarEntry("META-INF/lib/" + name + "-classes.jar");
                localJarEntry.setLastModifiedTime(FileTime.fromMillis(artifactFile.lastModified()));
                this.addResource(new FileInputStream(artifactFile), localJarEntry, targetJarOutputStream);
                JarEntry configFileEntry = new JarEntry("META-INF/" + configFile.getName());
                configFileEntry.setLastModifiedTime(FileTime.fromMillis(artifactFile.lastModified()));
                this.addResource(new FileInputStream(configFile), configFileEntry, targetJarOutputStream);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to build local dependency jar", (Exception)e);
            }
        }
    }

    private String getTargetJarName() {
        return this.project.getArtifactId() + "-" + this.project.getVersion() + "-yggdrasil." + this.project.getPackaging();
    }

    private JarOutputStream createTargetJar(Manifest manifest) throws IOException {
        String jarName = this.getTargetJarName();
        return new JarOutputStream((OutputStream)new FileOutputStream(this.outputDirectory + "/" + jarName), manifest);
    }

    private void add(JarFile sourceJarFile, JarEntry sourceJarEntry, JarOutputStream targetJarOutputStream, String sourceName) throws MojoExecutionException {
        if (sourceJarEntry.isDirectory()) {
            this.addDirectory(sourceJarEntry.getName(), targetJarOutputStream);
        } else {
            this.addResource(sourceJarFile, sourceJarEntry, targetJarOutputStream, sourceName);
        }
    }

    private void logDuplicates() {
        HashMultimap overlapping = HashMultimap.create((int)20, (int)15);
        for (String file : this.duplicates.keySet()) {
            Collection resources = this.duplicates.get((Object)file);
            if (resources.size() <= 1) continue;
            overlapping.put((Object)resources, (Object)file);
        }
        this.getLog().warn((CharSequence)"Some resources are contained in two or more JARs. This is usually safe put may cause undefined behaviour if different versions of resources are expected");
        for (Collection jarz : overlapping.keySet()) {
            LinkedList<String> jarzStrings = new LinkedList<String>();
            for (String file : jarz) {
                jarzStrings.add(file);
            }
            List classes = overlapping.get((Object)jarz).stream().map(clazz -> clazz.replace(".class", "")).collect(Collectors.toCollection(LinkedList::new));
            this.getLog().warn((CharSequence)(Joiner.on((String)", ").join(jarzStrings) + " define " + classes.size() + " overlapping resource(s): "));
            int max = 10;
            for (int i = 0; i < Math.min(max, classes.size()); ++i) {
                this.getLog().warn((CharSequence)("  - " + (String)classes.get(i)));
            }
            if (classes.size() <= max) continue;
            this.getLog().warn((CharSequence)("  - " + (classes.size() - max) + " more..."));
        }
    }

    private void addResource(File file, JarOutputStream targetJarOutputStream, String targetName) throws MojoExecutionException {
        if (this.addedResources.contains(file.getName())) {
            return;
        }
        this.addedResources.add(file.getName());
        JarEntry targetJarEntry = new JarEntry(targetName);
        targetJarEntry.setTime(file.lastModified());
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.addResource(inputStream, targetJarEntry, targetJarOutputStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to add jar " + file.getPath(), (Exception)e);
        }
    }

    private void addResource(JarFile sourceJarFile, JarEntry sourceJarEntry, JarOutputStream targetJarOutputStream, String sourceName) throws MojoExecutionException {
        String name = sourceJarEntry.getName();
        this.duplicates.put((Object)name, (Object)sourceName);
        if (this.addedResources.contains(name)) {
            return;
        }
        if (name.matches("META-INF\\/.*\\.(RSA|SF|DSA)")) {
            this.getLog().warn((CharSequence)("Excluding " + name + " to workaround signature issues."));
            return;
        }
        JarEntry targetJarEntry = new JarEntry(name);
        targetJarEntry.setTime(sourceJarEntry.getTime());
        try (InputStream in = sourceJarFile.getInputStream(sourceJarEntry);){
            this.addResource(in, targetJarEntry, targetJarOutputStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy jar entry " + name + " from jar " + sourceJarFile.getName(), (Exception)e);
        }
        this.addedResources.add(name);
    }

    private void addResource(InputStream in, JarEntry targetJarEntry, JarOutputStream targetJarOutputStream) throws IOException {
        targetJarOutputStream.putNextEntry(targetJarEntry);
        IOUtil.copy((InputStream)in, (OutputStream)targetJarOutputStream);
        targetJarOutputStream.closeEntry();
    }

    private void addDirectory(String name, JarOutputStream targetJarOutputStream) throws MojoExecutionException {
        String parent;
        if (name.lastIndexOf(47) > 0 && !this.addedResources.contains(parent = name.substring(0, name.lastIndexOf(47)))) {
            this.addDirectory(parent, targetJarOutputStream);
        }
        if (!name.endsWith("/")) {
            name = name + "/";
        }
        if (this.addedResources.contains(name)) {
            return;
        }
        JarEntry entry = new JarEntry(name);
        try {
            targetJarOutputStream.putNextEntry(entry);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to add directory " + name, (Exception)e);
        }
        this.addedResources.add(name);
    }

    private Manifest generateAndReturnManifest() throws MojoExecutionException {
        Manifest manifest;
        File manifestFile = new File(new File(this.outputDirectory, this.classesDir), "META-INF/MANIFEST.MF");
        if (manifestFile.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(manifestFile);
                manifest = new Manifest(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException(e.getMessage());
            }
        } else {
            manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().put(new Attributes.Name("Build-Jdk"), System.getProperty("java.version"));
        }
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, "io.squark.yggdrasil.core.main.Bootstrap");
        manifest.getMainAttributes().put(new Attributes.Name("Yggdrasil-Version"), this.pluginDescriptor.getVersion());
        return manifest;
    }

    private File buildConfigurationFile() throws MojoExecutionException {
        YggdrasilConfiguration yggdrasilConfiguration = new YggdrasilConfiguration();
        YggdrasilDependency yggdrasilDependency = this.getProjectProvidedDependencies();
        yggdrasilConfiguration.setDependencies(yggdrasilDependency.getChildDependencies());
        yggdrasilConfiguration.setYggdrasilVersion(this.pluginDescriptor.getVersion());
        yggdrasilConfiguration.setLoadTransitiveProvidedDependencies(this.loadTransitiveProvidedDependencies);
        String classesJar = "META-INF/lib/" + this.project.getArtifactId() + "-" + this.project.getVersion() + "-classes.jar";
        yggdrasilConfiguration.setClassesJar(classesJar);
        if (StringUtils.isNotEmpty((CharSequence)this.mainClass)) {
            yggdrasilConfiguration.setMainClass(this.mainClass);
        }
        this.validateProviderConfigurations();
        yggdrasilConfiguration.setProviderConfigurations(this.providerConfigurations);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)yggdrasilConfiguration);
        File configurationFile = new File(this.outputDirectory, this.configFile);
        if (!configurationFile.exists()) {
            try {
                configurationFile.getParentFile().mkdirs();
                configurationFile.createNewFile();
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException(e.getMessage());
            }
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(configurationFile);
            outputStream.write(json.getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        return configurationFile;
    }

    private void validateProviderConfigurations() throws MojoExecutionException {
        if (this.providerConfigurations != null) {
            for (ProviderConfiguration providerConfiguration : this.providerConfigurations) {
                if (providerConfiguration.getIdentifier() == null) {
                    throw new MojoExecutionException("ProviderConfiguration must supply identifier");
                }
                if (providerConfiguration.getProperties() != null) continue;
                throw new MojoExecutionException("ProviderConfiguration must supply properties");
            }
        }
    }

    private void addCompileDependencies(JarOutputStream jarOutputStream) throws MojoExecutionException, MojoFailureException, IOException {
        List dependencies = this.project.getDependencies();
        for (Dependency dependency : dependencies) {
            this.addDependency(dependency, jarOutputStream, true, false, "META-INF/lib/", null);
        }
    }

    private DependencyNode resolveDependency(Dependency dependency) throws MojoExecutionException {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new org.eclipse.aether.graph.Dependency((Artifact)new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), (ArtifactType)new DefaultArtifactType(dependency.getType())), dependency.getScope()));
        collectRequest.setRepositories(this.remoteRepositories);
        try {
            CollectResult collectResult = this.repositorySystem.collectDependencies(this.repositorySystemSession, collectRequest);
            DependencyNode node = collectResult.getRoot();
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setFilter((DependencyFilter)new ScopeDependencyFilter(null));
            dependencyRequest.setRoot(node);
            this.repositorySystem.resolveDependencies(this.repositorySystemSession, dependencyRequest);
            return node;
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private DependencyNode addDependency(Dependency dependency, JarOutputStream jarOutputStream, boolean asJar, boolean addAsRef, String pathIfJar, @Nullable String jarOverrideName) throws MojoExecutionException {
        try {
            DependencyNode node = this.resolveDependency(dependency);
            if (asJar) {
                this.addNodeAsJar(node, jarOutputStream, addAsRef, pathIfJar, jarOverrideName);
            } else {
                this.addNodeAsClasses(node, jarOutputStream);
            }
            return node;
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void addSelfDependencies(JarOutputStream targetJarOutputStream) throws MojoFailureException, MojoExecutionException {
        this.addDependency(this.getApiDependency(), targetJarOutputStream, true, false, "META-INF/lib/", null);
        this.addDependency(this.getCoreDependency(), targetJarOutputStream, true, true, "META-INF/yggdrasil-runtime-lib/", null);
        this.addDependency(this.getDependencyResolutionProvider(), targetJarOutputStream, true, true, "META-INF/yggdrasil-runtime-lib/", null);
        String fallbackName = "yggdrasil-logging-fallback.jar";
        this.addDependency(this.getLoggingFallback(), targetJarOutputStream, true, false, "META-INF/yggdrasil-optional-lib/", fallbackName);
        this.addDependency(this.getBootstrapDependency(), targetJarOutputStream, false, false, null, null);
        this.addDependency(this.getClassLoaderDependency(), targetJarOutputStream, false, false, null, null);
    }

    private Dependency getBootstrapDependency() {
        String yggdrasilVersion = this.pluginDescriptor.getVersion();
        Dependency coreDependency = new Dependency();
        coreDependency.setGroupId("io.squark.yggdrasil");
        coreDependency.setArtifactId("yggdrasil-bootstrap");
        coreDependency.setVersion(yggdrasilVersion);
        coreDependency.setScope("compile");
        return coreDependency;
    }

    private Dependency getClassLoaderDependency() {
        String yggdrasilVersion = this.pluginDescriptor.getVersion();
        Dependency coreDependency = new Dependency();
        coreDependency.setGroupId("io.squark");
        coreDependency.setArtifactId("nested-jar-classloader");
        coreDependency.setVersion(this.nestedJarClassLoaderVersion);
        coreDependency.setScope("compile");
        return coreDependency;
    }

    private Dependency getCoreDependency() {
        String yggdrasilVersion = this.pluginDescriptor.getVersion();
        Dependency coreDependency = new Dependency();
        coreDependency.setGroupId("io.squark.yggdrasil");
        coreDependency.setArtifactId("yggdrasil-core");
        coreDependency.setVersion(yggdrasilVersion);
        coreDependency.setScope("compile");
        return coreDependency;
    }

    private Dependency getApiDependency() {
        String yggdrasilVersion = this.pluginDescriptor.getVersion();
        Dependency apiDependency = new Dependency();
        apiDependency.setGroupId("io.squark.yggdrasil");
        apiDependency.setArtifactId("yggdrasil-api");
        apiDependency.setVersion(yggdrasilVersion);
        apiDependency.setScope("compile");
        return apiDependency;
    }

    private Dependency getDependencyResolutionProvider() throws MojoFailureException {
        String version;
        String artifactId;
        String groupId;
        switch (this.dependencyResolutionProviderString) {
            case "maven": {
                groupId = "io.squark.yggdrasil";
                artifactId = "yggdrasil-maven-provider";
                version = this.pluginDescriptor.getVersion();
                break;
            }
            default: {
                String[] descriptor = this.dependencyResolutionProviderString.split(":");
                if (descriptor.length != 3) {
                    throw new MojoFailureException("Bad format dependencyResolutionProvider. Expected \"groupId:artifactId:version\". Got " + this.dependencyResolutionProviderString);
                }
                groupId = descriptor[0];
                artifactId = descriptor[1];
                version = descriptor[2];
            }
        }
        Dependency dependencyResolutionProviderDependency = new Dependency();
        dependencyResolutionProviderDependency.setGroupId(groupId);
        dependencyResolutionProviderDependency.setArtifactId(artifactId);
        dependencyResolutionProviderDependency.setVersion(version);
        dependencyResolutionProviderDependency.setScope("compile");
        return dependencyResolutionProviderDependency;
    }

    private Dependency getLoggingFallback() {
        Dependency loggingFallbackDependency = new Dependency();
        String yggdrasilVersion = this.pluginDescriptor.getVersion();
        loggingFallbackDependency.setGroupId("io.squark.yggdrasil.yggdrasil-logging");
        loggingFallbackDependency.setArtifactId("yggdrasil-logging-fallback");
        loggingFallbackDependency.setVersion(yggdrasilVersion);
        loggingFallbackDependency.setScope("compile");
        return loggingFallbackDependency;
    }

    private YggdrasilDependency getProjectProvidedDependencies() throws MojoExecutionException {
        List mavenDependencies = this.project.getDependencies();
        if (this.exclusions == null || this.exclusions.size() == 0) {
            this.exclusions = new ArrayList<String>();
        }
        YggdrasilDependency rootDependency = new YggdrasilDependency(this.project.getGroupId(), this.project.getArtifactId(), null, this.project.getVersion(), null);
        ConcurrentHashMap<DefaultArtifact, String> dependencyArtifacts = new ConcurrentHashMap<DefaultArtifact, String>();
        for (Dependency dependency : mavenDependencies) {
            if (!"provided".equals(dependency.getScope()) || Boolean.parseBoolean(dependency.getOptional())) continue;
            dependencyArtifacts.put(new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), (ArtifactType)new DefaultArtifactType(dependency.getType())), dependency.getScope());
        }
        DefaultRepositorySystemSession repositorySystemSession = new DefaultRepositorySystemSession(this.repositorySystemSession);
        AndDependencySelector depFilter = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test", "compile", "runtime", "system"}), new OptionalDependencySelector(), new ExclusionDependencySelector()});
        repositorySystemSession.setDependencySelector((DependencySelector)depFilter);
        for (Map.Entry entry : dependencyArtifacts.entrySet()) {
            YggdrasilDependency yggdrasilDependency;
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new org.eclipse.aether.graph.Dependency((Artifact)entry.getKey(), (String)entry.getValue()));
            collectRequest.setRepositories(this.remoteRepositories);
            try {
                CollectResult collectResult = this.repositorySystem.collectDependencies((RepositorySystemSession)repositorySystemSession, collectRequest);
                DependencyNode node = collectResult.getRoot();
                yggdrasilDependency = YggdrasilDependencyMavenUtil.fromDependencyNode((DependencyNode)node, this.exclusions);
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException(e.getMessage());
            }
            rootDependency.addChildDependency(yggdrasilDependency);
        }
        return rootDependency;
    }

    private void addNodeAsClasses(DependencyNode node, JarOutputStream targetJarOutputStream) throws MojoExecutionException {
        JarFile jar;
        if (!"compile".equals(node.getDependency().getScope()) || node.getDependency().getOptional().booleanValue()) {
            return;
        }
        try {
            jar = new JarFile(node.getArtifact().getFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to get jar " + node.getArtifact().getFile().getPath(), (Exception)e);
        }
        Enumeration<JarEntry> enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry sourceEntry = enumEntries.nextElement();
            String name = sourceEntry.getName();
            if (name.startsWith("java/") || name.startsWith("com/sun/") || name.startsWith("javax/") || "META-INF/INDEX.LIST".equals(name) || "META-INF/MANIFEST.MF".equals(name)) continue;
            this.add(jar, sourceEntry, targetJarOutputStream, node.getArtifact().getFile().getName());
        }
        for (DependencyNode child : node.getChildren()) {
            this.addNodeAsClasses(child, targetJarOutputStream);
        }
    }

    private void addNodeAsJar(DependencyNode node, JarOutputStream targetJarOutputStream, boolean addAsRef, String path, String jarOverrideName) throws MojoExecutionException {
        if (!"compile".equals(node.getDependency().getScope()) || node.getDependency().getOptional().booleanValue()) {
            return;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.getLog().debug((CharSequence)("Including dependency jar " + node.getArtifact().getFile().getPath()));
        File file = node.getArtifact().getFile();
        String target = path + (jarOverrideName != null ? jarOverrideName : file.getName());
        if (addAsRef && this.addedJars.containsKey(file.getName())) {
            String refName = target.replace(".jar", ".ref");
            if (this.addedResources.contains(refName)) {
                return;
            }
            this.addedResources.add(refName);
            AddedTarget addedTarget = this.addedJars.get(file.getName());
            String refContent = addedTarget.path + addedTarget.name;
            ByteArrayInputStream refInputStream = new ByteArrayInputStream(refContent.getBytes());
            JarEntry targetJarEntry = new JarEntry(refName);
            try {
                this.addResource(refInputStream, targetJarEntry, targetJarOutputStream);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to add ref", (Exception)e);
            }
        } else {
            this.addResource(file, targetJarOutputStream, target);
            this.addedJars.put(file.getName(), new AddedTarget(path, file.getName()));
        }
        for (DependencyNode child : node.getChildren()) {
            this.addNodeAsJar(child, targetJarOutputStream, addAsRef, path, null);
        }
    }

    private class AddedTarget {
        String path;
        String name;

        AddedTarget(String path, String name) {
            this.path = path;
            this.name = name;
        }
    }
}

