/*
 * Decompiled with CFR 0.152.
 */
package io.squark.yggdrasil.logging.api;

import io.squark.yggdrasil.logging.api.CrappyLogger;
import io.squark.yggdrasil.logging.api.CrappyLoggerFactory;
import io.squark.yggdrasil.logging.api.ReplaceableLoggerBinder;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class InternalLoggerBinder
implements ReplaceableLoggerBinder {
    private CrappyLoggerFactory crappyLoggerFactory;
    private ILoggerFactory delegateLoggerFactory;
    private static InternalLoggerBinder INSTANCE = new InternalLoggerBinder();
    private final Set<CrappyLogger> loggers = new HashSet<CrappyLogger>();
    private boolean replaced;

    private InternalLoggerBinder() {
        this.crappyLoggerFactory = new CrappyLoggerFactory(this);
    }

    public static InternalLoggerBinder getSingleton() {
        return INSTANCE;
    }

    public static Logger getLogger(Class aClass) {
        return InternalLoggerBinder.getLogger(aClass.getName());
    }

    public static Logger getLogger(String name) {
        return InternalLoggerBinder.getSingleton().getLoggerFactory().getLogger(name);
    }

    public ILoggerFactory getLoggerFactory() {
        return this.replaced ? this.delegateLoggerFactory : this.crappyLoggerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(CrappyLogger logger) {
        Set<CrappyLogger> set = this.loggers;
        synchronized (set) {
            this.loggers.add(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyLoggingInitialized(ILoggerFactory loggerFactory) {
        Set<CrappyLogger> set = this.loggers;
        synchronized (set) {
            this.delegateLoggerFactory = loggerFactory;
            this.crappyLoggerFactory = null;
            HashSet<CrappyLogger> loggersToRemove = new HashSet<CrappyLogger>();
            for (CrappyLogger logger : this.loggers) {
                if (!logger.isReplaced()) {
                    logger.setDelegate(loggerFactory.getLogger(logger.getName()));
                }
                loggersToRemove.add(logger);
            }
            this.loggers.removeAll(loggersToRemove);
            this.replaced = true;
        }
    }
}

