/*
 * Decompiled with CFR 0.152.
 */
package io.squark.yggdrasil.logging.api;

import io.squark.yggdrasil.logging.api.LogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class CrappyLogger
implements Logger {
    public static final String YGGDRASIL_LOG_LEVEL = "yggdrasil.logLevel";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private boolean replaced;
    private String name;
    private LogLevel logLevel;
    private Logger delegate;

    CrappyLogger(String name) {
        this.name = name;
        this.logLevel = LogLevel.INFO;
        if (System.getProperty(YGGDRASIL_LOG_LEVEL) != null) {
            this.logLevel = LogLevel.valueOf(System.getProperty(YGGDRASIL_LOG_LEVEL));
        }
    }

    boolean isReplaced() {
        return this.replaced;
    }

    void setDelegate(Logger delegate) {
        this.delegate = delegate;
        if (this.delegate != null) {
            this.replaced = true;
        }
    }

    public String getName() {
        if (this.replaced) {
            return this.delegate.getName();
        }
        return this.name;
    }

    public boolean isTraceEnabled() {
        if (this.replaced) {
            return this.delegate.isTraceEnabled();
        }
        return this.logLevel.intLevel() >= LogLevel.TRACE.intLevel();
    }

    public void trace(String msg) {
        if (this.replaced) {
            this.delegate.trace(msg);
            return;
        }
        this.log(LogLevel.TRACE, msg, null);
    }

    public void trace(String format, Object arg) {
        if (this.replaced) {
            this.delegate.trace(format, arg);
            return;
        }
        this.log(LogLevel.TRACE, String.format(format, arg), null);
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.replaced) {
            this.delegate.trace(format, arg1, arg2);
            return;
        }
        this.log(LogLevel.TRACE, String.format(format, arg1, arg2), null);
    }

    public void trace(String format, Object ... arguments) {
        if (this.replaced) {
            this.delegate.trace(format, arguments);
            return;
        }
        this.log(LogLevel.TRACE, String.format(format, arguments), null);
    }

    public void trace(String msg, Throwable t) {
        if (this.replaced) {
            this.delegate.trace(msg, t);
            return;
        }
        this.log(LogLevel.TRACE, msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        if (this.replaced) {
            return this.delegate.isTraceEnabled(marker);
        }
        return this.isTraceEnabled();
    }

    public void trace(Marker marker, String msg) {
        if (this.replaced) {
            this.delegate.trace(marker, msg);
            return;
        }
        this.trace(msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.replaced) {
            this.delegate.trace(marker, format, arg);
            return;
        }
        this.trace(format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.replaced) {
            this.delegate.trace(marker, format, arg1, arg2);
            return;
        }
        this.trace(format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.replaced) {
            this.delegate.trace(marker, format, argArray);
            return;
        }
        this.trace(format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.replaced) {
            this.delegate.trace(marker, msg, t);
            return;
        }
        this.trace(msg, t);
    }

    public boolean isDebugEnabled() {
        if (this.replaced) {
            return this.delegate.isDebugEnabled();
        }
        return this.logLevel.intLevel() >= LogLevel.DEBUG.intLevel();
    }

    public void debug(String msg) {
        if (this.replaced) {
            this.delegate.debug(msg);
            return;
        }
        this.log(LogLevel.DEBUG, msg, null);
    }

    public void debug(String format, Object arg) {
        if (this.replaced) {
            this.delegate.debug(format, arg);
            return;
        }
        this.log(LogLevel.DEBUG, String.format(format, arg), null);
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.replaced) {
            this.delegate.debug(format, arg1, arg2);
            return;
        }
        this.log(LogLevel.DEBUG, String.format(format, arg1, arg2), null);
    }

    public void debug(String format, Object ... arguments) {
        if (this.replaced) {
            this.delegate.debug(format, arguments);
            return;
        }
        this.log(LogLevel.DEBUG, String.format(format, arguments), null);
    }

    public void debug(String msg, Throwable t) {
        if (this.replaced) {
            this.delegate.debug(msg, t);
            return;
        }
        this.log(LogLevel.DEBUG, msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        if (this.replaced) {
            return this.delegate.isDebugEnabled(marker);
        }
        return this.isDebugEnabled();
    }

    public void debug(Marker marker, String msg) {
        if (this.replaced) {
            this.delegate.debug(marker, msg);
            return;
        }
        this.debug(msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.replaced) {
            this.delegate.debug(marker, format, arg);
            return;
        }
        this.debug(format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.replaced) {
            this.delegate.debug(marker, format, arg1, arg2);
            return;
        }
        this.debug(format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.replaced) {
            this.delegate.debug(marker, format, arguments);
            return;
        }
        this.debug(format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.replaced) {
            this.delegate.debug(marker, msg, t);
            return;
        }
        this.debug(msg, t);
    }

    public boolean isInfoEnabled() {
        if (this.replaced) {
            return this.delegate.isInfoEnabled();
        }
        return this.logLevel.intLevel() >= LogLevel.INFO.intLevel();
    }

    public void info(String msg) {
        if (this.replaced) {
            this.delegate.info(msg);
            return;
        }
        this.log(LogLevel.INFO, msg, null);
    }

    public void info(String format, Object arg) {
        if (this.replaced) {
            this.delegate.info(format, arg);
            return;
        }
        this.log(LogLevel.INFO, String.format(format, arg), null);
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.replaced) {
            this.delegate.info(format, arg1, arg2);
            return;
        }
        this.log(LogLevel.INFO, String.format(format, arg1, arg2), null);
    }

    public void info(String format, Object ... arguments) {
        if (this.replaced) {
            this.delegate.info(format, arguments);
            return;
        }
        this.log(LogLevel.INFO, String.format(format, arguments), null);
    }

    public void info(String msg, Throwable t) {
        if (this.replaced) {
            this.delegate.info(msg, t);
            return;
        }
        this.log(LogLevel.INFO, msg, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        if (this.replaced) {
            return this.delegate.isInfoEnabled(marker);
        }
        return this.isInfoEnabled();
    }

    public void info(Marker marker, String msg) {
        if (this.replaced) {
            this.delegate.info(marker, msg);
            return;
        }
        this.info(msg);
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.replaced) {
            this.delegate.info(marker, format, arg);
            return;
        }
        this.info(format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.replaced) {
            this.delegate.info(marker, format, arg1, arg2);
            return;
        }
        this.info(format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.replaced) {
            this.delegate.info(marker, format, arguments);
            return;
        }
        this.info(format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.replaced) {
            this.delegate.info(marker, msg, t);
            return;
        }
        this.info(msg, t);
    }

    public boolean isWarnEnabled() {
        if (this.replaced) {
            return this.delegate.isWarnEnabled();
        }
        return this.logLevel.intLevel() >= LogLevel.WARN.intLevel();
    }

    public void warn(String msg) {
        if (this.replaced) {
            this.delegate.warn(msg);
            return;
        }
        this.log(LogLevel.WARN, msg, null);
    }

    public void warn(String format, Object arg) {
        if (this.replaced) {
            this.delegate.warn(format, arg);
            return;
        }
        this.log(LogLevel.WARN, String.format(format, arg), null);
    }

    public void warn(String format, Object ... arguments) {
        if (this.replaced) {
            this.delegate.warn(format, arguments);
            return;
        }
        this.log(LogLevel.WARN, String.format(format, arguments), null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.replaced) {
            this.delegate.warn(format, arg1, arg2);
            return;
        }
        this.log(LogLevel.WARN, String.format(format, arg1, arg2), null);
    }

    public void warn(String msg, Throwable t) {
        if (this.replaced) {
            this.delegate.warn(msg, t);
            return;
        }
        this.log(LogLevel.WARN, msg, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        if (this.replaced) {
            return this.delegate.isWarnEnabled(marker);
        }
        return this.isWarnEnabled();
    }

    public void warn(Marker marker, String msg) {
        if (this.replaced) {
            this.delegate.warn(marker, msg);
            return;
        }
        this.warn(msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.replaced) {
            this.delegate.warn(marker, format, arg);
            return;
        }
        this.warn(format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.replaced) {
            this.delegate.warn(marker, format, arg1, arg2);
            return;
        }
        this.warn(format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.replaced) {
            this.delegate.warn(marker, format, arguments);
            return;
        }
        this.warn(format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.replaced) {
            this.delegate.warn(marker, msg, t);
            return;
        }
        this.warn(msg, t);
    }

    public boolean isErrorEnabled() {
        if (this.replaced) {
            return this.delegate.isErrorEnabled();
        }
        return this.logLevel.intLevel() >= LogLevel.ERROR.intLevel();
    }

    public void error(String msg) {
        if (this.replaced) {
            this.delegate.error(msg);
            return;
        }
        this.log(LogLevel.ERROR, msg, null);
    }

    public void error(String format, Object arg) {
        if (this.replaced) {
            this.delegate.error(format, arg);
            return;
        }
        this.log(LogLevel.ERROR, String.format(format, arg), null);
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.replaced) {
            this.delegate.error(format, arg1, arg2);
            return;
        }
        this.log(LogLevel.ERROR, String.format(format, arg1, arg2), null);
    }

    public void error(String format, Object ... arguments) {
        if (this.replaced) {
            this.delegate.error(format, arguments);
            return;
        }
        this.log(LogLevel.ERROR, String.format(format, arguments), null);
    }

    public void error(String msg, Throwable t) {
        if (this.replaced) {
            this.delegate.error(msg, t);
            return;
        }
        this.log(LogLevel.ERROR, msg, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        if (this.replaced) {
            return this.delegate.isErrorEnabled(marker);
        }
        return this.isErrorEnabled();
    }

    public void error(Marker marker, String msg) {
        if (this.replaced) {
            this.delegate.error(marker, msg);
            return;
        }
        this.error(msg);
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.replaced) {
            this.delegate.error(marker, format, arg);
            return;
        }
        this.error(format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.replaced) {
            this.delegate.error(marker, format, arg1, arg2);
            return;
        }
        this.error(format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.replaced) {
            this.delegate.error(marker, format, arguments);
            return;
        }
        this.error(format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.replaced) {
            this.delegate.error(marker, msg, t);
            return;
        }
        this.error(msg, t);
    }

    void log(LogLevel level, @Nullable String message, @Nullable Throwable throwable) {
        if (System.getProperty(YGGDRASIL_LOG_LEVEL) != null) {
            level = LogLevel.valueOf(System.getProperty(YGGDRASIL_LOG_LEVEL));
        }
        if (level == null) {
            level = LogLevel.INFO;
        }
        if (level.intLevel() <= this.logLevel.intLevel()) {
            String combinedMessage;
            String string = combinedMessage = message != null ? message : "";
            if (throwable != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                combinedMessage = (message != null ? message + "\n" : "") + stringWriter.toString();
            }
            String formatted = String.format("%s [%s] %-5s %s - %s", DATE_FORMAT.format(new Date()), Thread.currentThread().getName(), level.name(), this.name, combinedMessage);
            System.out.println(formatted);
        }
    }
}

