/*
 * Decompiled with CFR 0.152.
 */
package io.squark.yggdrasil.bootstrap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/squark/yggdrasil/bootstrap/NestedJarURLConnection;", "Ljava/net/URLConnection;", "Ljava/io/Closeable;", "url", "Ljava/net/URL;", "(Ljava/net/URL;)V", "_inputStream", "Ljava/io/InputStream;", "close", "", "connect", "getInputStream", "yggdrasil-bootstrap_main"})
public final class NestedJarURLConnection
extends URLConnection
implements Closeable {
    private InputStream _inputStream;

    @Override
    public void close() {
        InputStream inputStream = this._inputStream;
        if (inputStream == null) {
            InputStream inputStream2 = this._inputStream;
            if (inputStream2 == null) {
                Intrinsics.throwNpe();
            }
            inputStream2.close();
            inputStream = Unit.INSTANCE;
        }
    }

    @Override
    public void connect() {
        if (Intrinsics.areEqual((Object)this.url.getProtocol(), (Object)"jar") ^ true) {
            throw (Throwable)new NotImplementedError("Protocol " + this.url.getProtocol() + " not supported");
        }
        List parts = StringsKt.split$default((CharSequence)this.url.getPath(), (String[])new String[]{"!/"}, (boolean)false, (int)0, (int)6, null);
        if (parts.size() < 2 || parts.size() > 3) {
            throw (Throwable)new IllegalArgumentException("URL should have jar part followed by entry and optional subentry (jar://path/to/jar.jar!/entry/in/jar!/sub/entry). Was \"" + this.url.getPath() + '\"');
        }
        String jar = (String)parts.get(0);
        String entry = (String)parts.get(1);
        JarFile jarFile = new JarFile(new File(new URL(jar).getFile()));
        JarEntry jarEntry = jarFile.getJarEntry(entry);
        if (parts.size() == 3) {
            String subEntryName = (String)parts.get(2);
            if (!StringsKt.endsWith$default((String)jarEntry.getName(), (String)".jar", (boolean)false, (int)2, null)) {
                throw (Throwable)new IllegalArgumentException("Only JAR entries can hold subEntries. Was " + jarEntry.getName());
            }
            JarInputStream jarInputStream = new JarInputStream(jarFile.getInputStream(jarEntry));
            JarEntry subEntry = jarInputStream.getNextJarEntry();
            byte[] bytes = null;
            while (subEntry != null) {
                if (Intrinsics.areEqual((Object)subEntryName, (Object)subEntry.getName())) {
                    byte[] buffer = new byte[2048];
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    int len = jarInputStream.read(buffer);
                    while (len > 0) {
                        outputStream.write(buffer, 0, len);
                        len = jarInputStream.read(buffer);
                    }
                    bytes = outputStream.toByteArray();
                    outputStream.close();
                    break;
                }
                subEntry = jarInputStream.getNextJarEntry();
            }
            if (bytes == null) {
                throw (Throwable)new FileNotFoundException("" + this.url);
            }
            this._inputStream = new ByteArrayInputStream(bytes);
            jarInputStream.close();
            jarFile.close();
        } else {
            this._inputStream = jarFile.getInputStream(jarEntry);
        }
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        return this._inputStream;
    }

    public NestedJarURLConnection(@NotNull URL url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        super(url);
    }
}

