/*
 * Decompiled with CFR 0.152.
 */
package io.squark.nestedjarclassloader;

import com.google.common.io.FileBackedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import sun.net.www.ParseUtil;

public class NestedJarURLConnection
extends URLConnection
implements AutoCloseable {
    private final boolean isDirectory;
    private URL jarFileURL;
    private String entryName;
    private boolean connected;
    private String subEntryName;
    private String file;
    private FileBackedOutputStream entryOutputStream;
    private FileBackedOutputStream subEntryOutputStream;

    public NestedJarURLConnection(URL url, boolean connect, boolean isDirectory) throws IOException {
        super(url);
        this.isDirectory = isDirectory;
        this.parseSpecs(url);
        if (connect) {
            this.connect();
        }
    }

    private void parseSpecs(URL url) throws MalformedURLException {
        String spec = url.getFile();
        if (spec.startsWith("jar:")) {
            spec = spec.substring(4, spec.length());
        }
        int separator = spec.indexOf("!/");
        this.jarFileURL = new URL(spec.substring(0, separator++));
        this.entryName = null;
        if (++separator != spec.length()) {
            this.entryName = spec.substring(separator, spec.length());
            this.entryName = ParseUtil.decode(this.entryName);
            int subEntrySeparator = this.entryName.indexOf("!/");
            if (subEntrySeparator != -1) {
                this.subEntryName = this.entryName.substring(subEntrySeparator + 2, this.entryName.length());
                this.entryName = this.entryName.substring(0, subEntrySeparator);
            }
        }
    }

    @Override
    public void connect() throws IOException {
        this.file = this.jarFileURL.getFile();
        if (this.entryName != null) {
            int len;
            JarFile jarFile = new JarFile(this.file);
            InputStream is = jarFile.getInputStream(jarFile.getEntry(this.entryName));
            byte[] b = new byte[2048];
            this.entryOutputStream = new FileBackedOutputStream((int)Runtime.getRuntime().freeMemory() / 2, true);
            while ((len = is.read(b)) > 0) {
                this.entryOutputStream.write(b, 0, len);
            }
            is.close();
            if (this.subEntryName != null) {
                JarEntry subEntry;
                JarInputStream entryInputStream = new JarInputStream(this.entryOutputStream.asByteSource().openBufferedStream());
                while ((subEntry = entryInputStream.getNextJarEntry()) != null) {
                    if (!subEntry.getName().equals(this.subEntryName)) continue;
                    this.subEntryOutputStream = new FileBackedOutputStream((int)Runtime.getRuntime().freeMemory() / 2, true);
                    if (subEntry.isDirectory()) {
                        JarEntry file;
                        JarInputStream newEntryInputStream = new JarInputStream(this.entryOutputStream.asByteSource().openBufferedStream());
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)this.subEntryOutputStream);
                        while ((file = newEntryInputStream.getNextJarEntry()) != null) {
                            Path path;
                            if (!file.getName().startsWith(this.subEntryName) || (path = Paths.get(file.getName(), new String[0])).getNameCount() - Paths.get(this.subEntryName, new String[0]).getNameCount() != 1) continue;
                            outputStreamWriter.append(path.getFileName().toString()).append('\n');
                        }
                        outputStreamWriter.close();
                        newEntryInputStream.close();
                        continue;
                    }
                    b = new byte[2048];
                    while ((len = entryInputStream.read(b)) > 0) {
                        this.subEntryOutputStream.write(b, 0, len);
                    }
                    break block1;
                }
                entryInputStream.close();
                this.entryOutputStream.reset();
                this.entryOutputStream.close();
                this.entryOutputStream = null;
            }
        }
        this.connected = true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.subEntryName != null) {
            if (this.subEntryOutputStream != null) {
                return this.subEntryOutputStream.asByteSource().openBufferedStream();
            }
            throw new IOException("Failed to load " + this.subEntryName);
        }
        if (this.entryName != null) {
            if (this.entryOutputStream != null) {
                return this.entryOutputStream.asByteSource().openBufferedStream();
            }
            throw new IOException("Failed to load " + this.entryName);
        }
        return new JarInputStream(new FileInputStream(this.file));
    }

    @Override
    public void close() throws IOException {
        if (this.subEntryOutputStream != null) {
            this.subEntryOutputStream.reset();
            this.subEntryOutputStream.close();
            this.subEntryOutputStream = null;
        }
        if (this.entryOutputStream != null) {
            this.entryOutputStream.reset();
            this.entryOutputStream.close();
            this.entryOutputStream = null;
        }
    }
}

