/*
 * Decompiled with CFR 0.152.
 */
package io.squark.nestedjarclassloader;

import io.squark.nestedjarclassloader.Module;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class NestedJarClassLoader
extends ClassLoader {
    private static final String DEFAULT_MODULE_NAME = "default";
    private final Map<String, Module> modules = new LinkedHashMap<String, Module>();
    private Logger logger;

    public NestedJarClassLoader(@Nullable ClassLoader parent, @Nullable Logger logger) {
        super(parent);
        Thread.currentThread().setContextClassLoader(this);
        this.logger = logger;
    }

    public void addURLs(URL ... urls) throws IOException {
        if (urls == null) {
            return;
        }
        this.addURLs((String)null, urls);
    }

    public void addURLs(String module, URL ... urls) throws IOException {
        if (urls == null) {
            return;
        }
        if (module == null) {
            module = DEFAULT_MODULE_NAME;
        }
        this.addResources(module, urls);
    }

    private void addResources(String moduleName, URL ... urls) throws IOException {
        Module module = this.getModule(moduleName);
        module.addResources(urls);
    }

    private Module getModule(String moduleName) throws IOException {
        Module module = this.modules.get(moduleName);
        if (module == null) {
            module = new Module(moduleName, this, this.logger);
            this.modules.put(moduleName, module);
        }
        return module;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> found = null;
        if (name.startsWith("io.squark.nestedjarclassloader")) {
            found = super.loadClass(name, resolve);
        }
        if (name.startsWith("java.")) {
            found = NestedJarClassLoader.getSystemClassLoader().loadClass(name);
        }
        if (found == null) {
            found = this.findModuleClass(name, resolve);
        }
        if (found == null) {
            try {
                found = super.loadClass(name, resolve);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (found == null) {
            found = NestedJarClassLoader.getSystemClassLoader().loadClass(name);
        }
        if (found != null) {
            return found;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return null;
    }

    @Override
    public URL findResource(String name) {
        for (Module module : this.modules.values()) {
            Optional<URL> foundResource = module.findLocalResource(name);
            if (!foundResource.isPresent()) continue;
            return foundResource.get();
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        LinkedHashSet<URL> combinedResources = null;
        for (Module module : this.modules.values()) {
            Set<URL> foundResources = module.findLocalResources(name);
            if (foundResources.size() <= 0) continue;
            if (combinedResources == null) {
                combinedResources = new LinkedHashSet<URL>();
            }
            combinedResources.addAll(foundResources);
        }
        if (combinedResources != null) {
            return Collections.enumeration(combinedResources);
        }
        return Collections.emptyEnumeration();
    }

    private Class<?> findModuleClass(String name, boolean resolve) throws ClassNotFoundException {
        for (Module module : this.modules.values()) {
            Class<?> found = module.findLocalClass(name, resolve);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public void unloadModule(String loggingModuleName) {
        if (this.modules.containsKey(loggingModuleName)) {
            Module unloaded = this.modules.remove(loggingModuleName);
            unloaded.cleanUp();
        }
    }
}

