/*
 * Decompiled with CFR 0.152.
 */
package io.squark.nestedjarclassloader;

import io.squark.nestedjarclassloader.NestedJarClassLoader;
import io.squark.nestedjarclassloader.NestedJarURLStreamHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.SetValuedMap;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

class Module
extends ClassLoader {
    private final SetValuedMap<String, URL> resources = MultiMapUtils.newSetValuedHashMap();
    private final Map<String, byte[]> byteCache = new HashMap<String, byte[]>();
    private final Map<String, Class<?>> classes = new HashMap();
    private Logger logger;
    private String name;

    Module(String name, NestedJarClassLoader parent, @Nullable Logger logger) throws IOException {
        super(parent);
        this.name = name;
        this.logger = logger;
    }

    public void addResources(URL ... urls) throws IOException {
        for (URL url : urls) {
            this.addResource0(url);
        }
    }

    private void addResource0(URL url) throws IOException {
        if (url.getPath().endsWith(".jar")) {
            JarEntry jarEntry;
            if (this.logger != null) {
                this.logger.debug("Adding jar " + url.getPath());
            }
            InputStream urlStream = url.openStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(urlStream);
            JarInputStream jarInputStream = new JarInputStream(bufferedInputStream);
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (this.resources.containsKey((Object)jarEntry.getName()) && this.logger != null) {
                    this.logger.trace("Already have resource " + jarEntry.getName() + ". If different versions, unexpected behaviour might occur. Available in " + this.resources.get((Object)jarEntry.getName()));
                }
                String spec = url.getProtocol().equals("jar") ? url.getPath() : url.getProtocol() + ":" + url.getPath();
                URL contentUrl = new URL(null, "jar:" + spec + "!/" + jarEntry.getName(), new NestedJarURLStreamHandler(false));
                this.resources.put((Object)jarEntry.getName(), (Object)contentUrl);
                this.addClassIfClass(jarInputStream, jarEntry.getName());
                if (this.logger != null) {
                    this.logger.trace("Added resource " + jarEntry.getName() + " to ClassLoader");
                }
                if (!jarEntry.getName().endsWith(".jar")) continue;
                this.addResource0(contentUrl);
            }
            jarInputStream.close();
            bufferedInputStream.close();
            urlStream.close();
        } else {
            if (url.getPath().endsWith(".class")) {
                throw new IllegalStateException("Cannot add classes directly");
            }
            try {
                this.addDirectory(new File(url.toURI()));
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private String resourceToClassName(String slashed) {
        return slashed.substring(0, slashed.lastIndexOf(".class")).replace("/", ".");
    }

    protected void addToByteCache(String className, byte[] classBytes) {
        this.byteCache.put(className, classBytes);
    }

    private void addClassIfClass(InputStream inputStream, String relativePath) throws IOException {
        if (relativePath.endsWith(".class")) {
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] b = new byte[2048];
            while ((len = inputStream.read(b)) > 0) {
                out.write(b, 0, len);
            }
            out.close();
            byte[] classBytes = out.toByteArray();
            String className = this.resourceToClassName(relativePath);
            this.addToByteCache(className, classBytes);
        }
    }

    private void addDirectory(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IllegalStateException("Not a directory: " + directory);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IllegalStateException("No files found in " + directory);
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.addDirectory(file);
                continue;
            }
            if (file.getName().endsWith(".jar")) {
                try {
                    this.addResource0(file.toURI().toURL());
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            try {
                String relativeName = directory.toURI().relativize(file.toURI()).getPath();
                FileInputStream fileInputStream = new FileInputStream(file);
                this.addClassIfClass(fileInputStream, relativeName);
                this.resources.put((Object)relativeName, (Object)file.toURI().toURL());
                fileInputStream.close();
            }
            catch (FileNotFoundException | MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> found = this.findLoadedClass(name);
            if (found != null) {
                return found;
            }
            if (name.startsWith("io.squark.nestedjarclassloader")) {
                return ((NestedJarClassLoader)this.getParent()).loadClass(name, resolve);
            }
            found = this.findLocalClass(name, resolve);
            if (found == null) {
                found = ((NestedJarClassLoader)this.getParent()).loadClass(name, resolve);
            }
            return found;
        }
    }

    public Class<?> findLocalClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.getLoadedClass(className, resolve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getLoadedClass(String className, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            Class<?> loadedClass = this.findLoadedClass(className);
            if (this.classes.containsKey(className)) {
                return this.classes.get(className);
            }
            if (this.byteCache.containsKey(className)) {
                this.definePackageForClass(className);
                byte[] classBytes = this.byteCache.get(className);
                if (loadedClass == null) {
                    try {
                        loadedClass = this.defineClass(className, classBytes, 0, classBytes.length, this.getClass().getProtectionDomain());
                    }
                    catch (IncompatibleClassChangeError | NoClassDefFoundError e) {
                        throw new ClassNotFoundException(className, e);
                    }
                }
                this.classes.put(className, loadedClass);
                if (resolve) {
                    this.resolveClass(loadedClass);
                }
                return loadedClass;
            }
            return null;
        }
    }

    private void definePackageForClass(String className) {
        String pkgname;
        Package pkg;
        int i = className.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgname = className.substring(0, i))) == null) {
            this.definePackage(pkgname, null, null, null, null, null, null, null);
        }
    }

    Optional<URL> findLocalResource(String name) {
        Set<URL> foundResources = this.findLocalResources(name);
        if (foundResources.size() > 0) {
            return Optional.of(foundResources.iterator().next());
        }
        return Optional.empty();
    }

    Set<URL> findLocalResources(String name) {
        return this.resources.get((Object)name);
    }

    public void cleanUp() {
        this.resources.clear();
        this.classes.clear();
        this.byteCache.clear();
    }

    public String toString() {
        return "Module{name='" + this.name + '\'' + '}';
    }
}

