/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.workloadapi.internal;

import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import io.spiffe.workloadapi.internal.ManagedChannelWrapper;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import org.apache.commons.lang3.SystemUtils;

public final class GrpcManagedChannelFactory {
    private static final String UNIX_SCHEME = "unix";
    private static final String TCP_SCHEME = "tcp";

    private GrpcManagedChannelFactory() {
    }

    public static ManagedChannelWrapper newChannel(@NonNull URI address, ExecutorService executorService) {
        ManagedChannelWrapper result;
        String scheme;
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        switch (scheme = address.getScheme()) {
            case "unix": {
                result = GrpcManagedChannelFactory.createNativeSocketChannel(address, executorService);
                break;
            }
            case "tcp": {
                result = GrpcManagedChannelFactory.createTcpChannel(address);
                break;
            }
            default: {
                throw new IllegalArgumentException("Address Scheme not supported: ");
            }
        }
        return result;
    }

    private static ManagedChannelWrapper createNativeSocketChannel(@NonNull URI address, ExecutorService executorService) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(address.getPath()));
        EventLoopGroup eventLoopGroup = GrpcManagedChannelFactory.configureNativeSocketChannel(channelBuilder, executorService);
        ManagedChannel managedChannel = channelBuilder.usePlaintext().build();
        return new ManagedChannelWrapper(managedChannel, eventLoopGroup);
    }

    private static ManagedChannelWrapper createTcpChannel(@NonNull URI address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        ManagedChannel managedChannel = NettyChannelBuilder.forAddress((String)address.getHost(), (int)address.getPort()).negotiationType(NegotiationType.PLAINTEXT).build();
        return new ManagedChannelWrapper(managedChannel);
    }

    private static EventLoopGroup configureNativeSocketChannel(@NonNull NettyChannelBuilder channelBuilder, ExecutorService executorService) {
        if (channelBuilder == null) {
            throw new NullPointerException("channelBuilder is marked non-null but is null");
        }
        if (SystemUtils.IS_OS_LINUX) {
            EpollEventLoopGroup epollEventLoopGroup = new EpollEventLoopGroup(0, (Executor)executorService);
            channelBuilder.eventLoopGroup((EventLoopGroup)epollEventLoopGroup).withOption(ChannelOption.SO_KEEPALIVE, null).channelType(EpollDomainSocketChannel.class);
            return epollEventLoopGroup;
        }
        throw new IllegalStateException("Operating System is not supported.");
    }
}

