/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.collection;

import com.gemstone.gemfire.internal.concurrent.MapCallback;
import com.gemstone.gemfire.internal.concurrent.MapResult;
import com.gemstone.gemfire.internal.shared.ClientResolverUtils;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;

public class OpenHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2837689134511263091L;
    public static final Object REMOVED = new Object();
    protected static final int MAX_CAPACITY = 0x40000000;
    protected final float loadFactor;
    protected int size;
    protected int occupied;
    protected int growThreshold;
    protected int mask;
    protected Object[] data;
    protected Consumer<OpenHashSet<E>> postRehashHook;

    public OpenHashSet() {
        this(16, 0.7f);
    }

    public OpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.7f);
    }

    public OpenHashSet(int initialCapacity, float loadFactor) {
        int capacity = OpenHashSet.nextPowerOf2(initialCapacity);
        this.loadFactor = loadFactor;
        this.growThreshold = (int)(loadFactor * (float)capacity);
        this.mask = capacity - 1;
        this.data = new Object[capacity];
    }

    public OpenHashSet(Collection<? extends E> c) {
        this(c.size());
        this.addAll(c);
    }

    protected int keyHash(Object key) {
        return ClientResolverUtils.fastHashInt((int)(key != null ? key.hashCode() : 0));
    }

    protected boolean keyEquals(Object mapKey, Object key) {
        return mapKey.equals(key);
    }

    protected final int insertionIndex(Object[] data, Object key, int hash) {
        boolean slotIsNull;
        Object mapKey;
        int mask = this.mask;
        int pos = hash & mask;
        int removedPos = -1;
        int delta = 1;
        while ((mapKey = data[pos]) != null) {
            if (mapKey == REMOVED) {
                removedPos = pos;
            } else if (this.keyEquals(mapKey, key)) {
                return -pos - 1;
            }
            pos = pos + delta & mask;
            ++delta;
        }
        boolean bl = slotIsNull = removedPos == -1;
        if (slotIsNull) {
            ++this.occupied;
            return pos;
        }
        return removedPos;
    }

    protected boolean doInsert(Object[] data, Object key, int pos) {
        data[pos] = key;
        return this.handleNewInsert();
    }

    protected boolean doRemove(Object[] data, int pos) {
        data[pos] = REMOVED;
        return this.handleRemove();
    }

    protected final int index(Object[] data, Object key, int hash) {
        Object mapKey;
        int mask = this.mask;
        int pos = hash & mask;
        int delta = 1;
        while ((mapKey = data[pos]) != null) {
            if (mapKey != REMOVED && this.keyEquals(mapKey, key)) {
                return pos;
            }
            pos = pos + delta & mask;
            ++delta;
        }
        return -1;
    }

    protected final <K, C, P> Object create(K key, MapCallback<K, E, C, P> creator, C context, P params, MapResult result, int hash) {
        Object mapKey;
        Object[] data = this.data;
        int mask = this.mask;
        int pos = hash & mask;
        int removedPos = -1;
        int delta = 1;
        while ((mapKey = data[pos]) != null) {
            if (mapKey == REMOVED) {
                removedPos = pos;
            } else if (this.keyEquals(mapKey, key)) {
                return mapKey;
            }
            pos = pos + delta & mask;
            ++delta;
        }
        result.setNewValueCreated(true);
        Object newKey = creator.newValue(key, context, params, result);
        if (result.isNewValueCreated()) {
            if (removedPos == -1) {
                ++this.occupied;
            } else {
                pos = removedPos;
            }
            this.doInsert(data, newKey, pos);
            return newKey;
        }
        return null;
    }

    public final void setPostRehashHook(Consumer<OpenHashSet<E>> hook) {
        this.postRehashHook = hook;
    }

    public final Object addKey(Object key, boolean replace, int hash) {
        Object[] data = this.data;
        int pos = this.insertionIndex(data, key, hash);
        if (pos >= 0) {
            this.doInsert(data, key, pos);
            return null;
        }
        int currentPos = -pos - 1;
        Object mapKey = data[currentPos];
        if (replace) {
            data[currentPos] = key;
        }
        return mapKey;
    }

    public final Object getKey(Object key) {
        Object[] data = this.data;
        int pos = this.index(data, key, this.keyHash(key));
        if (pos >= 0) {
            return data[pos];
        }
        return null;
    }

    public final Object removeKey(Object key) {
        return this.removeKey(key, this.keyHash(key));
    }

    private Object removeKey(Object key, int hash) {
        Object[] data = this.data;
        int pos = this.index(data, key, hash);
        if (pos >= 0) {
            Object mapKey = data[pos];
            this.doRemove(data, pos);
            return mapKey;
        }
        return null;
    }

    @Override
    public boolean contains(Object key) {
        return this.index(this.data, key, this.keyHash(key)) >= 0;
    }

    @Override
    public boolean add(E key) {
        Object[] data = this.data;
        int pos = this.insertionIndex(data, key, this.keyHash(key));
        if (pos >= 0) {
            this.doInsert(data, key, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object key) {
        return this.removeKey(key, this.keyHash(key)) != null;
    }

    @Override
    public Itr<E> iterator() {
        return new Itr(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public final int capacity() {
        return this.data.length;
    }

    @Override
    public void clear() {
        Object[] data = this.data;
        int size = data.length;
        for (int i = 0; i < size; ++i) {
            data[i] = null;
        }
        this.size = 0;
        this.occupied = 0;
    }

    protected final boolean handleNewInsert() {
        ++this.size;
        if (this.occupied <= this.growThreshold) {
            return false;
        }
        this.rehash(OpenHashSet.checkCapacity(this.data.length << 1));
        return true;
    }

    protected final boolean handleRemove() {
        if (--this.size > this.occupied >>> 1 || this.data.length <= 128) {
            return false;
        }
        this.rehash(this.data.length >>> 1);
        return true;
    }

    protected final void rehash(int newCapacity) {
        Object[] data = this.data;
        int capacity = data.length;
        Object[] newData = new Object[newCapacity];
        int newMask = newCapacity - 1;
        block0: for (int oldPos = 0; oldPos < capacity; ++oldPos) {
            Object d = data[oldPos];
            if (d == null || d == REMOVED) continue;
            int newHash = this.keyHash(d);
            int newPos = newHash & newMask;
            int delta = 1;
            while (true) {
                if (newData[newPos] == null) {
                    newData[newPos] = d;
                    continue block0;
                }
                newPos = newPos + delta & newMask;
                ++delta;
            }
        }
        this.occupied = this.size;
        this.data = newData;
        this.mask = newMask;
        this.growThreshold = (int)(this.loadFactor * (float)newCapacity);
        if (this.postRehashHook != null) {
            this.postRehashHook.accept(this);
        }
    }

    public static int checkCapacity(int capacity) {
        if (capacity > 0 && capacity <= 0x40000000) {
            return capacity;
        }
        if (capacity == 0) {
            return 2;
        }
        throw new IllegalStateException("Capacity (" + capacity + ") can't be more than " + 0x40000000 + " elements or negative");
    }

    public static int nextPowerOf2(int n) {
        int highBit = Integer.highestOneBit(n > 0 ? n : 2);
        return OpenHashSet.checkCapacity(highBit == n ? n : highBit << 1);
    }

    public static final class Itr<E>
    implements Iterator<E> {
        private final Object[] data;
        private Object result;
        private int pos;
        private int prevPos;
        private final OpenHashSet<?> set;

        Itr(OpenHashSet<?> set) {
            this.data = set.data;
            this.result = null;
            this.pos = -1;
            this.prevPos = -1;
            this.set = set;
            this.advance(this.data);
        }

        private void advance(Object[] data) {
            int size = data.length;
            for (int pos = this.pos + 1; pos < size; ++pos) {
                Object d = data[pos];
                if (d == null || d == REMOVED) continue;
                this.result = d;
                this.pos = pos;
                return;
            }
            this.result = null;
            this.pos = -1;
        }

        @Override
        public boolean hasNext() {
            return this.result != null;
        }

        @Override
        public E next() {
            Object result = this.result;
            if (result != null) {
                Object[] data = this.data;
                this.prevPos = this.pos;
                this.advance(data);
                return (E)result;
            }
            throw new NoSuchElementException("invalid iterator position");
        }

        @Override
        public void remove() {
            int pos = this.prevPos;
            if (pos >= 0) {
                Object[] data = this.data;
                OpenHashSet<?> set = this.set;
                if (data == set.data) {
                    set.doRemove(data, pos);
                } else {
                    set.remove(data[pos]);
                }
            } else {
                throw new NoSuchElementException("invalid iterator position");
            }
        }
    }
}

