/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.collection;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractObjKeyView;
import com.koloboke.collect.impl.AbstractObjValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.InternalObjObjMapOps;
import com.koloboke.collect.impl.Maths;
import com.koloboke.collect.impl.hash.Hash;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.LHashCapacities;
import com.koloboke.collect.map.ObjObjMap;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.snappydata.collection.ObjectObjectHashMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SuppressFBWarnings(value={"IA_AMBIGUOUS_INVOCATION_OF_INHERITED_OR_OUTER_METHOD"})
final class KolobokeObjectObjectHashMap<K, V>
extends ObjectObjectHashMap<K, V> {
    Object[] table;
    private HashConfigWrapper configWrapper;
    int size;
    private int maxSize;
    private int modCount = 0;
    static final HashConfigWrapper DEFAULT_CONFIG_WRAPPER = new HashConfigWrapper(HashConfig.getDefault());

    KolobokeObjectObjectHashMap(int expectedSize) {
        this.init(DEFAULT_CONFIG_WRAPPER, expectedSize);
    }

    static void verifyConfig(HashConfig config) {
        if (config.getGrowthFactor() != 2.0) {
            throw new IllegalArgumentException(config + " passed, HashConfig for a hashtable\n" + "implementation with linear probing must have growthFactor of 2.0.\n" + "A Koloboke Compile-generated hashtable implementation could have\n" + "a different growth factor, if the implemented type is annotated with\n" + "@com.koloboke.compile.hash.algo.openaddressing.QuadraticProbing or\n" + "@com.koloboke.compile.hash.algo.openaddressing.DoubleHashing");
        }
    }

    @Nonnull
    public final HashConfig hashConfig() {
        return this.configWrapper().config();
    }

    public long sizeAsLong() {
        return this.size();
    }

    boolean nullableValueEquals(@Nullable V a, @Nullable V b) {
        return a == b || a != null && this.valueEquals(a, b);
    }

    public final boolean noRemoved() {
        return true;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public Equivalence<K> keyEquivalence() {
        return Equivalence.defaultEquality();
    }

    boolean valueEquals(@Nonnull V a, @Nullable V b) {
        return a.equals(b);
    }

    public final int freeSlots() {
        return this.capacity() - this.size();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.contains(key);
    }

    boolean nullableKeyEquals(@Nullable K a, @Nullable K b) {
        return a == b || a != null && this.keyEquals(a, b);
    }

    int nullableValueHashCode(@Nullable V value) {
        return value != null ? this.valueHashCode(value) : 0;
    }

    @Nonnull
    public Object[] table() {
        return this.table;
    }

    public final int removedSlots() {
        return 0;
    }

    int valueHashCode(@Nonnull V value) {
        return value.hashCode();
    }

    boolean doubleSizedArrays() {
        return true;
    }

    @Nonnull
    public HashObjSet keySet() {
        return new KeyView();
    }

    public final double currentLoad() {
        return (double)this.size() / (double)this.capacity();
    }

    int nullableKeyHashCode(@Nullable K key) {
        return key != null ? this.keyHashCode(key) : 0;
    }

    int valueIndex(@Nullable Object value) {
        if (value == null) {
            return this.nullValueIndex();
        }
        if (this.isEmpty()) {
            return -1;
        }
        Object val = value;
        int index = -1;
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            if (tab[i] == null || !this.valueEquals(val, tab[i + 1])) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public int capacity() {
        return this.table.length >> 1;
    }

    public final HashConfigWrapper configWrapper() {
        return this.configWrapper;
    }

    public void forEach(Consumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == null) continue;
            action.accept(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean contains(Object key) {
        return this.index(key) >= 0;
    }

    @Override
    public final int size() {
        return this.size;
    }

    int index(Object key) {
        if (key == null) {
            throw new NullPointerException("This hashtable implementation doesn't allow null keys.\nA Koloboke Compile-generated hashtable implementation could contain\nnull keys if the implemented type is annotated with\n@com.koloboke.compile.NullKeyAllowed");
        }
        Object k = key;
        Object[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVObjKeyMixing.mix((int)this.keyHashCode(k)) & capacityMask;
        Object cur = tab[index];
        if (cur == k) {
            return index;
        }
        if (cur == null) {
            return -1;
        }
        if (this.keyEquals(k, cur)) {
            return index;
        }
        do {
            if ((cur = tab[index = index - 2 & capacityMask]) == k) {
                return index;
            }
            if (cur != null) continue;
            return -1;
        } while (!this.keyEquals(k, cur));
        return index;
    }

    public final int modCount() {
        return this.modCount;
    }

    final void incrementModCount() {
        ++this.modCount;
    }

    @Nonnull
    public Equivalence<V> valueEquivalence() {
        return Equivalence.defaultEquality();
    }

    private int nullValueIndex() {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            if (tab[i] == null || tab[i + 1] != null) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean forEachWhile(Predicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == null || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean containsEntry(Object key, Object value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.nullableValueEquals(this.table[index + 1], value);
        }
        return false;
    }

    final void init(HashConfigWrapper configWrapper, int size) {
        KolobokeObjectObjectHashMap.verifyConfig(configWrapper.config());
        this.configWrapper = configWrapper;
        this.size = 0;
        this.internalInit(this.targetCapacity(size));
    }

    private void internalInit(int capacity) {
        assert (Maths.isPowerOf2((int)capacity));
        this.maxSize = this.maxSize(capacity);
        this.allocateArrays(capacity);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueIndex(value) >= 0;
    }

    @Override
    public V get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.table[index + 1];
        }
        return null;
    }

    private int maxSize(int capacity) {
        return !this.isMaxCapacity(capacity) ? this.configWrapper.maxSize(capacity) : capacity - 1;
    }

    boolean removeValue(@Nullable Object value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean allContainingIn(ObjCollection<?> c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == null || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    int insert(K key, V value) {
        if (key == null) {
            throw new NullPointerException("This hashtable implementation doesn't allow null keys.\nA Koloboke Compile-generated hashtable implementation could contain\nnull keys if the implemented type is annotated with\n@com.koloboke.compile.NullKeyAllowed");
        }
        Object[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVObjKeyMixing.mix((int)this.keyHashCode(key)) & capacityMask;
        Object cur = tab[index];
        if (cur != null) {
            if (cur == key || this.keyEquals(key, cur)) {
                return index;
            }
            while ((cur = tab[index = index - 2 & capacityMask]) != null) {
                if (cur != key && !this.keyEquals(key, cur)) continue;
                return index;
            }
        }
        this.incrementModCount();
        tab[index] = key;
        tab[index + 1] = value;
        this.postInsertHook();
        return -1;
    }

    public boolean reverseAddAllTo(ObjCollection<? super K> c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == null) continue;
            changed |= c.add(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    void allocateArrays(int capacity) {
        this.table = new Object[capacity * 2];
    }

    final void initForRehash(int newCapacity) {
        ++this.modCount;
        this.internalInit(newCapacity);
    }

    @Override
    public boolean forEachWhile(BiPredicate<? super K, ? super V> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == null || predicate.test(key, tab[i + 1])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    private void _MutableParallelKVObjLHashSO_clear() {
        this._MutableLHash_clear();
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            tab[i] = null;
            tab[i + 1] = null;
        }
    }

    public boolean reverseRemoveAllFrom(ObjSet<?> s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == null) continue;
            changed |= s.remove(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private void _MutableLHash_clear() {
        ++this.modCount;
        this.size = 0;
    }

    public boolean shrink() {
        int newCapacity = this.targetCapacity(this.size);
        if (newCapacity < this.capacity()) {
            this.rehash(newCapacity);
            return true;
        }
        return false;
    }

    private boolean tryRehashForExpansion(int newCapacity) {
        if (newCapacity > this.capacity()) {
            this.rehash(newCapacity);
            return true;
        }
        return false;
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == null) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    private static boolean identical(Object a, Object b) {
        return a == b;
    }

    @SuppressFBWarnings(value={"BC_IMPOSSIBLE_CAST"})
    public boolean containsAllEntries(Map<?, ?> m) {
        if (KolobokeObjectObjectHashMap.identical(this, m)) {
            throw new IllegalArgumentException();
        }
        if (m instanceof ObjObjMap) {
            ObjObjMap m2 = (ObjObjMap)m;
            if (m2.keyEquivalence().equals(this.keyEquivalence()) && m2.valueEquivalence().equals(this.valueEquivalence())) {
                if (this.size() < m2.size()) {
                    return false;
                }
                if (InternalObjObjMapOps.class.isAssignableFrom(this.getClass()) && m2 instanceof InternalObjObjMapOps) {
                    return ((InternalObjObjMapOps)m2).allEntriesContainingIn((InternalObjObjMapOps)InternalObjObjMapOps.class.cast(this));
                }
            }
            return m2.forEachWhile(new BiPredicate(){

                public boolean test(Object a, Object b) {
                    return KolobokeObjectObjectHashMap.this.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : m.entrySet()) {
            if (this.containsEntry(e.getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    public final boolean ensureCapacity(long minSize) {
        int intMinSize = (int)Math.min(minSize, Integer.MAX_VALUE);
        if (minSize < 0L) {
            throw new IllegalArgumentException("Min size should be positive, " + minSize + " given.");
        }
        return intMinSize > this.maxSize && this.tryRehashForExpansion(this.targetCapacity(intMinSize));
    }

    final void postRemoveHook() {
        --this.size;
    }

    final void postInsertHook() {
        int capacity;
        if (++this.size > this.maxSize && !this.isMaxCapacity(capacity = this.capacity())) {
            this.rehash(capacity << 1);
        }
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == null) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    private int targetCapacity(int size) {
        return LHashCapacities.capacity((HashConfigWrapper)this.configWrapper, (int)size, (boolean)this.doubleSizedArrays());
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == null) continue;
            hashCode += this.keyHashCode(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    private boolean isMaxCapacity(int capacity) {
        return LHashCapacities.isMaxCapacity((int)capacity, (boolean)this.doubleSizedArrays());
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == null) continue;
            sb.append(' ').append(key != this ? key : "(this Collection)").append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<K, V>> entrySet() {
        return new EntryView();
    }

    @Override
    @Nonnull
    public ObjCollection<V> values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (that.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAllEntries(that);
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == null) continue;
            hashCode += this.keyHashCode(key) ^ this.nullableValueHashCode(tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == null) continue;
            sb.append(' ');
            sb.append(key != this ? key : "(this Map)");
            sb.append('=');
            Object val = tab[i + 1];
            sb.append(val != this ? val : "(this Map)");
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    void rehash(int newCapacity) {
        int mc = this.modCount();
        Object[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        Object[] newTab = this.table;
        int capacityMask = newTab.length - 2;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == null) continue;
            int index = LHash.ParallelKVObjKeyMixing.mix((int)this.keyHashCode(key)) & capacityMask;
            if (newTab[index] != null) {
                while (newTab[index = index - 2 & capacityMask] != null) {
                }
            }
            newTab[index] = key;
            newTab[index + 1] = tab[i + 1];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public V put(K key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        Object[] tab = this.table;
        Object prevValue = tab[index + 1];
        tab[index + 1] = value;
        return (V)prevValue;
    }

    public void justPut(K key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.table[index + 1] = value;
    }

    @Override
    @SuppressFBWarnings(value={"BC_IMPOSSIBLE_CAST"})
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        if (KolobokeObjectObjectHashMap.identical(this, m)) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = this.sizeAsLong() + Containers.sizeAsLong(m);
        this.ensureCapacity(maxPossibleSize);
        if (m instanceof ObjObjMap) {
            if (InternalObjObjMapOps.class.isAssignableFrom(this.getClass()) && m instanceof InternalObjObjMapOps) {
                ((InternalObjObjMapOps)m).reversePutAllTo((InternalObjObjMapOps)InternalObjObjMapOps.class.cast(this));
            } else {
                ((ObjObjMap)m).forEach(new BiConsumer<K, V>(){

                    @Override
                    public void accept(K key, V value) {
                        KolobokeObjectObjectHashMap.this.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<K, V> e : m.entrySet()) {
                this.justPut(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        this._MutableParallelKVObjLHashSO_clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    void removeAt(int index) {
        Object keyToShift;
        int indexToRemove;
        Object[] tab = this.table;
        int capacityMask = tab.length - 2;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 2;
        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
            Object castedKeyToShift = keyToShift;
            if ((LHash.ParallelKVObjKeyMixing.mix((int)this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = castedKeyToShift;
                tab[indexToRemove + 1] = tab[indexToShift + 1];
                indexToRemove = indexToShift;
                shiftDistance = 2;
                continue;
            }
            shiftDistance += 2;
        }
        tab[indexToRemove] = null;
        tab[indexToRemove + 1] = null;
        this.postRemoveHook();
    }

    @Override
    public V remove(Object key) {
        Object keyToShift;
        int indexToRemove;
        if (key == null) {
            throw new NullPointerException("This hashtable implementation doesn't allow null keys.\nA Koloboke Compile-generated hashtable implementation could contain\nnull keys if the implemented type is annotated with\n@com.koloboke.compile.NullKeyAllowed");
        }
        Object k = key;
        Object[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVObjKeyMixing.mix((int)this.keyHashCode(k)) & capacityMask;
        Object cur = tab[index];
        if (cur != k) {
            if (cur == null) {
                return null;
            }
            if (!this.keyEquals(k, cur)) {
                while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                    if (cur == null) {
                        return null;
                    }
                    if (!this.keyEquals(k, cur)) continue;
                }
            }
        }
        Object val = tab[index + 1];
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 2;
        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
            Object castedKeyToShift = keyToShift;
            if ((LHash.ParallelKVObjKeyMixing.mix((int)this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = castedKeyToShift;
                tab[indexToRemove + 1] = tab[indexToShift + 1];
                indexToRemove = indexToShift;
                shiftDistance = 2;
                continue;
            }
            shiftDistance += 2;
        }
        tab[indexToRemove] = null;
        tab[indexToRemove + 1] = null;
        this.postRemoveHook();
        return (V)val;
    }

    public boolean justRemove(Object key) {
        Object keyToShift;
        int indexToRemove;
        if (key == null) {
            throw new NullPointerException("This hashtable implementation doesn't allow null keys.\nA Koloboke Compile-generated hashtable implementation could contain\nnull keys if the implemented type is annotated with\n@com.koloboke.compile.NullKeyAllowed");
        }
        Object k = key;
        Object[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVObjKeyMixing.mix((int)this.keyHashCode(k)) & capacityMask;
        Object cur = tab[index];
        if (cur != k) {
            if (cur == null) {
                return false;
            }
            if (!this.keyEquals(k, cur)) {
                while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                    if (cur == null) {
                        return false;
                    }
                    if (!this.keyEquals(k, cur)) continue;
                }
            }
        }
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 2;
        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
            Object castedKeyToShift = keyToShift;
            if ((LHash.ParallelKVObjKeyMixing.mix((int)this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = castedKeyToShift;
                tab[indexToRemove + 1] = tab[indexToShift + 1];
                indexToRemove = indexToShift;
                shiftDistance = 2;
                continue;
            }
            shiftDistance += 2;
        }
        tab[indexToRemove] = null;
        tab[indexToRemove + 1] = null;
        this.postRemoveHook();
        return true;
    }

    public boolean removeIf(Predicate<? super K> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                Object key = tab[i];
                if (key == null || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                        Object castedKeyToShift = keyToShift;
                        if ((LHash.ParallelKVObjKeyMixing.mix((int)this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                tab[indexToRemove] = Support.ObjHash.REMOVED;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = castedKeyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                    }
                    tab[indexToRemove] = null;
                    tab[indexToRemove + 1] = null;
                    this.postRemoveHook();
                } else {
                    tab[i] = Support.ObjHash.REMOVED;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @SuppressFBWarnings(value={"EC_UNRELATED_TYPES_USING_POINTER_EQUALITY"})
    public boolean removeAll(@Nonnull HashObjSet<K> thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block11: {
                Object key = tab[i];
                if (key == null || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                        Object castedKeyToShift = keyToShift;
                        if ((LHash.ParallelKVObjKeyMixing.mix((int)this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                tab[indexToRemove] = Support.ObjHash.REMOVED;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = castedKeyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                    }
                    tab[indexToRemove] = null;
                    tab[indexToRemove + 1] = null;
                    this.postRemoveHook();
                } else {
                    tab[i] = Support.ObjHash.REMOVED;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @SuppressFBWarnings(value={"EC_UNRELATED_TYPES_USING_POINTER_EQUALITY"})
    public boolean retainAll(@Nonnull HashObjSet<K> thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        int capacityMask = tab.length - 2;
        int firstDelayedRemoved = -1;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            block12: {
                Object key = tab[i];
                if (key == null || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 2;
                    while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                        Object castedKeyToShift = keyToShift;
                        if ((LHash.ParallelKVObjKeyMixing.mix((int)this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                tab[indexToRemove] = Support.ObjHash.REMOVED;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                i += 2;
                            }
                            tab[indexToRemove] = castedKeyToShift;
                            tab[indexToRemove + 1] = tab[indexToShift + 1];
                            indexToRemove = indexToShift;
                            shiftDistance = 2;
                            continue;
                        }
                        shiftDistance += 2;
                    }
                    tab[indexToRemove] = null;
                    tab[indexToRemove + 1] = null;
                    this.postRemoveHook();
                } else {
                    tab[i] = Support.ObjHash.REMOVED;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    void closeDelayedRemoved(int firstDelayedRemoved) {
        Object[] tab = this.table;
        int capacityMask = tab.length - 2;
        for (int i = firstDelayedRemoved; i >= 0; i -= 2) {
            Object keyToShift;
            int indexToRemove;
            if (tab[i] != Support.ObjHash.REMOVED) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 2;
            while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                Object castedKeyToShift = keyToShift;
                if (keyToShift != Support.ObjHash.REMOVED && (LHash.ParallelKVObjKeyMixing.mix((int)this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = castedKeyToShift;
                    tab[indexToRemove + 1] = tab[indexToShift + 1];
                    indexToRemove = indexToShift;
                    shiftDistance = 2;
                    continue;
                }
                shiftDistance += 2;
            }
            tab[indexToRemove] = null;
            tab[indexToRemove + 1] = null;
            this.postRemoveHook();
        }
    }

    public ObjIterator<K> iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    public ObjCursor<K> setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    KolobokeObjectObjectHashMap(HashConfig hashConfig, int expectedSize) {
        this.init(new HashConfigWrapper(hashConfig), expectedSize);
    }

    static class Support {
        Support() {
        }

        static interface ParallelKVObjHash
        extends ObjHash {
            @Nonnull
            public Object[] table();
        }

        static interface ParallelKVObjLHash
        extends LHash,
        ParallelKVObjHash {
        }

        static interface ObjHash
        extends Hash {
            public static final Object REMOVED = new Object();
            public static final Object FREE = new Object();
        }
    }

    class NoRemovedValueCursor
    implements ObjCursor<V> {
        Object[] tab;
        final int capacityMask;
        int expectedModCount;
        int index;
        Object curKey;
        V curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = KolobokeObjectObjectHashMap.this.table;
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            this.capacityMask = tab.length - 2;
            this.index = tab.length;
            this.curKey = null;
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                if (tab[i] == null) continue;
                action.accept(tab[i + 1]);
            }
            if (index != this.index || mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = null;
        }

        public V elem() {
            if (this.curKey != null) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == KolobokeObjectObjectHashMap.this.modCount()) {
                Object[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == null) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = null;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            Object curKey = this.curKey;
            if (curKey == null) throw new IllegalStateException();
            if (this.expectedModCount++ != KolobokeObjectObjectHashMap.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = null;
            int index = this.index;
            Object[] tab = this.tab;
            if (tab == KolobokeObjectObjectHashMap.this.table) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                KolobokeObjectObjectHashMap.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = null;
                                        this.tab[indexToRemove + 1] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = castedKeyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                }
                tab[indexToRemove] = null;
                tab[indexToRemove + 1] = null;
                KolobokeObjectObjectHashMap.this.postRemoveHook();
                return;
            } else {
                KolobokeObjectObjectHashMap.this.justRemove(curKey);
                tab[index] = null;
                tab[index + 1] = null;
            }
        }
    }

    class NoRemovedValueIterator
    implements ObjIterator<V> {
        Object[] tab;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        V next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = KolobokeObjectObjectHashMap.this.table;
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            this.capacityMask = tab.length - 2;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                if (tab[nextI] == null) continue;
                this.next = tab[nextI + 1];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] == null) continue;
                action.accept(tab[i + 1]);
            }
            if (nextI != this.nextIndex || mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            if (this.expectedModCount == KolobokeObjectObjectHashMap.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] tab = this.tab;
                    Object prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        if (tab[nextI] == null) continue;
                        this.next = tab[nextI + 1];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != KolobokeObjectObjectHashMap.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            Object[] tab = this.tab;
            if (tab == KolobokeObjectObjectHashMap.this.table) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                KolobokeObjectObjectHashMap.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = null;
                                        this.tab[indexToRemove + 1] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = tab[indexToShift + 1];
                                }
                            }
                        }
                        tab[indexToRemove] = castedKeyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                }
                tab[indexToRemove] = null;
                tab[indexToRemove + 1] = null;
                KolobokeObjectObjectHashMap.this.postRemoveHook();
                return;
            } else {
                KolobokeObjectObjectHashMap.this.justRemove(tab[index]);
                tab[index] = null;
                tab[index + 1] = null;
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, V>> {
        Object[] tab;
        final int capacityMask;
        int expectedModCount;
        int index;
        Object curKey;
        V curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = KolobokeObjectObjectHashMap.this.table;
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            this.capacityMask = tab.length - 2;
            this.index = tab.length;
            this.curKey = null;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == null) continue;
                action.accept((Map.Entry)((Object)new MutableEntry2(mc, i, key, tab[i + 1])));
            }
            if (index != this.index || mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = null;
        }

        public Map.Entry<K, V> elem() {
            Object curKey = this.curKey;
            if (curKey != null) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == KolobokeObjectObjectHashMap.this.modCount()) {
                Object[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == null) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = null;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            Object curKey = this.curKey;
            if (curKey == null) throw new IllegalStateException();
            if (this.expectedModCount++ != KolobokeObjectObjectHashMap.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = null;
            int index = this.index;
            Object[] tab = this.tab;
            if (tab == KolobokeObjectObjectHashMap.this.table) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                KolobokeObjectObjectHashMap.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = null;
                                        this.tab[indexToRemove + 1] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = castedKeyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                }
                tab[indexToRemove] = null;
                tab[indexToRemove + 1] = null;
                KolobokeObjectObjectHashMap.this.postRemoveHook();
                return;
            } else {
                KolobokeObjectObjectHashMap.this.justRemove(curKey);
                tab[index] = null;
                tab[index + 1] = null;
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, K key, V value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(V newValue) {
                if (NoRemovedEntryCursor.this.tab == KolobokeObjectObjectHashMap.this.table) {
                    NoRemovedEntryCursor.this.tab[NoRemovedEntryCursor.this.index + 1] = newValue;
                } else {
                    KolobokeObjectObjectHashMap.this.justPut(this.key, newValue);
                    if (this.modCount != KolobokeObjectObjectHashMap.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, V>> {
        Object[] tab;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = KolobokeObjectObjectHashMap.this.table;
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            this.capacityMask = tab.length - 2;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                Object key = tab[nextI];
                if (key == null) continue;
                this.next = new MutableEntry2(mc, nextI, key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == null) continue;
                action.accept((Map.Entry)((Object)new MutableEntry2(mc, i, key, tab[i + 1])));
            }
            if (nextI != this.nextIndex || mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, V> next() {
            int mc = this.expectedModCount;
            if (mc == KolobokeObjectObjectHashMap.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] tab = this.tab;
                    MutableEntry prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        Object key = tab[nextI];
                        if (key == null) continue;
                        this.next = new MutableEntry2(mc, nextI, key, tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != KolobokeObjectObjectHashMap.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            Object[] tab = this.tab;
            if (tab == KolobokeObjectObjectHashMap.this.table) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                KolobokeObjectObjectHashMap.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = null;
                                        this.tab[indexToRemove + 1] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = new MutableEntry2(KolobokeObjectObjectHashMap.this.modCount(), indexToShift, castedKeyToShift, tab[indexToShift + 1]);
                                }
                            }
                        }
                        tab[indexToRemove] = castedKeyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                }
                tab[indexToRemove] = null;
                tab[indexToRemove + 1] = null;
                KolobokeObjectObjectHashMap.this.postRemoveHook();
                return;
            } else {
                KolobokeObjectObjectHashMap.this.justRemove(tab[index]);
                tab[index] = null;
                tab[index + 1] = null;
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, K key, V value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(V newValue) {
                if (NoRemovedEntryIterator.this.tab == KolobokeObjectObjectHashMap.this.table) {
                    NoRemovedEntryIterator.this.tab[NoRemovedEntryIterator.this.index + 1] = newValue;
                } else {
                    KolobokeObjectObjectHashMap.this.justPut(this.key, newValue);
                    if (this.modCount != KolobokeObjectObjectHashMap.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractObjValueView<V> {
        ValueView() {
        }

        public Equivalence<V> equivalence() {
            return KolobokeObjectObjectHashMap.this.valueEquivalence();
        }

        public int size() {
            return KolobokeObjectObjectHashMap.this.size();
        }

        public boolean shrink() {
            return KolobokeObjectObjectHashMap.this.shrink();
        }

        public boolean contains(Object o) {
            return KolobokeObjectObjectHashMap.this.containsValue(o);
        }

        public void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == null) continue;
                action.accept(tab[i + 1]);
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(Predicate<? super V> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == null || predicate.test(tab[i + 1])) continue;
                terminated = true;
                break;
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == null || c.contains(tab[i + 1])) continue;
                containsAll = false;
                break;
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ObjCollection<? super V> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == null) continue;
                changed |= c.add(tab[i + 1]);
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == null) continue;
                changed |= s.remove(tab[i + 1]);
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ObjIterator<V> iterator() {
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ObjCursor<V> cursor() {
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == null) continue;
                result[resultIndex++] = tab[i + 1];
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == null) continue;
                a[resultIndex++] = tab[i + 1];
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object val;
                if (tab[i] == null) continue;
                sb.append(' ').append((val = tab[i + 1]) != this ? val : "(this Collection)").append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return KolobokeObjectObjectHashMap.this.removeValue(o);
        }

        public void clear() {
            KolobokeObjectObjectHashMap.this.clear();
        }

        public boolean removeIf(Predicate<? super V> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    if (tab[i] == null || !filter.test(tab[i + 1])) continue;
                    KolobokeObjectObjectHashMap.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Support.ObjHash.REMOVED;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = castedKeyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                        }
                        tab[indexToRemove] = null;
                        tab[indexToRemove + 1] = null;
                        KolobokeObjectObjectHashMap.this.postRemoveHook();
                    } else {
                        tab[i] = Support.ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                KolobokeObjectObjectHashMap.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    if (tab[i] == null || !c.contains(tab[i + 1])) continue;
                    KolobokeObjectObjectHashMap.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Support.ObjHash.REMOVED;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = castedKeyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                        }
                        tab[indexToRemove] = null;
                        tab[indexToRemove + 1] = null;
                        KolobokeObjectObjectHashMap.this.postRemoveHook();
                    } else {
                        tab[i] = Support.ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                KolobokeObjectObjectHashMap.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block12: {
                    if (tab[i] == null || c.contains(tab[i + 1])) continue;
                    KolobokeObjectObjectHashMap.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Support.ObjHash.REMOVED;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = castedKeyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                        }
                        tab[indexToRemove] = null;
                        tab[indexToRemove + 1] = null;
                        KolobokeObjectObjectHashMap.this.postRemoveHook();
                    } else {
                        tab[i] = Support.ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                KolobokeObjectObjectHashMap.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ObjObjEntry {
        private K key;
        private V value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, V value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ObjObjEntry {
        final int modCount;
        private final int index;
        final K key;
        private V value;

        MutableEntry(int modCount, int index, K key, V value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }

        public V setValue(V newValue) {
            if (this.modCount != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new IllegalStateException();
            }
            Object oldValue = this.value;
            Object unwrappedNewValue = newValue;
            this.value = unwrappedNewValue;
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(V newValue) {
            KolobokeObjectObjectHashMap.this.table[this.index + 1] = newValue;
        }
    }

    abstract class ObjObjEntry
    extends AbstractEntry<K, V> {
        ObjObjEntry() {
        }

        abstract K key();

        public final K getKey() {
            return this.key();
        }

        abstract V value();

        public final V getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                Object v2 = e2.getValue();
                return KolobokeObjectObjectHashMap.this.nullableKeyEquals(k2, this.key()) && KolobokeObjectObjectHashMap.this.nullableValueEquals(v2, this.value());
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return KolobokeObjectObjectHashMap.this.nullableKeyHashCode(this.key()) ^ KolobokeObjectObjectHashMap.this.nullableValueHashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, V>>
    implements HashObjSet<Map.Entry<K, V>>,
    InternalObjCollectionOps<Map.Entry<K, V>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<K, V>> equivalence() {
            return Equivalence.entryEquivalence(KolobokeObjectObjectHashMap.this.keyEquivalence(), KolobokeObjectObjectHashMap.this.valueEquivalence());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return KolobokeObjectObjectHashMap.this.hashConfig();
        }

        public int size() {
            return KolobokeObjectObjectHashMap.this.size;
        }

        public double currentLoad() {
            return KolobokeObjectObjectHashMap.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return KolobokeObjectObjectHashMap.this.containsEntry(e.getKey(), e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == null) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == null) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == null) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, tab[i + 1])));
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, V>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == null || predicate.test((Map.Entry)((Object)new MutableEntry(mc, i, key, tab[i + 1])))) continue;
                terminated = true;
                break;
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<K, V>> iterator() {
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, V>> cursor() {
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == null || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == null) continue;
                changed |= s.remove((Object)e.with(key, tab[i + 1]));
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, V>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == null) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return KolobokeObjectObjectHashMap.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == null) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Collection)");
                sb.append('=');
                Object val = tab[i + 1];
                sb.append(val != this ? val : "(this Collection)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return KolobokeObjectObjectHashMap.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return KolobokeObjectObjectHashMap.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, V>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block11: {
                    Object key = tab[i];
                    if (key == null || !filter.test((Map.Entry)((Object)new MutableEntry(mc, i, key, tab[i + 1])))) continue;
                    KolobokeObjectObjectHashMap.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Support.ObjHash.REMOVED;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = castedKeyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                        }
                        tab[indexToRemove] = null;
                        tab[indexToRemove + 1] = null;
                        KolobokeObjectObjectHashMap.this.postRemoveHook();
                    } else {
                        tab[i] = Support.ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                KolobokeObjectObjectHashMap.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block13: {
                    Object key = tab[i];
                    if (key == null || !c.contains((Object)e.with(key, tab[i + 1]))) continue;
                    KolobokeObjectObjectHashMap.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Support.ObjHash.REMOVED;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = castedKeyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                        }
                        tab[indexToRemove] = null;
                        tab[indexToRemove + 1] = null;
                        KolobokeObjectObjectHashMap.this.postRemoveHook();
                    } else {
                        tab[i] = Support.ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                KolobokeObjectObjectHashMap.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = KolobokeObjectObjectHashMap.this.modCount();
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            int capacityMask = tab.length - 2;
            int firstDelayedRemoved = -1;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                block12: {
                    Object key = tab[i];
                    if (key == null || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                    KolobokeObjectObjectHashMap.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 2;
                        while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                            Object castedKeyToShift = keyToShift;
                            if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    tab[indexToRemove] = Support.ObjHash.REMOVED;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    i += 2;
                                }
                                tab[indexToRemove] = castedKeyToShift;
                                tab[indexToRemove + 1] = tab[indexToShift + 1];
                                indexToRemove = indexToShift;
                                shiftDistance = 2;
                                continue;
                            }
                            shiftDistance += 2;
                        }
                        tab[indexToRemove] = null;
                        tab[indexToRemove + 1] = null;
                        KolobokeObjectObjectHashMap.this.postRemoveHook();
                    } else {
                        tab[i] = Support.ObjHash.REMOVED;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                KolobokeObjectObjectHashMap.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            KolobokeObjectObjectHashMap.this.doClear();
        }
    }

    class NoRemovedKeyCursor
    extends NoRemovedCursor {
        private NoRemovedKeyCursor(int mc) {
            super(mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            Object curKey = this.curKey;
            if (curKey == null) throw new IllegalStateException();
            if (this.expectedModCount++ != KolobokeObjectObjectHashMap.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = null;
            int index = this.index;
            Object[] tab = this.tab;
            if (tab == KolobokeObjectObjectHashMap.this.table) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                KolobokeObjectObjectHashMap.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = null;
                                        this.tab[indexToRemove + 1] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = castedKeyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                }
                tab[indexToRemove] = null;
                tab[indexToRemove + 1] = null;
                KolobokeObjectObjectHashMap.this.postRemoveHook();
                return;
            } else {
                KolobokeObjectObjectHashMap.this.justRemove(curKey);
                tab[index] = null;
                tab[index + 1] = null;
            }
        }
    }

    class NoRemovedKeyIterator
    extends NoRemovedIterator {
        private NoRemovedKeyIterator(int mc) {
            super(mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != KolobokeObjectObjectHashMap.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            Object[] tab = this.tab;
            if (tab == KolobokeObjectObjectHashMap.this.table) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                KolobokeObjectObjectHashMap.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = null;
                                        this.tab[indexToRemove + 1] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = castedKeyToShift;
                                }
                            }
                        }
                        tab[indexToRemove] = castedKeyToShift;
                        tab[indexToRemove + 1] = tab[indexToShift + 1];
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                }
                tab[indexToRemove] = null;
                tab[indexToRemove + 1] = null;
                KolobokeObjectObjectHashMap.this.postRemoveHook();
                return;
            } else {
                KolobokeObjectObjectHashMap.this.justRemove(tab[index]);
                tab[index] = null;
                tab[index + 1] = null;
            }
        }
    }

    class NoRemovedCursor
    implements ObjCursor<K> {
        Object[] tab;
        final int capacityMask;
        int expectedModCount;
        int index;
        Object curKey;

        NoRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = KolobokeObjectObjectHashMap.this.table;
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            this.capacityMask = tab.length - 2;
            this.index = tab.length;
            this.curKey = null;
        }

        public void forEachForward(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == null) continue;
                action.accept(key);
            }
            if (index != this.index || mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = null;
        }

        public K elem() {
            Object curKey = this.curKey;
            if (curKey != null) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == KolobokeObjectObjectHashMap.this.modCount()) {
                Object[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == null) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = null;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            Object curKey = this.curKey;
            if (curKey == null) throw new IllegalStateException();
            if (this.expectedModCount++ != KolobokeObjectObjectHashMap.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = null;
            int index = this.index;
            Object[] tab = this.tab;
            if (tab == KolobokeObjectObjectHashMap.this.table) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                KolobokeObjectObjectHashMap.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = index += 2;
                            }
                        }
                        tab[indexToRemove] = castedKeyToShift;
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                }
                tab[indexToRemove] = null;
                KolobokeObjectObjectHashMap.this.postRemoveHook();
                return;
            } else {
                KolobokeObjectObjectHashMap.this.justRemove(curKey);
                tab[index] = null;
            }
        }
    }

    class NoRemovedIterator
    implements ObjIterator<K> {
        Object[] tab;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        K next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = KolobokeObjectObjectHashMap.this.table;
            Object[] tab = KolobokeObjectObjectHashMap.this.table;
            this.capacityMask = tab.length - 2;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                Object key = tab[nextI];
                if (key == null) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super K> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == null) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != KolobokeObjectObjectHashMap.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public K next() {
            if (this.expectedModCount == KolobokeObjectObjectHashMap.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] tab = this.tab;
                    Object prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        Object key = tab[nextI];
                        if (key == null) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != KolobokeObjectObjectHashMap.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            Object[] tab = this.tab;
            if (tab == KolobokeObjectObjectHashMap.this.table) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                KolobokeObjectObjectHashMap.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 2;
                while ((keyToShift = tab[indexToShift = indexToShift - 2 & capacityMask]) != null) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.ParallelKVObjKeyMixing.mix((int)KolobokeObjectObjectHashMap.this.keyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 2;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.tab[indexToRemove] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 2) {
                                    this.next = castedKeyToShift;
                                }
                            }
                        }
                        tab[indexToRemove] = castedKeyToShift;
                        indexToRemove = indexToShift;
                        shiftDistance = 2;
                        continue;
                    }
                    shiftDistance += 2;
                }
                tab[indexToRemove] = null;
                KolobokeObjectObjectHashMap.this.postRemoveHook();
                return;
            } else {
                KolobokeObjectObjectHashMap.this.justRemove(tab[index]);
                tab[index] = null;
            }
        }
    }

    class KeyView
    extends AbstractObjKeyView<K>
    implements HashObjSet<K>,
    InternalObjCollectionOps<K>,
    Support.ParallelKVObjLHash {
        KeyView() {
        }

        @Nonnull
        public Equivalence<K> equivalence() {
            return KolobokeObjectObjectHashMap.this.keyEquivalence();
        }

        @Nonnull
        public HashConfig hashConfig() {
            return KolobokeObjectObjectHashMap.this.hashConfig();
        }

        public HashConfigWrapper configWrapper() {
            return KolobokeObjectObjectHashMap.this.configWrapper();
        }

        public int size() {
            return KolobokeObjectObjectHashMap.this.size();
        }

        public double currentLoad() {
            return KolobokeObjectObjectHashMap.this.currentLoad();
        }

        @Override
        @Nonnull
        public Object[] table() {
            return KolobokeObjectObjectHashMap.this.table();
        }

        public int capacity() {
            return KolobokeObjectObjectHashMap.this.capacity();
        }

        public int freeSlots() {
            return KolobokeObjectObjectHashMap.this.freeSlots();
        }

        public boolean noRemoved() {
            return KolobokeObjectObjectHashMap.this.noRemoved();
        }

        public int removedSlots() {
            return KolobokeObjectObjectHashMap.this.removedSlots();
        }

        public int modCount() {
            return KolobokeObjectObjectHashMap.this.modCount();
        }

        public final boolean contains(Object o) {
            return KolobokeObjectObjectHashMap.this.contains(o);
        }

        public void forEach(Consumer<? super K> action) {
            KolobokeObjectObjectHashMap.this.forEach(action);
        }

        public boolean forEachWhile(Predicate<? super K> predicate) {
            return KolobokeObjectObjectHashMap.this.forEachWhile(predicate);
        }

        public boolean allContainingIn(ObjCollection<?> c) {
            return KolobokeObjectObjectHashMap.this.allContainingIn(c);
        }

        public boolean reverseAddAllTo(ObjCollection<? super K> c) {
            return KolobokeObjectObjectHashMap.this.reverseAddAllTo(c);
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            return KolobokeObjectObjectHashMap.this.reverseRemoveAllFrom(s);
        }

        @Nonnull
        public ObjIterator<K> iterator() {
            return KolobokeObjectObjectHashMap.this.iterator();
        }

        @Nonnull
        public ObjCursor<K> cursor() {
            return KolobokeObjectObjectHashMap.this.setCursor();
        }

        @Nonnull
        public Object[] toArray() {
            return KolobokeObjectObjectHashMap.this.toArray();
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            return KolobokeObjectObjectHashMap.this.toArray(a);
        }

        public int hashCode() {
            return KolobokeObjectObjectHashMap.this.setHashCode();
        }

        public String toString() {
            return KolobokeObjectObjectHashMap.this.setToString();
        }

        public boolean shrink() {
            return KolobokeObjectObjectHashMap.this.shrink();
        }

        public final boolean remove(Object o) {
            return KolobokeObjectObjectHashMap.this.justRemove(o);
        }

        public boolean removeIf(Predicate<? super K> filter) {
            return KolobokeObjectObjectHashMap.this.removeIf(filter);
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            InternalObjCollectionOps c2;
            if (c instanceof InternalObjCollectionOps && (c2 = (InternalObjCollectionOps)c).size() < this.size() && this.equivalence().equals((Object)c2.equivalence())) {
                return c2.reverseRemoveAllFrom((ObjSet)this);
            }
            return KolobokeObjectObjectHashMap.this.removeAll(this, c);
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            return KolobokeObjectObjectHashMap.this.retainAll(this, c);
        }

        public void clear() {
            KolobokeObjectObjectHashMap.this.clear();
        }
    }
}

