/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.collection;

import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.Maths;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.LHashCapacities;
import com.koloboke.function.ObjLongToLongFunction;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.snappydata.collection.ObjectLongHashMap;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.function.ObjLongConsumer;
import java.util.function.ToLongFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SuppressFBWarnings(value={"IA_AMBIGUOUS_INVOCATION_OF_INHERITED_OR_OUTER_METHOD"})
final class KolobokeObjectLongHashMap<K>
extends ObjectLongHashMap<K> {
    long[] values;
    K[] set;
    private HashConfigWrapper configWrapper;
    int size;
    private int maxSize;
    private int modCount = 0;
    static final HashConfigWrapper DEFAULT_CONFIG_WRAPPER = new HashConfigWrapper(HashConfig.getDefault());

    KolobokeObjectLongHashMap(int expectedSize) {
        this.init(DEFAULT_CONFIG_WRAPPER, expectedSize);
    }

    static void verifyConfig(HashConfig config) {
        if (config.getGrowthFactor() != 2.0) {
            throw new IllegalArgumentException(config + " passed, HashConfig for a hashtable\n" + "implementation with linear probing must have growthFactor of 2.0.\n" + "A Koloboke Compile-generated hashtable implementation could have\n" + "a different growth factor, if the implemented type is annotated with\n" + "@com.koloboke.compile.hash.algo.openaddressing.QuadraticProbing or\n" + "@com.koloboke.compile.hash.algo.openaddressing.DoubleHashing");
        }
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean containsKey(K key) {
        return this.contains(key);
    }

    boolean keyEquals(@Nonnull K a, @Nullable K b) {
        return a.equals(b);
    }

    public int capacity() {
        return this.set.length;
    }

    int keyHashCode(@Nonnull K key) {
        return key.hashCode();
    }

    public boolean contains(Object key) {
        return this.index(key) >= 0;
    }

    @Override
    public final int size() {
        return this.size;
    }

    int index(Object key) {
        if (key == null) {
            throw new NullPointerException("This hashtable implementation doesn't allow null keys.\nA Koloboke Compile-generated hashtable implementation could contain\nnull keys if the implemented type is annotated with\n@com.koloboke.compile.NullKeyAllowed");
        }
        Object k = key;
        K[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) & capacityMask;
        K cur = keys[index];
        if (cur == k) {
            return index;
        }
        if (cur == null) {
            return -1;
        }
        if (this.keyEquals(k, cur)) {
            return index;
        }
        do {
            if ((cur = keys[index = index - 1 & capacityMask]) == k) {
                return index;
            }
            if (cur != null) continue;
            return -1;
        } while (!this.keyEquals(k, cur));
        return index;
    }

    public final int modCount() {
        return this.modCount;
    }

    final void incrementModCount() {
        ++this.modCount;
    }

    public long defaultValue() {
        return 0L;
    }

    final void init(HashConfigWrapper configWrapper, int size) {
        KolobokeObjectLongHashMap.verifyConfig(configWrapper.config());
        this.configWrapper = configWrapper;
        this.size = 0;
        this.internalInit(this.targetCapacity(size));
    }

    int insert(K key, long value) {
        if (key == null) {
            throw new NullPointerException("This hashtable implementation doesn't allow null keys.\nA Koloboke Compile-generated hashtable implementation could contain\nnull keys if the implemented type is annotated with\n@com.koloboke.compile.NullKeyAllowed");
        }
        K[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) & capacityMask;
        K cur = keys[index];
        if (cur != null) {
            if (cur == key || this.keyEquals(key, cur)) {
                return index;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != key && !this.keyEquals(key, cur)) continue;
                return index;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    private void internalInit(int capacity) {
        assert (Maths.isPowerOf2((int)capacity));
        this.maxSize = this.maxSize(capacity);
        this.allocateArrays(capacity);
    }

    private int maxSize(int capacity) {
        return !this.isMaxCapacity(capacity) ? this.configWrapper.maxSize(capacity) : capacity - 1;
    }

    @Override
    public long getLong(K key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    private void _MutableSeparateKVObjLHashSO_allocateArrays(int capacity) {
        this.set = new Object[capacity];
    }

    final void initForRehash(int newCapacity) {
        ++this.modCount;
        this.internalInit(newCapacity);
    }

    private void _MutableSeparateKVObjLHashSO_clear() {
        this._MutableLHash_clear();
        this.fillFree();
    }

    private void fillFree() {
        Arrays.fill(this.set, null);
    }

    private void _MutableLHash_clear() {
        ++this.modCount;
        this.size = 0;
    }

    void allocateArrays(int capacity) {
        this._MutableSeparateKVObjLHashSO_allocateArrays(capacity);
        this.values = new long[capacity];
    }

    @Override
    public void forEach(ObjLongConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        K[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            K key = keys[i];
            if (key == null) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void postRemoveHook() {
        --this.size;
    }

    final void postInsertHook() {
        int capacity;
        if (++this.size > this.maxSize && !this.isMaxCapacity(capacity = this.capacity())) {
            this.rehash(capacity << 1);
        }
    }

    boolean doubleSizedArrays() {
        return false;
    }

    private int targetCapacity(int size) {
        return LHashCapacities.capacity((HashConfigWrapper)this.configWrapper, (int)size, (boolean)this.doubleSizedArrays());
    }

    private boolean isMaxCapacity(int capacity) {
        return LHashCapacities.isMaxCapacity((int)capacity, (boolean)this.doubleSizedArrays());
    }

    @SuppressFBWarnings(value={"EC_UNRELATED_TYPES_USING_POINTER_EQUALITY"})
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        K[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            K key = keys[i];
            if (key == null) continue;
            sb.append(' ');
            sb.append(key != this ? key : "(this Map)");
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    void rehash(int newCapacity) {
        int mc = this.modCount();
        K[] keys = this.set;
        long[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        K[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        long[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            K key = keys[i];
            if (key == null) continue;
            int index = LHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) & capacityMask;
            if (newKeys[index] != null) {
                while (newKeys[index = index - 1 & capacityMask] != null) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public long put(K key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        long[] vals = this.values;
        long prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public long computeIfAbsent(K key, ToLongFunction<? super K> mappingFunction) {
        block7: {
            if (key == null) {
                throw new NullPointerException("This hashtable implementation doesn't allow null keys.\nA Koloboke Compile-generated hashtable implementation could contain\nnull keys if the implemented type is annotated with\n@com.koloboke.compile.NullKeyAllowed");
            }
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            K[] keys = this.set;
            long[] vals = this.values;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) & capacityMask;
            K cur = keys[index];
            if (cur == key) {
                return vals[index];
            }
            if (cur != null) {
                if (this.keyEquals(key, cur)) {
                    return vals[index];
                }
                do {
                    if ((cur = keys[index = index - 1 & capacityMask]) == key) {
                        return vals[index];
                    }
                    if (cur == null) break block7;
                } while (!this.keyEquals(key, cur));
                return vals[index];
            }
        }
        long value = mappingFunction.applyAsLong(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = value;
        this.postInsertHook();
        return value;
    }

    @Override
    public long computeIfPresent(K key, ObjLongToLongFunction<? super K> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long newValue;
            long[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsLong(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Exception decompiling
     */
    @Override
    public long addValue(K key, long value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        this._MutableSeparateKVObjLHashSO_clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public long removeAsLong(K key) {
        K keyToShift;
        int indexToRemove;
        if (key == null) {
            throw new NullPointerException("This hashtable implementation doesn't allow null keys.\nA Koloboke Compile-generated hashtable implementation could contain\nnull keys if the implemented type is annotated with\n@com.koloboke.compile.NullKeyAllowed");
        }
        K k = key;
        K[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) & capacityMask;
        K cur = keys[index];
        if (cur != k) {
            if (cur == null) {
                return this.defaultValue();
            }
            if (!this.keyEquals(k, cur)) {
                while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                    if (cur == null) {
                        return this.defaultValue();
                    }
                    if (!this.keyEquals(k, cur)) continue;
                }
            }
        }
        long[] vals = this.values;
        long val = vals[index];
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != null) {
            if ((LHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
        }
        keys[indexToRemove] = null;
        this.postRemoveHook();
        return val;
    }

    KolobokeObjectLongHashMap(HashConfig hashConfig, int expectedSize) {
        this.init(new HashConfigWrapper(hashConfig), expectedSize);
    }

    static class Support {
        Support() {
        }
    }
}

