/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.task.DatabaseCommandWithCreationParameters;
import org.apache.ddlutils.task.DatabaseTaskBase;
import org.apache.ddlutils.task.PlatformConfiguration;
import org.apache.tools.ant.BuildException;

public class WriteSchemaSqlToFileCommand
extends DatabaseCommandWithCreationParameters {
    private File _outputFile;
    private boolean _alterDb = true;
    private boolean _doDrops = true;
    private boolean _exportDDLs;
    private boolean _exportAll;

    public void setOutputFile(File outputFile) {
        this._outputFile = outputFile;
    }

    protected boolean isAlterDatabase() {
        return this._alterDb;
    }

    public void setAlterDatabase(boolean alterTheDb) {
        this._alterDb = alterTheDb;
    }

    protected boolean isDoDrops() {
        return this._doDrops;
    }

    public void setDoDrops(boolean doDrops) {
        this._doDrops = doDrops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(DatabaseTaskBase task, Database model) throws BuildException {
        if (this._outputFile == null) {
            throw new BuildException("No output file specified");
        }
        if (this._outputFile.exists() && !this._outputFile.canWrite()) {
            throw new BuildException("Cannot overwrite output file " + this._outputFile.getAbsolutePath());
        }
        Platform platform = this.getPlatform();
        boolean isCaseSensitive = platform.isDelimitedIdentifierModeOn();
        CreationParameters params = this.getFilteredParameters(model, platform.getName(), isCaseSensitive);
        FileWriter writer = null;
        try {
            writer = new FileWriter(this._outputFile);
            platform.setScriptModeOn(true);
            if (platform.getPlatformInfo().isSqlCommentsSupported()) {
                platform.setSqlCommentsOn(true);
            }
            if (this.isExportDDLs() && platform.getPlatformInfo().isDDLExportSupported()) {
                if (this._doDrops) {
                    platform.getSqlBuilder().setWriter(writer);
                    platform.getSqlBuilder().dropTables(model);
                }
                writer.write(platform.writeAllDDLs(this.isExportAll()));
                this._log.info((Object)("Exported schema SQL to " + this._outputFile.getAbsolutePath()));
                return;
            }
            if (this.isExportAll()) {
                if (!this.isExportDDLs()) {
                    throw new DdlUtilsException("Cannot export all in generic mode");
                }
                throw new DdlUtilsException("Platform " + platform.getName() + " does not support full export");
            }
            boolean shouldAlter = this.isAlterDatabase();
            if (shouldAlter) {
                if (this.getDataSource() == null) {
                    shouldAlter = false;
                    this._log.warn((Object)"Cannot alter the database because no database connection was specified. SQL for database creation will be generated instead.");
                } else {
                    try {
                        Connection connection = this.getDataSource().getConnection();
                        connection.close();
                    }
                    catch (SQLException ex) {
                        shouldAlter = false;
                        this._log.warn((Object)"Could not establish a connection to the specified database, so SQL for database creation will be generated instead.", (Throwable)ex);
                    }
                }
            }
            if (shouldAlter) {
                Database currentModel = this.getCatalogPattern() != null || this.getSchemaPattern() != null ? platform.readModelFromDatabase("unnamed", this.getCatalogPattern(), this.getSchemaPattern(), null) : platform.readModelFromDatabase("unnamed");
                writer.write(platform.getAlterModelSql(currentModel, model, params));
            } else {
                writer.write(platform.getCreateModelSql(model, params, this._doDrops, !this.isFailOnError()));
            }
            this._log.info((Object)("Written schema SQL to " + this._outputFile.getAbsolutePath()));
        }
        catch (Exception ex) {
            this.handleException(ex, ex.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    this._log.error((Object)("Could not close file " + this._outputFile.getAbsolutePath()), (Throwable)ex);
                }
            }
        }
    }

    public boolean isExportDDLs() {
        return this._exportDDLs;
    }

    public boolean isExportAll() {
        return this._exportAll;
    }

    public void setExportDDLs(boolean exportDDLs) {
        this._exportDDLs = exportDDLs;
        if (exportDDLs) {
            this.setAlterDatabase(false);
            this.setDoDrops(true);
        }
    }

    public void setExportAll(boolean exportAll) {
        this._exportAll = exportAll;
    }

    @Override
    protected void setPlatformConfiguration(PlatformConfiguration platformConf) {
        if (this.getDatabaseType() == null || this.getDataSource() == null) {
            this._platformConf = platformConf;
        }
    }

    public void setDatabaseType(String type) {
        if (type != null && type.length() > 0) {
            this._platformConf.setDatabaseType(type);
        }
    }

    public void addConfiguredDatabase(BasicDataSource dataSource) {
        this._platformConf.setDataSource(dataSource);
    }

    public void setCatalogPattern(String catalogPattern) {
        if (catalogPattern != null && catalogPattern.length() > 0) {
            this._platformConf.setCatalogPattern(catalogPattern);
        }
    }

    public void setSchemaPattern(String schemaPattern) {
        if (schemaPattern != null && schemaPattern.length() > 0) {
            this._platformConf.setSchemaPattern(schemaPattern);
        }
    }

    public boolean isUseDelimitedSqlIdentifiers() {
        return this._platformConf.isUseDelimitedSqlIdentifiers();
    }

    public void setUseDelimitedSqlIdentifiers(boolean useDelimitedSqlIdentifiers) {
        this._platformConf.setUseDelimitedSqlIdentifiers(useDelimitedSqlIdentifiers);
    }

    public boolean isSortForeignKeys() {
        return this._platformConf.isSortForeignKeys();
    }

    public void setSortForeignKeys(boolean sortForeignKeys) {
        this._platformConf.setSortForeignKeys(sortForeignKeys);
    }

    public boolean isShutdownDatabase() {
        return this._platformConf.isShutdownDatabase();
    }

    public void setShutdownDatabase(boolean shutdownDatabase) {
        this._platformConf.setShutdownDatabase(shutdownDatabase);
    }
}

