/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.io.DataReader;
import org.apache.ddlutils.io.DataSinkException;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.SqlBuilder;
import org.apache.ddlutils.task.ConvertingDatabaseCommand;
import org.apache.ddlutils.task.DatabaseTaskBase;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class WriteDataToDatabaseCommand
extends ConvertingDatabaseCommand {
    private File _singleDataFile = null;
    private ArrayList _fileSets = new ArrayList();
    private boolean _useExplicitIdentityValues;

    public void setUseExplicitIdentityValues(boolean useExplicitIdentityValues) {
        this._useExplicitIdentityValues = useExplicitIdentityValues;
    }

    public void addConfiguredFileset(FileSet fileset) {
        this._fileSets.add(fileset);
    }

    public void setDataFile(File dataFile) {
        this._singleDataFile = dataFile;
    }

    public void setBatchSize(int batchSize) {
        this.getDataIO().setBatchSize(batchSize);
    }

    public void setUseBatchMode(boolean useBatchMode) {
        this.getDataIO().setUseBatchMode(useBatchMode);
    }

    public void setEnsureForeignKeyOrder(boolean ensureFKOrder) {
        this.getDataIO().setEnsureFKOrder(ensureFKOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(DatabaseTaskBase task, Database model) throws BuildException {
        if (this._singleDataFile != null && !this._fileSets.isEmpty()) {
            throw new BuildException("Please use either the datafile attribute or the sub fileset element, but not both");
        }
        Platform platform = this.getPlatform();
        DataReader dataReader = null;
        boolean ignoreEndEx = true;
        platform.setAddIdentityUsingAlterTable(this._addIdentityUsingAlterTable);
        platform.setIdentityOverrideOn(this._useExplicitIdentityValues);
        try {
            dataReader = this.getDataIO().getConfiguredDataReader(platform, model);
            dataReader.getSink().start();
            if (this._singleDataFile != null) {
                this.readSingleDataFile(task, dataReader, this._singleDataFile);
            } else {
                for (FileSet fileSet : this._fileSets) {
                    File fileSetDir = fileSet.getDir(task.getProject());
                    DirectoryScanner scanner = fileSet.getDirectoryScanner(task.getProject());
                    String[] files = scanner.getIncludedFiles();
                    for (int idx = 0; files != null && idx < files.length; ++idx) {
                        this.readSingleDataFile(task, dataReader, new File(fileSetDir, files[idx]));
                    }
                }
            }
            ignoreEndEx = false;
        }
        catch (Exception ex) {
            this.handleException(ex, ex.getMessage());
            ignoreEndEx = false;
        }
        finally {
            if (dataReader != null) {
                if (ignoreEndEx) {
                    try {
                        dataReader.getSink().end();
                        this.writeAddIdentityUsingAlterTable(platform, model);
                    }
                    catch (DataSinkException dataSinkException) {}
                } else {
                    dataReader.getSink().end();
                    this.writeAddIdentityUsingAlterTable(platform, model);
                }
            }
        }
    }

    private void readSingleDataFile(Task task, DataReader reader, File dataFile) throws BuildException {
        if (!dataFile.exists()) {
            this._log.error((Object)("Could not find data file " + dataFile.getAbsolutePath()));
        } else if (!dataFile.isFile()) {
            this._log.error((Object)("Path " + dataFile.getAbsolutePath() + " does not denote a data file"));
        } else if (!dataFile.canRead()) {
            this._log.error((Object)("Could not read data file " + dataFile.getAbsolutePath()));
        } else {
            try {
                this.getDataIO().writeDataToDatabase(reader, dataFile.getAbsolutePath());
                this._log.info((Object)("Written data from file " + dataFile.getAbsolutePath() + " to database"));
            }
            catch (Exception ex) {
                this.handleException(ex, "Could not parse or write data file " + dataFile.getAbsolutePath());
            }
        }
    }

    protected void writeAddIdentityUsingAlterTable(Platform platform, Database model) throws DataSinkException {
        if (this._addIdentityUsingAlterTable && platform.getPlatformInfo().isAddingIdentityUsingAlterTableSupported()) {
            StringWriter buffer = new StringWriter();
            SqlBuilder builder = platform.getSqlBuilder();
            builder.setWriter(buffer);
            for (int index = 0; index < model.getTableCount(); ++index) {
                Table table = model.getTable(index);
                for (int col = 0; col < table.getColumnCount(); ++col) {
                    Column column = table.getColumn(col);
                    if (!column.isAutoIncrement()) continue;
                    try {
                        builder.writeAddIdentityColumnUsingAlterTable(table, column);
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new DataSinkException(ioe);
                    }
                }
            }
            String sql = buffer.toString();
            platform.evaluateBatch(sql, false);
        }
    }
}

