/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import com.pivotal.gemfirexd.callbacks.EventErrorFileToDBWriter;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.Command;
import org.apache.ddlutils.task.DatabaseTaskBase;
import org.apache.tools.ant.BuildException;

public class ReplayFailedDMLsCommand
extends Command {
    private String errorFileName;

    @Override
    public void execute(DatabaseTaskBase task, Database model) throws BuildException {
        Connection conn = null;
        try {
            BasicDataSource ds = task.getDataSource();
            conn = ds.getConnection();
            EventErrorFileToDBWriter.writeXMLToDB((Connection)conn, (String)this.errorFileName);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean isRequiringModel() {
        return false;
    }

    public void setErrorFileName(String name) {
        this.errorFileName = name;
    }

    public String getErrorFileName() {
        return this.errorFileName;
    }
}

