/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.CloneHelper;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ModelHelper;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.task.DatabaseCommand;
import org.apache.ddlutils.task.DatabaseTaskBase;
import org.apache.ddlutils.task.TaskHelper;
import org.apache.tools.ant.BuildException;

public class DropTablesCommand
extends DatabaseCommand {
    private String[] _tableNames;
    private String _tableNameRegExp;

    public void setTables(String tableNameList) {
        this._tableNames = new TaskHelper().parseCommaSeparatedStringList(tableNameList);
    }

    public void setTableFilter(String tableNameRegExp) {
        this._tableNameRegExp = tableNameRegExp;
    }

    @Override
    public boolean isRequiringModel() {
        return true;
    }

    @Override
    public void execute(DatabaseTaskBase task, Database model) throws BuildException {
        BasicDataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            throw new BuildException("No database specified.");
        }
        Platform platform = this.getPlatform();
        Database targetModel = new Database();
        if (this._tableNames != null || this._tableNameRegExp != null) {
            targetModel = new CloneHelper().clone(model);
            targetModel.initialize();
            Table[] tables = this._tableNames != null ? targetModel.findTables(this._tableNames, task.isUseDelimitedSqlIdentifiers()) : targetModel.findTables(this._tableNameRegExp, task.isUseDelimitedSqlIdentifiers());
            new ModelHelper().removeForeignKeysToAndFromTables(targetModel, tables);
            targetModel.removeTables(tables);
        }
        try {
            platform.alterModel(model, targetModel, this.isFailOnError());
            this._log.info((Object)"Dropped tables");
        }
        catch (Exception ex) {
            this.handleException(ex, ex.getMessage());
        }
    }
}

