/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.sapdb;

import java.io.IOException;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.alteration.ModelComparator;
import org.apache.ddlutils.alteration.PrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.RemovePrimaryKeyChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.DefaultTableDefinitionChangesPredicate;
import org.apache.ddlutils.platform.PlatformImplBase;
import org.apache.ddlutils.platform.sapdb.SapDbBuilder;
import org.apache.ddlutils.platform.sapdb.SapDbModelReader;
import org.apache.ddlutils.util.StringUtilsExt;

public class SapDbPlatform
extends PlatformImplBase {
    public static final String DATABASENAME = "SapDB";
    public static final String JDBC_DRIVER = "com.sap.dbtech.jdbc.DriverSapDB";
    public static final String JDBC_SUBPROTOCOL = "sapdb";

    public SapDbPlatform() {
        PlatformInfo info = this.getPlatformInfo();
        info.setMaxIdentifierLength(32);
        info.setPrimaryKeyColumnAutomaticallyRequired(true);
        info.setMultipleIdentityColumnsSupported(false);
        info.setCommentPrefix("/*");
        info.setCommentSuffix("*/");
        info.setSupportedOnDeleteActions(new CascadeActionEnum[]{CascadeActionEnum.CASCADE, CascadeActionEnum.RESTRICT, CascadeActionEnum.SET_DEFAULT, CascadeActionEnum.SET_NULL, CascadeActionEnum.NONE});
        info.addEquivalentOnDeleteActions(CascadeActionEnum.NONE, CascadeActionEnum.RESTRICT);
        info.setSupportedOnUpdateActions(new CascadeActionEnum[]{CascadeActionEnum.NONE});
        info.addEquivalentOnUpdateActions(CascadeActionEnum.NONE, CascadeActionEnum.RESTRICT);
        info.addNativeTypeMapping(2003, "LONG BYTE", -4);
        info.addNativeTypeMapping(-5, "FIXED(38,0)");
        info.addNativeTypeMapping(-2, "CHAR{0} BYTE");
        info.addNativeTypeMapping(-7, "BOOLEAN");
        info.addNativeTypeMapping(2004, "LONG BYTE", -4);
        info.addNativeTypeMapping(16, "BOOLEAN", -7);
        info.addNativeTypeMapping(2005, "LONG", -1);
        info.addNativeTypeMapping(70, "LONG BYTE", -4);
        info.addNativeTypeMapping(3, "FIXED");
        info.addNativeTypeMapping(2001, "LONG BYTE", -4);
        info.addNativeTypeMapping(8, "FLOAT(38)", 6);
        info.addNativeTypeMapping(6, "FLOAT(38)");
        info.addNativeTypeMapping(2000, "LONG BYTE", -4);
        info.addNativeTypeMapping(-4, "LONG BYTE");
        info.addNativeTypeMapping(-1, "LONG");
        info.addNativeTypeMapping(0, "LONG BYTE", -4);
        info.addNativeTypeMapping(2, "FIXED", 3);
        info.addNativeTypeMapping(1111, "LONG BYTE", -4);
        info.addNativeTypeMapping(7, "FLOAT(16)", 6);
        info.addNativeTypeMapping(2006, "LONG BYTE", -4);
        info.addNativeTypeMapping(2002, "LONG BYTE", -4);
        info.addNativeTypeMapping(-6, "SMALLINT", 5);
        info.addNativeTypeMapping(-3, "VARCHAR{0} BYTE");
        info.setDefaultSize(1, 254);
        info.setDefaultSize(12, 254);
        info.setDefaultSize(-2, 254);
        info.setDefaultSize(-3, 254);
        this.setSqlBuilder(new SapDbBuilder(this));
        this.setModelReader(new SapDbModelReader(this));
    }

    @Override
    public String getName() {
        return DATABASENAME;
    }

    @Override
    protected ModelComparator getModelComparator() {
        ModelComparator comparator = super.getModelComparator();
        comparator.setCanDropPrimaryKeyColumns(false);
        comparator.setGeneratePrimaryKeyChanges(false);
        return comparator;
    }

    @Override
    protected TableDefinitionChangesPredicate getTableDefinitionChangesPredicate() {
        return new DefaultTableDefinitionChangesPredicate(){

            @Override
            protected boolean isSupported(Table intermediateTable, TableChange change) {
                if (change instanceof RemoveColumnChange || change instanceof AddPrimaryKeyChange || change instanceof PrimaryKeyChange || change instanceof RemovePrimaryKeyChange) {
                    return true;
                }
                if (change instanceof AddColumnChange) {
                    AddColumnChange addColumnChange = (AddColumnChange)change;
                    return addColumnChange.getNextColumn() == null && (!addColumnChange.getNewColumn().isRequired() || !StringUtilsExt.isEmpty((String)addColumnChange.getNewColumn().getDefaultValue()));
                }
                if (change instanceof ColumnDefinitionChange) {
                    ColumnDefinitionChange colChange = (ColumnDefinitionChange)change;
                    Column curColumn = intermediateTable.findColumn(colChange.getChangedColumn(), SapDbPlatform.this.isDelimitedIdentifierModeOn());
                    Column newColumn = colChange.getNewColumn();
                    return curColumn.getTypeCode() == newColumn.getTypeCode() && !ColumnDefinitionChange.isSizeChanged(SapDbPlatform.this.getPlatformInfo(), curColumn, newColumn) && curColumn.isAutoIncrement() == newColumn.isAutoIncrement();
                }
                return false;
            }
        };
    }

    public void processChange(Database currentModel, CreationParameters params, RemoveColumnChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column removedColumn = changedTable.findColumn(change.getChangedColumn(), this.isDelimitedIdentifierModeOn());
        ((SapDbBuilder)this.getSqlBuilder()).dropColumn(changedTable, removedColumn);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, RemovePrimaryKeyChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        ((SapDbBuilder)this.getSqlBuilder()).dropPrimaryKey(changedTable);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, PrimaryKeyChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        String[] newPKColumnNames = change.getNewPrimaryKeyColumns();
        Column[] newPKColumns = new Column[newPKColumnNames.length];
        for (int colIdx = 0; colIdx < newPKColumnNames.length; ++colIdx) {
            newPKColumns[colIdx] = changedTable.findColumn(newPKColumnNames[colIdx], this.isDelimitedIdentifierModeOn());
        }
        ((SapDbBuilder)this.getSqlBuilder()).dropPrimaryKey(changedTable);
        this.getSqlBuilder().createPrimaryKey(changedTable, newPKColumns);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, ColumnDefinitionChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column changedColumn = changedTable.findColumn(change.getChangedColumn(), this.isDelimitedIdentifierModeOn());
        if (!StringUtilsExt.equals((String)changedColumn.getDefaultValue(), (String)change.getNewColumn().getDefaultValue())) {
            ((SapDbBuilder)this.getSqlBuilder()).changeColumnDefaultValue(changedTable, changedColumn, change.getNewColumn().getDefaultValue());
        }
        if (changedColumn.isRequired() != change.getNewColumn().isRequired()) {
            ((SapDbBuilder)this.getSqlBuilder()).changeColumnRequiredStatus(changedTable, changedColumn, change.getNewColumn().isRequired());
        }
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }
}

