/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.sapdb;

import java.io.IOException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.SqlBuilder;
import org.apache.ddlutils.util.StringUtilsExt;

public class SapDbBuilder
extends SqlBuilder {
    public SapDbBuilder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    @Override
    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" CASCADE");
        this.printEndOfStatement();
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("DEFAULT SERIAL(1)");
    }

    @Override
    public void createPrimaryKey(Table table, Column[] primaryKeyColumns) throws IOException {
        if (primaryKeyColumns.length > 0 && this.shouldGeneratePrimaryKeys(primaryKeyColumns)) {
            this.print("ALTER TABLE ");
            this.printlnIdentifier(this.getTableName(table));
            this.printIndent();
            this.print("ADD ");
            this.writePrimaryKeyStmt(table, primaryKeyColumns);
            this.printEndOfStatement();
        }
    }

    @Override
    protected void writeForeignKeyOnDeleteAction(Table table, ForeignKey foreignKey) throws IOException {
        if (foreignKey.getOnDelete() != CascadeActionEnum.NONE) {
            super.writeForeignKeyOnDeleteAction(table, foreignKey);
        }
    }

    @Override
    public void dropForeignKey(Table table, ForeignKey foreignKey) throws IOException {
        this.writeTableAlterStmt(table);
        this.print("DROP FOREIGN KEY ");
        this.printIdentifier(this.getForeignKeyName(table, foreignKey));
        this.printEndOfStatement();
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        StringBuilder result = new StringBuilder();
        result.append("SELECT ");
        result.append(this.getDelimitedIdentifier(this.getTableName(table)));
        result.append(".CURRVAL FROM DUAL");
        return result.toString();
    }

    @Override
    public void addColumn(Database model, Table table, Column newColumn) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("ADD ");
        this.writeColumn(table, newColumn);
        this.printEndOfStatement();
    }

    public void dropColumn(Table table, Column column) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP ");
        this.printIdentifier(this.getColumnName(column));
        this.print(" RELEASE SPACE");
        this.printEndOfStatement();
    }

    public void dropPrimaryKey(Table table) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP PRIMARY KEY");
        this.printEndOfStatement();
    }

    public void changeColumnRequiredStatus(Table table, Column column, boolean isRequired) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("COLUMN ");
        this.printIdentifier(this.getColumnName(column));
        if (isRequired) {
            this.print(" NOT NULL");
        } else {
            this.print(" DEFAULT NULL");
        }
        this.printEndOfStatement();
    }

    public void changeColumnDefaultValue(Table table, Column column, String newDefaultValue) throws IOException {
        boolean hasDefault;
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("COLUMN ");
        this.printIdentifier(this.getColumnName(column));
        boolean bl = hasDefault = column.getParsedDefaultValue() != null;
        if (this.isValidDefaultValue(newDefaultValue, column.getTypeCode())) {
            if (hasDefault) {
                this.print(" ALTER DEFAULT ");
            } else {
                this.print(" ADD DEFAULT ");
            }
            this.printDefaultValue(newDefaultValue, column.getTypeCode());
        } else if (hasDefault) {
            this.print(" DROP DEFAULT");
        }
        this.printEndOfStatement();
    }

    @Override
    protected void writeCastExpression(Column sourceColumn, Column targetColumn) throws IOException {
        boolean charSizeChanged;
        boolean bl = charSizeChanged = TypeMap.isTextType(targetColumn.getTypeCode()) && TypeMap.isTextType(targetColumn.getTypeCode()) && ColumnDefinitionChange.isSizeChanged(this.getPlatformInfo(), sourceColumn, targetColumn) && !StringUtilsExt.isEmpty((String)targetColumn.getSize());
        if (charSizeChanged) {
            this.print("SUBSTR(");
        }
        this.printIdentifier(this.getColumnName(sourceColumn));
        if (charSizeChanged) {
            this.print(",1,");
            this.print(targetColumn.getSize());
            this.print(")");
        }
    }
}

