/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.postgresql;

import java.io.IOException;
import java.util.Map;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.SqlBuilder;

public class PostgreSqlBuilder
extends SqlBuilder {
    public PostgreSqlBuilder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("\\", "\\\\");
        this.addEscapedCharSequence("'", "\\'");
        this.addEscapedCharSequence("\b", "\\b");
        this.addEscapedCharSequence("\f", "\\f");
        this.addEscapedCharSequence("\n", "\\n");
        this.addEscapedCharSequence("\r", "\\r");
        this.addEscapedCharSequence("\t", "\\t");
    }

    @Override
    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" CASCADE");
        this.printEndOfStatement();
        Column[] columns = table.getAutoIncrementColumns();
        for (int idx = 0; idx < columns.length; ++idx) {
            this.dropAutoIncrementSequence(table, columns[idx]);
        }
    }

    @Override
    public void dropIndex(Table table, Index index) throws IOException {
        this.print("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }

    @Override
    public void createTable(Database database, Table table, Map parameters) throws IOException {
        for (int idx = 0; idx < table.getColumnCount(); ++idx) {
            Column column = table.getColumn(idx);
            if (!column.isAutoIncrement()) continue;
            this.createAutoIncrementSequence(table, column);
        }
        super.createTable(database, table, parameters);
    }

    private void createAutoIncrementSequence(Table table, Column column) throws IOException {
        this.print("CREATE SEQUENCE ");
        this.printIdentifier(this.getConstraintName(null, table, column.getName(), "seq"));
        this.printEndOfStatement();
    }

    private void dropAutoIncrementSequence(Table table, Column column) throws IOException {
        this.print("DROP SEQUENCE ");
        this.printIdentifier(this.getConstraintName(null, table, column.getName(), "seq"));
        this.printEndOfStatement();
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("UNIQUE DEFAULT nextval('");
        this.printIdentifier(this.getConstraintName(null, table, column.getName(), "seq"));
        this.print("')");
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        Column[] columns = table.getAutoIncrementColumns();
        if (columns.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append("SELECT ");
        for (int idx = 0; idx < columns.length; ++idx) {
            if (idx > 0) {
                result.append(", ");
            }
            result.append("currval('");
            result.append(this.getDelimitedIdentifier(this.getConstraintName(null, table, columns[idx].getName(), "seq")));
            result.append("') AS ");
            result.append(this.getDelimitedIdentifier(columns[idx].getName()));
        }
        return result.toString();
    }

    @Override
    public void addColumn(Database model, Table table, Column newColumn) throws IOException {
        if (newColumn.isAutoIncrement()) {
            this.createAutoIncrementSequence(table, newColumn);
        }
        super.addColumn(model, table, newColumn);
    }

    public void dropColumn(Table table, Column column) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(column));
        this.printEndOfStatement();
        if (column.isAutoIncrement()) {
            this.dropAutoIncrementSequence(table, column);
        }
    }

    @Override
    protected void writeCastExpression(Column sourceColumn, Column targetColumn) throws IOException {
        boolean sizeChanged = ColumnDefinitionChange.isSizeChanged(this.getPlatformInfo(), sourceColumn, targetColumn);
        boolean typeChanged = ColumnDefinitionChange.isTypeChanged(this.getPlatformInfo(), sourceColumn, targetColumn);
        if (sizeChanged || typeChanged) {
            this.print("CAST(");
            this.printIdentifier(this.getColumnName(sourceColumn));
            this.print(" AS ");
            this.print(this.getSqlType(targetColumn));
            this.print(")");
        } else {
            this.printIdentifier(this.getColumnName(sourceColumn));
        }
    }
}

