/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.oracle;

import java.io.IOException;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.PrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.RemovePrimaryKeyChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.DefaultTableDefinitionChangesPredicate;
import org.apache.ddlutils.platform.PlatformImplBase;
import org.apache.ddlutils.platform.oracle.Oracle8Builder;
import org.apache.ddlutils.platform.oracle.Oracle8ModelReader;

public class Oracle8Platform
extends PlatformImplBase {
    public static final String DATABASENAME = "Oracle";
    public static final String JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";
    public static final String JDBC_DRIVER_OLD = "oracle.jdbc.dnlddriver.OracleDriver";
    public static final String JDBC_SUBPROTOCOL_THIN = "oracle:thin";
    public static final String JDBC_SUBPROTOCOL_OCI8 = "oracle:oci8";
    public static final String JDBC_SUBPROTOCOL_THIN_OLD = "oracle:dnldthin";

    public Oracle8Platform() {
        PlatformInfo info = this.getPlatformInfo();
        info.setMaxIdentifierLength(30);
        info.setIdentityStatusReadingSupported(false);
        info.setPrimaryKeyColumnAutomaticallyRequired(true);
        info.setSupportedOnUpdateActions(new CascadeActionEnum[]{CascadeActionEnum.NONE});
        info.setSupportedOnDeleteActions(new CascadeActionEnum[]{CascadeActionEnum.CASCADE, CascadeActionEnum.SET_NULL, CascadeActionEnum.NONE});
        info.addEquivalentOnDeleteActions(CascadeActionEnum.NONE, CascadeActionEnum.RESTRICT);
        info.addNativeTypeMapping(2003, "BLOB", 2004);
        info.addNativeTypeMapping(-5, "NUMBER(38)");
        info.addNativeTypeMapping(-2, "RAW", -3);
        info.addNativeTypeMapping(-7, "NUMBER(1)");
        info.addNativeTypeMapping(16, "NUMBER(1)", -7);
        info.addNativeTypeMapping(70, "BLOB", 2004);
        info.addNativeTypeMapping(91, "DATE", 93);
        info.addNativeTypeMapping(3, "NUMBER");
        info.addNativeTypeMapping(2001, "BLOB", 2004);
        info.addNativeTypeMapping(8, "DOUBLE PRECISION");
        info.addNativeTypeMapping(6, "FLOAT", 8);
        info.addNativeTypeMapping(2000, "BLOB", 2004);
        info.addNativeTypeMapping(-4, "BLOB", 2004);
        info.addNativeTypeMapping(-1, "CLOB", 2005);
        info.addNativeTypeMapping(0, "BLOB", 2004);
        info.addNativeTypeMapping(2, "NUMBER", 3);
        info.addNativeTypeMapping(1111, "BLOB", 2004);
        info.addNativeTypeMapping(2006, "BLOB", 2004);
        info.addNativeTypeMapping(5, "NUMBER(5)");
        info.addNativeTypeMapping(2002, "BLOB", 2004);
        info.addNativeTypeMapping(92, "DATE", 93);
        info.addNativeTypeMapping(93, "DATE");
        info.addNativeTypeMapping(-6, "NUMBER(3)");
        info.addNativeTypeMapping(-3, "RAW");
        info.addNativeTypeMapping(12, "VARCHAR2");
        info.setDefaultSize(1, 254);
        info.setDefaultSize(12, 254);
        info.setDefaultSize(-2, 254);
        info.setDefaultSize(-3, 254);
        this.setSqlBuilder(new Oracle8Builder(this));
        this.setModelReader(new Oracle8ModelReader(this));
    }

    @Override
    public String getName() {
        return DATABASENAME;
    }

    @Override
    protected TableDefinitionChangesPredicate getTableDefinitionChangesPredicate() {
        return new DefaultTableDefinitionChangesPredicate(){

            @Override
            protected boolean isSupported(Table intermediateTable, TableChange change) {
                if (change instanceof AddPrimaryKeyChange || change instanceof RemovePrimaryKeyChange) {
                    return true;
                }
                if (change instanceof RemoveColumnChange) {
                    RemoveColumnChange removeColumnChange = (RemoveColumnChange)change;
                    Column column = intermediateTable.findColumn(removeColumnChange.getChangedColumn(), Oracle8Platform.this.isDelimitedIdentifierModeOn());
                    return !column.isPrimaryKey();
                }
                if (change instanceof AddColumnChange) {
                    AddColumnChange addColumnChange = (AddColumnChange)change;
                    return addColumnChange.isAtEnd() && (!addColumnChange.getNewColumn().isRequired() || addColumnChange.getNewColumn().getDefaultValue() != null);
                }
                return false;
            }
        };
    }

    public void processChange(Database currentModel, CreationParameters params, RemoveColumnChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column removedColumn = changedTable.findColumn(change.getChangedColumn(), this.isDelimitedIdentifierModeOn());
        ((Oracle8Builder)this.getSqlBuilder()).dropColumn(changedTable, removedColumn);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, RemovePrimaryKeyChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        ((Oracle8Builder)this.getSqlBuilder()).dropPrimaryKey(changedTable);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, PrimaryKeyChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        String[] newPKColumnNames = change.getNewPrimaryKeyColumns();
        Column[] newPKColumns = new Column[newPKColumnNames.length];
        for (int colIdx = 0; colIdx < newPKColumnNames.length; ++colIdx) {
            newPKColumns[colIdx] = changedTable.findColumn(newPKColumnNames[colIdx], this.isDelimitedIdentifierModeOn());
        }
        ((Oracle8Builder)this.getSqlBuilder()).dropPrimaryKey(changedTable);
        this.getSqlBuilder().createPrimaryKey(changedTable, newPKColumns);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }
}

