/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.oracle;

import java.lang.reflect.Field;
import org.apache.ddlutils.model.JdbcTypeCategoryEnum;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.oracle.Oracle10Builder;
import org.apache.ddlutils.platform.oracle.Oracle10ModelReader;
import org.apache.ddlutils.platform.oracle.Oracle9Platform;

public class Oracle10Platform
extends Oracle9Platform {
    public static final String DATABASENAME = "Oracle10";
    public static final String ORACLE_JDBC_TYPES_CLASSNAME = "oracle.jdbc.OracleTypes";

    public Oracle10Platform() {
        this.setSqlBuilder(new Oracle10Builder(this));
        this.setModelReader(new Oracle10ModelReader(this));
        this.registerOracleSpecificJDBCTypes();
    }

    private void registerOracleSpecificJDBCTypes() {
        this.getLog().debug((Object)"Trying to register Oracle10 specific JDBCTypes.");
        try {
            Class<?> oracleTypes = Class.forName(ORACLE_JDBC_TYPES_CLASSNAME);
            Field timestamptz = oracleTypes.getField("TIMESTAMPTZ");
            Field timestampltz = oracleTypes.getField("TIMESTAMPLTZ");
            TypeMap.registerJdbcType(timestamptz.getInt(timestamptz), "TIMESTAMP(6) WITH TIME ZONE", JdbcTypeCategoryEnum.DATETIME);
            TypeMap.registerJdbcType(timestampltz.getInt(timestampltz), "TIMESTAMP(6) WITH LOCAL TIME ZONE", JdbcTypeCategoryEnum.DATETIME);
        }
        catch (Exception e) {
            this.getLog().warn((Object)("Could not register additional JDBC Types: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return DATABASENAME;
    }
}

