/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.mysql;

import java.io.IOException;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.alteration.ModelComparator;
import org.apache.ddlutils.alteration.PrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.RemovePrimaryKeyChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.DefaultTableDefinitionChangesPredicate;
import org.apache.ddlutils.platform.PlatformImplBase;
import org.apache.ddlutils.platform.mysql.MySqlBuilder;
import org.apache.ddlutils.platform.mysql.MySqlModelComparator;
import org.apache.ddlutils.platform.mysql.MySqlModelReader;

public class MySqlPlatform
extends PlatformImplBase {
    public static final String DATABASENAME = "MySQL";
    public static final String JDBC_DRIVER = "com.mysql.jdbc.Driver";
    public static final String JDBC_DRIVER_OLD = "org.gjt.mm.mysql.Driver";
    public static final String JDBC_SUBPROTOCOL = "mysql";

    public MySqlPlatform() {
        PlatformInfo info = this.getPlatformInfo();
        info.setMaxIdentifierLength(64);
        info.setNullAsDefaultValueRequired(true);
        info.setDefaultValuesForLongTypesSupported(false);
        info.setNonPrimaryKeyIdentityColumnsSupported(false);
        info.setMultipleIdentityColumnsSupported(false);
        info.setMixingIdentityAndNormalPrimaryKeyColumnsSupported(false);
        info.setSyntheticDefaultValueForRequiredReturned(true);
        info.setPrimaryKeyColumnAutomaticallyRequired(true);
        info.setCommentPrefix("#");
        info.setDelimiterToken("`");
        info.setSupportedOnUpdateActions(new CascadeActionEnum[]{CascadeActionEnum.NONE, CascadeActionEnum.RESTRICT, CascadeActionEnum.CASCADE, CascadeActionEnum.SET_NULL});
        info.setDefaultOnUpdateAction(CascadeActionEnum.RESTRICT);
        info.setSupportedOnDeleteActions(new CascadeActionEnum[]{CascadeActionEnum.NONE, CascadeActionEnum.RESTRICT, CascadeActionEnum.CASCADE, CascadeActionEnum.SET_NULL});
        info.setDefaultOnDeleteAction(CascadeActionEnum.RESTRICT);
        info.addNativeTypeMapping(2003, "LONGBLOB", -4);
        info.addNativeTypeMapping(-7, "TINYINT(1)");
        info.addNativeTypeMapping(2004, "LONGBLOB", -4);
        info.addNativeTypeMapping(16, "TINYINT(1)", -7);
        info.addNativeTypeMapping(2005, "LONGTEXT", -1);
        info.addNativeTypeMapping(70, "MEDIUMBLOB", -4);
        info.addNativeTypeMapping(2001, "LONGBLOB", -4);
        info.addNativeTypeMapping(6, "DOUBLE", 8);
        info.addNativeTypeMapping(2000, "LONGBLOB", -4);
        info.addNativeTypeMapping(-4, "MEDIUMBLOB");
        info.addNativeTypeMapping(-1, "MEDIUMTEXT");
        info.addNativeTypeMapping(0, "MEDIUMBLOB", -4);
        info.addNativeTypeMapping(2, "DECIMAL", 3);
        info.addNativeTypeMapping(1111, "LONGBLOB", -4);
        info.addNativeTypeMapping(7, "FLOAT");
        info.addNativeTypeMapping(2006, "MEDIUMBLOB", -4);
        info.addNativeTypeMapping(2002, "LONGBLOB", -4);
        info.addNativeTypeMapping(93, "DATETIME");
        info.addNativeTypeMapping(-6, "SMALLINT", 5);
        info.setDefaultSize(1, 254);
        info.setDefaultSize(12, 254);
        info.setDefaultSize(-2, 254);
        info.setDefaultSize(-3, 254);
        this.setSqlBuilder(new MySqlBuilder(this));
        this.setModelReader(new MySqlModelReader(this));
    }

    @Override
    public String getName() {
        return DATABASENAME;
    }

    @Override
    protected ModelComparator getModelComparator() {
        return new MySqlModelComparator(this.getPlatformInfo(), this.getTableDefinitionChangesPredicate(), this.isDelimitedIdentifierModeOn());
    }

    @Override
    protected TableDefinitionChangesPredicate getTableDefinitionChangesPredicate() {
        return new DefaultTableDefinitionChangesPredicate(){

            @Override
            protected boolean isSupported(Table intermediateTable, TableChange change) {
                if (change instanceof AddColumnChange) {
                    AddColumnChange addColumnChange = (AddColumnChange)change;
                    return !addColumnChange.getNewColumn().isAutoIncrement() && (!addColumnChange.getNewColumn().isRequired() || addColumnChange.getNewColumn().getDefaultValue() != null);
                }
                if (change instanceof ColumnDefinitionChange) {
                    ColumnDefinitionChange colDefChange = (ColumnDefinitionChange)change;
                    Column sourceColumn = intermediateTable.findColumn(colDefChange.getChangedColumn(), MySqlPlatform.this.isDelimitedIdentifierModeOn());
                    return !ColumnDefinitionChange.isTypeChanged(MySqlPlatform.this.getPlatformInfo(), sourceColumn, colDefChange.getNewColumn()) && !ColumnDefinitionChange.isSizeChanged(MySqlPlatform.this.getPlatformInfo(), sourceColumn, colDefChange.getNewColumn());
                }
                return change instanceof RemoveColumnChange || change instanceof AddPrimaryKeyChange || change instanceof PrimaryKeyChange || change instanceof RemovePrimaryKeyChange;
            }
        };
    }

    @Override
    public void processChange(Database currentModel, CreationParameters params, AddColumnChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column prevColumn = null;
        if (change.getPreviousColumn() != null) {
            prevColumn = changedTable.findColumn(change.getPreviousColumn(), this.isDelimitedIdentifierModeOn());
        }
        ((MySqlBuilder)this.getSqlBuilder()).insertColumn(changedTable, change.getNewColumn(), prevColumn);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, ColumnDefinitionChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        ((MySqlBuilder)this.getSqlBuilder()).recreateColumn(changedTable, change.getNewColumn());
    }

    public void processChange(Database currentModel, CreationParameters params, RemoveColumnChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column removedColumn = changedTable.findColumn(change.getChangedColumn(), this.isDelimitedIdentifierModeOn());
        ((MySqlBuilder)this.getSqlBuilder()).dropColumn(changedTable, removedColumn);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, RemovePrimaryKeyChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        ((MySqlBuilder)this.getSqlBuilder()).dropPrimaryKey(changedTable);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, PrimaryKeyChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        String[] newPKColumnNames = change.getNewPrimaryKeyColumns();
        Column[] newPKColumns = new Column[newPKColumnNames.length];
        for (int colIdx = 0; colIdx < newPKColumnNames.length; ++colIdx) {
            newPKColumns[colIdx] = changedTable.findColumn(newPKColumnNames[colIdx], this.isDelimitedIdentifierModeOn());
        }
        ((MySqlBuilder)this.getSqlBuilder()).dropPrimaryKey(changedTable);
        this.getSqlBuilder().createPrimaryKey(changedTable, newPKColumns);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }
}

