/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.mysql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddForeignKeyChange;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.alteration.ModelComparator;
import org.apache.ddlutils.alteration.RemoveForeignKeyChange;
import org.apache.ddlutils.alteration.RemoveIndexChange;
import org.apache.ddlutils.alteration.TableChangeImplBase;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.util.StringUtilsExt;

public class MySqlModelComparator
extends ModelComparator {
    public MySqlModelComparator(PlatformInfo platformInfo, TableDefinitionChangesPredicate tableDefChangePredicate, boolean caseSensitive) {
        super(platformInfo, tableDefChangePredicate, caseSensitive);
    }

    @Override
    protected List checkForRemovedIndexes(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        List changes = super.checkForRemovedIndexes(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable);
        HashSet<String> columnNames = new HashSet<String>();
        for (RemoveIndexChange change : changes) {
            Index index = change.findChangedIndex(sourceModel, this.isCaseSensitive());
            for (int colIdx = 0; colIdx < index.getColumnCount(); ++colIdx) {
                columnNames.add(index.getColumn(colIdx).getName());
            }
        }
        if (!columnNames.isEmpty()) {
            changes.addAll(this.getForeignKeyRecreationChanges(intermediateTable, targetTable, columnNames));
        }
        return changes;
    }

    @Override
    protected List compareTables(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        List changes = super.compareTables(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable);
        HashSet<String> columnNames = new HashSet<String>();
        for (Object change : changes) {
            if (!(change instanceof ColumnDefinitionChange)) continue;
            ColumnDefinitionChange colDefChange = (ColumnDefinitionChange)change;
            Column sourceColumn = sourceTable.findColumn(colDefChange.getChangedColumn(), this.isCaseSensitive());
            if (!ColumnDefinitionChange.isTypeChanged(this.getPlatformInfo(), sourceColumn, colDefChange.getNewColumn())) continue;
            columnNames.add(sourceColumn.getName());
        }
        if (!columnNames.isEmpty()) {
            changes.addAll(this.getForeignKeyRecreationChanges(intermediateTable, targetTable, columnNames));
        }
        return changes;
    }

    private List getForeignKeyRecreationChanges(Table intermediateTable, Table targetTable, Set columnNames) {
        ArrayList<TableChangeImplBase> newChanges = new ArrayList<TableChangeImplBase>();
        for (int fkIdx = 0; fkIdx < targetTable.getForeignKeyCount(); ++fkIdx) {
            ForeignKey targetFk = targetTable.getForeignKey(fkIdx);
            ForeignKey intermediateFk = intermediateTable.findForeignKey(targetFk, this.isCaseSensitive());
            if (intermediateFk == null) continue;
            for (int refIdx = 0; refIdx < intermediateFk.getReferenceCount(); ++refIdx) {
                Reference ref = intermediateFk.getReference(refIdx);
                Iterator colNameIt = columnNames.iterator();
                while (colNameIt.hasNext()) {
                    if (!StringUtilsExt.equals(ref.getLocalColumnName(), (String)colNameIt.next(), this.isCaseSensitive())) continue;
                    newChanges.add(new RemoveForeignKeyChange(intermediateTable.getName(), intermediateFk));
                    newChanges.add(new AddForeignKeyChange(intermediateTable.getName(), intermediateFk));
                }
            }
        }
        return newChanges;
    }
}

