/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.mssql;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.DatabaseMetaDataWrapper;
import org.apache.ddlutils.platform.JdbcModelReader;

public class MSSqlModelReader
extends JdbcModelReader {
    private static final String[] KNOWN_SYSTEM_TABLES = new String[]{"dtproperties"};
    private Pattern _isoDatePattern;
    private Pattern _isoTimePattern;

    public MSSqlModelReader(Platform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern("%");
        try {
            this._isoDatePattern = Pattern.compile("'(\\d{4}\\-\\d{2}\\-\\d{2})'");
            this._isoTimePattern = Pattern.compile("'(\\d{2}:\\d{2}:\\d{2})'");
        }
        catch (PatternSyntaxException ex) {
            throw new DdlUtilsException(ex);
        }
    }

    @Override
    protected Table readTable(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        String tableName = (String)values.get("TABLE_NAME");
        for (int idx = 0; idx < KNOWN_SYSTEM_TABLES.length; ++idx) {
            if (!KNOWN_SYSTEM_TABLES[idx].equals(tableName)) continue;
            return null;
        }
        Table table = super.readTable(metaData, values);
        if (table != null) {
            this.determineAutoIncrementFromResultSetMetaData(table, table.getColumns());
            int idx = 0;
            while (idx < table.getIndexCount()) {
                Index index = table.getIndex(idx);
                if (index.isUnique() && this.existsPKWithName(metaData, table, index.getName())) {
                    table.removeIndex(idx);
                    continue;
                }
                ++idx;
            }
        }
        return table;
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(DatabaseMetaDataWrapper metaData, Table table, Index index) {
        StringBuilder pkIndexName = new StringBuilder();
        pkIndexName.append("PK__");
        pkIndexName.append(table.getName());
        pkIndexName.append("__");
        return index.getName().toUpperCase().startsWith(pkIndexName.toString().toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsPKWithName(DatabaseMetaDataWrapper metaData, Table table, String name) throws SQLException {
        boolean bl;
        ResultSet pks = null;
        try {
            pks = metaData.getPrimaryKeys(metaData.escapeForSearch(table.getName()));
            pks = metaData.getPrimaryKeys(table.getName());
            while (pks.next()) {
                if (!name.equals(pks.getString("PK_NAME"))) continue;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(pks);
            throw throwable;
        }
        {
            this.closeResultSet(pks);
            return bl;
        }
        boolean bl2 = false;
        this.closeResultSet(pks);
        return bl2;
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null) {
            while (defaultValue.startsWith("(") && defaultValue.endsWith(")")) {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
            }
            if (column.getTypeCode() == 93) {
                Matcher matcher = this._isoDatePattern.matcher(defaultValue);
                Timestamp timestamp = null;
                if (matcher.matches()) {
                    timestamp = new Timestamp(Date.valueOf(matcher.group(1)).getTime());
                } else {
                    matcher = this._isoTimePattern.matcher(defaultValue);
                    if (matcher.matches()) {
                        timestamp = new Timestamp(Time.valueOf(matcher.group(1)).getTime());
                    }
                }
                if (timestamp != null) {
                    defaultValue = timestamp.toString();
                }
            } else if (column.getTypeCode() == 3) {
                if (column.getScale() == 0 && defaultValue.endsWith(".")) {
                    defaultValue = defaultValue.substring(0, defaultValue.length() - 1);
                }
            } else if (TypeMap.isTextType(column.getTypeCode())) {
                defaultValue = this.unescape(defaultValue, "'", "''");
            }
            column.setDefaultValue(defaultValue);
        }
        if (column.getTypeCode() == 3 && column.getSizeAsInt() == 19 && column.getScale() == 0) {
            column.setTypeCode(-5);
        }
        return column;
    }
}

