/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.mssql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddForeignKeyChange;
import org.apache.ddlutils.alteration.AddIndexChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.alteration.ModelComparator;
import org.apache.ddlutils.alteration.RemoveForeignKeyChange;
import org.apache.ddlutils.alteration.RemoveIndexChange;
import org.apache.ddlutils.alteration.RemovePrimaryKeyChange;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;

public class MSSqlModelComparator
extends ModelComparator {
    public MSSqlModelComparator(PlatformInfo platformInfo, TableDefinitionChangesPredicate tableDefChangePredicate, boolean caseSensitive) {
        super(platformInfo, tableDefChangePredicate, caseSensitive);
        this.setGeneratePrimaryKeyChanges(false);
        this.setCanDropPrimaryKeyColumns(false);
    }

    @Override
    protected List checkForPrimaryKeyChanges(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        List changes = super.checkForPrimaryKeyChanges(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable);
        if (changes.isEmpty()) {
            List columns = this.getRelevantChangedColumns(sourceTable, targetTable);
            for (Column targetColumn : columns) {
                if (!targetColumn.isPrimaryKey()) continue;
                changes.add(new RemovePrimaryKeyChange(sourceTable.getName()));
                changes.add(new AddPrimaryKeyChange(sourceTable.getName(), sourceTable.getPrimaryKeyColumnNames()));
                break;
            }
        }
        return changes;
    }

    @Override
    protected List checkForRemovedIndexes(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        List columns;
        List changes = super.checkForRemovedIndexes(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable);
        Index[] targetIndexes = targetTable.getIndices();
        ArrayList<RemoveIndexChange> additionalChanges = new ArrayList<RemoveIndexChange>();
        if (targetIndexes.length > 0 && !(columns = this.getRelevantChangedColumns(sourceTable, targetTable)).isEmpty()) {
            block0: for (int indexIdx = 0; indexIdx < targetIndexes.length; ++indexIdx) {
                Index sourceIndex = this.findCorrespondingIndex(sourceTable, targetIndexes[indexIdx]);
                if (sourceIndex == null) continue;
                for (Column targetColumn : columns) {
                    if (!targetIndexes[indexIdx].hasColumn(targetColumn)) continue;
                    additionalChanges.add(new RemoveIndexChange(intermediateTable.getName(), targetIndexes[indexIdx]));
                    continue block0;
                }
            }
            Iterator changeIt = additionalChanges.iterator();
            while (changeIt.hasNext()) {
                ((RemoveIndexChange)changeIt.next()).apply(intermediateModel, this.isCaseSensitive());
            }
            changes.addAll(additionalChanges);
        }
        return changes;
    }

    @Override
    protected List checkForAddedIndexes(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        List changes = super.checkForAddedIndexes(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable);
        Index[] targetIndexes = targetTable.getIndices();
        ArrayList<AddIndexChange> additionalChanges = new ArrayList<AddIndexChange>();
        if (targetIndexes.length > 0) {
            for (int indexIdx = 0; indexIdx < targetIndexes.length; ++indexIdx) {
                Index sourceIndex = this.findCorrespondingIndex(sourceTable, targetIndexes[indexIdx]);
                Index intermediateIndex = this.findCorrespondingIndex(intermediateTable, targetIndexes[indexIdx]);
                if (sourceIndex == null || intermediateIndex != null) continue;
                additionalChanges.add(new AddIndexChange(intermediateTable.getName(), targetIndexes[indexIdx]));
            }
            Iterator changeIt = additionalChanges.iterator();
            while (changeIt.hasNext()) {
                ((AddIndexChange)changeIt.next()).apply(intermediateModel, this.isCaseSensitive());
            }
            changes.addAll(additionalChanges);
        }
        return changes;
    }

    @Override
    protected List checkForRemovedForeignKeys(Database sourceModel, Database intermediateModel, Database targetModel) {
        List changes = super.checkForRemovedForeignKeys(sourceModel, intermediateModel, targetModel);
        ArrayList<RemoveForeignKeyChange> additionalChanges = new ArrayList<RemoveForeignKeyChange>();
        for (int tableIdx = 0; tableIdx < targetModel.getTableCount(); ++tableIdx) {
            List columns;
            Table targetTable = targetModel.getTable(tableIdx);
            Table sourceTable = sourceModel.findTable(targetTable.getName(), this.isCaseSensitive());
            if (sourceTable == null || (columns = this.getRelevantChangedColumns(sourceTable, targetTable)).isEmpty()) continue;
            block1: for (int fkIdx = 0; fkIdx < targetTable.getForeignKeyCount(); ++fkIdx) {
                ForeignKey targetFk = targetTable.getForeignKey(fkIdx);
                ForeignKey sourceFk = this.findCorrespondingForeignKey(sourceTable, targetFk);
                if (sourceFk == null) continue;
                for (Column targetColumn : columns) {
                    if (!targetFk.hasLocalColumn(targetColumn) && !targetFk.hasForeignColumn(targetColumn)) continue;
                    additionalChanges.add(new RemoveForeignKeyChange(sourceTable.getName(), targetFk));
                    continue block1;
                }
            }
        }
        Iterator changeIt = additionalChanges.iterator();
        while (changeIt.hasNext()) {
            ((RemoveForeignKeyChange)changeIt.next()).apply(intermediateModel, this.isCaseSensitive());
        }
        changes.addAll(additionalChanges);
        return changes;
    }

    @Override
    protected List checkForAddedForeignKeys(Database sourceModel, Database intermediateModel, Database targetModel) {
        List changes = super.checkForAddedForeignKeys(sourceModel, intermediateModel, targetModel);
        ArrayList<AddForeignKeyChange> additionalChanges = new ArrayList<AddForeignKeyChange>();
        for (int tableIdx = 0; tableIdx < targetModel.getTableCount(); ++tableIdx) {
            Table targetTable = targetModel.getTable(tableIdx);
            Table sourceTable = sourceModel.findTable(targetTable.getName(), this.isCaseSensitive());
            Table intermediateTable = intermediateModel.findTable(targetTable.getName(), this.isCaseSensitive());
            if (sourceTable == null) continue;
            for (int fkIdx = 0; fkIdx < targetTable.getForeignKeyCount(); ++fkIdx) {
                ForeignKey targetFk = targetTable.getForeignKey(fkIdx);
                ForeignKey sourceFk = this.findCorrespondingForeignKey(sourceTable, targetFk);
                ForeignKey intermediateFk = this.findCorrespondingForeignKey(intermediateTable, targetFk);
                if (sourceFk == null || intermediateFk != null) continue;
                additionalChanges.add(new AddForeignKeyChange(intermediateTable.getName(), targetFk));
            }
        }
        Iterator changeIt = additionalChanges.iterator();
        while (changeIt.hasNext()) {
            ((AddForeignKeyChange)changeIt.next()).apply(intermediateModel, this.isCaseSensitive());
        }
        changes.addAll(additionalChanges);
        return changes;
    }

    private List getRelevantChangedColumns(Table sourceTable, Table targetTable) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (int columnIdx = 0; columnIdx < targetTable.getColumnCount(); ++columnIdx) {
            int targetTypeCode;
            Column targetColumn = targetTable.getColumn(columnIdx);
            Column sourceColumn = sourceTable.findColumn(targetColumn.getName(), this.isCaseSensitive());
            if (sourceColumn == null || (targetTypeCode = this.getPlatformInfo().getTargetJdbcType(targetColumn.getTypeCode())) == sourceColumn.getTypeCode() && !ColumnDefinitionChange.isSizeChanged(this.getPlatformInfo(), sourceColumn, targetColumn)) continue;
            result.add(targetColumn);
        }
        return result;
    }
}

