/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.mssql;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.SqlBuilder;

public class MSSqlBuilder
extends SqlBuilder {
    private DateFormat _genericDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat _genericTimeFormat = new SimpleDateFormat("HH:mm:ss");

    public MSSqlBuilder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    @Override
    public void createTable(Database database, Table table, Map parameters) throws IOException {
        this.turnOnQuotation();
        super.createTable(database, table, parameters);
    }

    @Override
    public void dropTable(Table table) throws IOException {
        String tableName = this.getTableName(table);
        String tableNameVar = "tn" + this.createUniqueIdentifier();
        String constraintNameVar = "cn" + this.createUniqueIdentifier();
        this.turnOnQuotation();
        this.print("IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = ");
        this.printAlwaysSingleQuotedIdentifier(tableName);
        this.println(")");
        this.println("BEGIN");
        this.println("  DECLARE @" + tableNameVar + " nvarchar(256), @" + constraintNameVar + " nvarchar(256)");
        this.println("  DECLARE refcursor CURSOR FOR");
        this.println("  SELECT object_name(objs.parent_obj) tablename, objs.name constraintname");
        this.println("    FROM sysobjects objs JOIN sysconstraints cons ON objs.id = cons.constid");
        this.print("    WHERE objs.xtype != 'PK' AND object_name(objs.parent_obj) = ");
        this.printAlwaysSingleQuotedIdentifier(tableName);
        this.println("  OPEN refcursor");
        this.println("  FETCH NEXT FROM refcursor INTO @" + tableNameVar + ", @" + constraintNameVar);
        this.println("  WHILE @@FETCH_STATUS = 0");
        this.println("    BEGIN");
        this.println("      EXEC ('ALTER TABLE '+@" + tableNameVar + "+' DROP CONSTRAINT '+@" + constraintNameVar + ")");
        this.println("      FETCH NEXT FROM refcursor INTO @" + tableNameVar + ", @" + constraintNameVar);
        this.println("    END");
        this.println("  CLOSE refcursor");
        this.println("  DEALLOCATE refcursor");
        this.print("  DROP TABLE ");
        this.printlnIdentifier(tableName);
        this.print("END");
        this.printEndOfStatement();
    }

    @Override
    public void dropForeignKeys(Table table) throws IOException {
        this.turnOnQuotation();
        super.dropForeignKeys(table);
    }

    @Override
    protected DateFormat getValueDateFormat() {
        return this._genericDateFormat;
    }

    @Override
    protected DateFormat getValueTimeFormat() {
        return this._genericTimeFormat;
    }

    @Override
    protected String getValueAsString(Column column, Object value) {
        if (value == null) {
            return "NULL";
        }
        StringBuilder result = new StringBuilder();
        switch (column.getTypeCode()) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                if (!(value instanceof String) && this.getValueNumberFormat() != null) {
                    result.append(this.getValueNumberFormat().format(value));
                    break;
                }
                result.append(value.toString());
                break;
            }
            case 91: {
                result.append("CAST(");
                result.append(this.getPlatformInfo().getValueQuoteToken());
                result.append(value instanceof String ? (String)value : this.getValueDateFormat().format(value));
                result.append(this.getPlatformInfo().getValueQuoteToken());
                result.append(" AS datetime)");
                break;
            }
            case 92: {
                result.append("CAST(");
                result.append(this.getPlatformInfo().getValueQuoteToken());
                result.append(value instanceof String ? (String)value : this.getValueTimeFormat().format(value));
                result.append(this.getPlatformInfo().getValueQuoteToken());
                result.append(" AS datetime)");
                break;
            }
            case 93: {
                result.append("CAST(");
                result.append(this.getPlatformInfo().getValueQuoteToken());
                result.append(value.toString());
                result.append(this.getPlatformInfo().getValueQuoteToken());
                result.append(" AS datetime)");
            }
        }
        return super.getValueAsString(column, value);
    }

    @Override
    protected String getNativeDefaultValue(Column column) {
        if (column.getTypeCode() == -7 || column.getTypeCode() == 16) {
            return this.getDefaultValueHelper().convert(column.getDefaultValue(), column.getTypeCode(), 5);
        }
        return super.getNativeDefaultValue(column);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("IDENTITY (1,1) ");
    }

    @Override
    public void dropIndex(Table table, Index index) throws IOException {
        this.print("DROP INDEX ");
        this.printIdentifier(this.getTableName(table));
        this.print(".");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }

    @Override
    public void dropForeignKey(Table table, ForeignKey foreignKey) throws IOException {
        String constraintName = this.getForeignKeyName(table, foreignKey);
        this.print("IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'F' AND name = ");
        this.printAlwaysSingleQuotedIdentifier(constraintName);
        this.println(")");
        this.printIndent();
        this.print("ALTER TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" DROP CONSTRAINT ");
        this.printIdentifier(constraintName);
        this.printEndOfStatement();
    }

    private String getQuotationOnStatement() {
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            return "SET quoted_identifier on" + this.getPlatformInfo().getSqlCommandDelimiter() + "\n";
        }
        return "";
    }

    protected void turnOnQuotation() throws IOException {
        this.print(this.getQuotationOnStatement());
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        return "SELECT @@IDENTITY";
    }

    protected String getEnableIdentityOverrideSql(Table table) {
        StringBuilder result = new StringBuilder();
        result.append(this.getQuotationOnStatement());
        result.append("SET IDENTITY_INSERT ");
        result.append(this.getDelimitedIdentifier(this.getTableName(table)));
        result.append(" ON");
        result.append(this.getPlatformInfo().getSqlCommandDelimiter());
        return result.toString();
    }

    protected String getDisableIdentityOverrideSql(Table table) {
        StringBuilder result = new StringBuilder();
        result.append(this.getQuotationOnStatement());
        result.append("SET IDENTITY_INSERT ");
        result.append(this.getDelimitedIdentifier(this.getTableName(table)));
        result.append(" OFF");
        result.append(this.getPlatformInfo().getSqlCommandDelimiter());
        return result.toString();
    }

    @Override
    public String getDeleteSql(Table table, Map pkValues, boolean genPlaceholders) {
        return this.getQuotationOnStatement() + super.getDeleteSql(table, pkValues, genPlaceholders);
    }

    @Override
    public String getInsertSql(Table table, Map columnValues, boolean genPlaceholders) {
        return this.getQuotationOnStatement() + super.getInsertSql(table, columnValues, genPlaceholders);
    }

    @Override
    public String getUpdateSql(Table table, Map columnValues, boolean genPlaceholders) {
        return this.getQuotationOnStatement() + super.getUpdateSql(table, columnValues, genPlaceholders);
    }

    private void printAlwaysSingleQuotedIdentifier(String identifier) throws IOException {
        this.print("'");
        this.print(identifier);
        this.print("'");
    }

    @Override
    protected void copyData(Table sourceTable, Table targetTable) throws IOException {
        boolean needToAllowIdentityInsert;
        Column[] targetIdentityColumns = targetTable.getAutoIncrementColumns();
        boolean bl = needToAllowIdentityInsert = targetIdentityColumns.length > 0 && sourceTable.findColumn(targetIdentityColumns[0].getName(), this.getPlatform().isDelimitedIdentifierModeOn()) != null;
        if (needToAllowIdentityInsert) {
            this.print("SET IDENTITY_INSERT ");
            this.printIdentifier(this.getTableName(targetTable));
            this.print(" ON");
            this.printEndOfStatement();
        }
        super.copyData(sourceTable, targetTable);
        if (needToAllowIdentityInsert) {
            this.print("SET IDENTITY_INSERT ");
            this.printIdentifier(this.getTableName(targetTable));
            this.print(" OFF");
            this.printEndOfStatement();
        }
    }

    @Override
    public void addColumn(Database model, Table table, Column newColumn) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("ADD ");
        this.writeColumn(table, newColumn);
        this.printEndOfStatement();
    }

    public void dropColumn(Table table, Column column) throws IOException {
        if (!StringUtils.isEmpty((String)column.getDefaultValue())) {
            this.writeDropConstraintStatement(table, column, "D");
        }
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(column));
        this.printEndOfStatement();
    }

    public void dropPrimaryKey(Table table) throws IOException {
        this.writeDropConstraintStatement(table, null, "PK");
    }

    public void recreateColumn(Table table, Column curColumn, Column newColumn) throws IOException {
        boolean hasDefault = curColumn.getParsedDefaultValue() != null;
        boolean shallHaveDefault = newColumn.getParsedDefaultValue() != null;
        String newDefault = newColumn.getDefaultValue();
        if (newDefault != null) {
            newColumn.setDefaultValue(null);
        }
        if (hasDefault) {
            this.writeDropConstraintStatement(table, curColumn, "D");
        }
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("ALTER COLUMN ");
        this.writeColumn(table, newColumn);
        this.printEndOfStatement();
        if (shallHaveDefault) {
            newColumn.setDefaultValue(newDefault);
            this.print("ALTER TABLE ");
            this.printlnIdentifier(this.getTableName(table));
            this.printIndent();
            this.print("ADD CONSTRAINT ");
            this.printIdentifier(this.getConstraintName("DF", table, curColumn.getName(), null));
            this.writeColumnDefaultValueStmt(table, newColumn);
            this.print(" FOR ");
            this.printIdentifier(this.getColumnName(curColumn));
            this.printEndOfStatement();
        }
    }

    protected void writeDropConstraintStatement(Table table, Column column, String typeIdentifier) throws IOException {
        String tableName = this.getTableName(table);
        String columnName = column == null ? null : this.getColumnName(column);
        String tableNameVar = "tn" + this.createUniqueIdentifier();
        String constraintNameVar = "cn" + this.createUniqueIdentifier();
        this.println("BEGIN");
        this.println("  DECLARE @" + tableNameVar + " nvarchar(256), @" + constraintNameVar + " nvarchar(256)");
        this.println("  DECLARE refcursor CURSOR FOR");
        this.println("  SELECT object_name(objs.parent_obj) tablename, objs.name constraintname");
        this.println("    FROM sysobjects objs JOIN sysconstraints cons ON objs.id = cons.constid");
        this.print("    WHERE objs.xtype = '");
        this.print(typeIdentifier);
        this.println("' AND");
        if (columnName != null) {
            this.print("          cons.colid = (SELECT colid FROM syscolumns WHERE id = object_id(");
            this.printAlwaysSingleQuotedIdentifier(tableName);
            this.print(") AND name = ");
            this.printAlwaysSingleQuotedIdentifier(columnName);
            this.println(") AND");
        }
        this.print("          object_name(objs.parent_obj) = ");
        this.printAlwaysSingleQuotedIdentifier(tableName);
        this.println("  OPEN refcursor");
        this.println("  FETCH NEXT FROM refcursor INTO @" + tableNameVar + ", @" + constraintNameVar);
        this.println("  WHILE @@FETCH_STATUS = 0");
        this.println("    BEGIN");
        this.println("      EXEC ('ALTER TABLE '+@" + tableNameVar + "+' DROP CONSTRAINT '+@" + constraintNameVar + ")");
        this.println("      FETCH NEXT FROM refcursor INTO @" + tableNameVar + ", @" + constraintNameVar);
        this.println("    END");
        this.println("  CLOSE refcursor");
        this.println("  DEALLOCATE refcursor");
        this.print("END");
        this.printEndOfStatement();
    }

    @Override
    protected void writeCastExpression(Column sourceColumn, Column targetColumn) throws IOException {
        boolean sizeChanged = ColumnDefinitionChange.isSizeChanged(this.getPlatformInfo(), sourceColumn, targetColumn);
        boolean typeChanged = ColumnDefinitionChange.isTypeChanged(this.getPlatformInfo(), sourceColumn, targetColumn);
        if (sizeChanged || typeChanged) {
            if (TypeMap.isTextType(targetColumn.getTypeCode()) && sizeChanged && targetColumn.getSize() != null && sourceColumn.getSizeAsInt() > targetColumn.getSizeAsInt()) {
                this.print("SUBSTRING(CAST(");
                this.printIdentifier(this.getColumnName(sourceColumn));
                this.print(" AS ");
                this.print(this.getNativeType(targetColumn));
                this.print("),1,");
                this.print(this.getSizeSpec(targetColumn));
                this.print(")");
            } else {
                this.print("CAST(");
                this.printIdentifier(this.getColumnName(sourceColumn));
                this.print(" AS ");
                this.print(this.getSqlType(targetColumn));
                this.print(")");
            }
        } else {
            this.printIdentifier(this.getColumnName(sourceColumn));
        }
    }
}

