/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.mckoi;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.ddlutils.DatabaseOperationException;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.alteration.RecreateTableChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.DefaultTableDefinitionChangesPredicate;
import org.apache.ddlutils.platform.PlatformImplBase;
import org.apache.ddlutils.platform.mckoi.MckoiBuilder;
import org.apache.ddlutils.platform.mckoi.MckoiModelReader;

public class MckoiPlatform
extends PlatformImplBase {
    public static final String DATABASENAME = "McKoi";
    public static final String JDBC_DRIVER = "com.mckoi.JDBCDriver";
    public static final String JDBC_SUBPROTOCOL = "mckoi";

    public MckoiPlatform() {
        PlatformInfo info = this.getPlatformInfo();
        info.setIndicesSupported(false);
        info.setIndicesEmbedded(true);
        info.setDefaultValueUsedForIdentitySpec(true);
        info.setAutoCommitModeForLastIdentityValueReading(false);
        info.addNativeTypeMapping(2003, "BLOB", 2004);
        info.addNativeTypeMapping(-7, "BOOLEAN", 16);
        info.addNativeTypeMapping(70, "BLOB", 2004);
        info.addNativeTypeMapping(2001, "BLOB", 2004);
        info.addNativeTypeMapping(6, "DOUBLE", 8);
        info.addNativeTypeMapping(0, "BLOB", 2004);
        info.addNativeTypeMapping(1111, "BLOB", 2004);
        info.addNativeTypeMapping(2006, "BLOB", 2004);
        info.addNativeTypeMapping(2002, "BLOB", 2004);
        info.setDefaultSize(1, 1024);
        info.setDefaultSize(12, 1024);
        info.setDefaultSize(-2, 1024);
        info.setDefaultSize(-3, 1024);
        this.setSqlBuilder(new MckoiBuilder(this));
        this.setModelReader(new MckoiModelReader(this));
    }

    @Override
    public String getName() {
        return DATABASENAME;
    }

    @Override
    public void createDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password, Map parameters) throws DatabaseOperationException, UnsupportedOperationException {
        if (JDBC_DRIVER.equals(jdbcDriverClassName)) {
            StringBuilder creationUrl = new StringBuilder();
            Connection connection = null;
            creationUrl.append(connectionUrl);
            creationUrl.append("?create=true");
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry entry : parameters.entrySet()) {
                    if ("create".equalsIgnoreCase(entry.getKey().toString())) continue;
                    creationUrl.append("&");
                    creationUrl.append(entry.getKey().toString());
                    creationUrl.append("=");
                    if (entry.getValue() == null) continue;
                    creationUrl.append(entry.getValue().toString());
                }
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("About to create database using this URL: " + creationUrl.toString()));
            }
            try {
                Class.forName(jdbcDriverClassName);
                connection = DriverManager.getConnection(creationUrl.toString(), username, password);
                this.logWarnings(connection);
            }
            catch (Exception ex) {
                throw new DatabaseOperationException("Error while trying to create a database", ex);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        throw new UnsupportedOperationException("Unable to create a McKoi database via the driver " + jdbcDriverClassName);
    }

    @Override
    protected TableDefinitionChangesPredicate getTableDefinitionChangesPredicate() {
        return new DefaultTableDefinitionChangesPredicate(){

            @Override
            public boolean areSupported(Table intermediateTable, List changes) {
                return false;
            }
        };
    }

    @Override
    public void processChange(Database currentModel, CreationParameters params, RecreateTableChange change) throws IOException {
        MckoiBuilder sqlBuilder = (MckoiBuilder)this.getSqlBuilder();
        Table changedTable = this.findChangedTable(currentModel, change);
        for (TableChange tableChange : change.getOriginalChanges()) {
            AddColumnChange addColumnChange;
            if (tableChange instanceof ColumnDefinitionChange) {
                ColumnDefinitionChange colChange = (ColumnDefinitionChange)tableChange;
                Column origColumn = changedTable.findColumn(colChange.getChangedColumn(), this.isDelimitedIdentifierModeOn());
                Column newColumn = colChange.getNewColumn();
                if (origColumn.isAutoIncrement() || !newColumn.isAutoIncrement()) continue;
                sqlBuilder.createAutoIncrementSequence(changedTable, origColumn);
                continue;
            }
            if (!(tableChange instanceof AddColumnChange) || !(addColumnChange = (AddColumnChange)tableChange).getNewColumn().isAutoIncrement()) continue;
            sqlBuilder.createAutoIncrementSequence(changedTable, addColumnChange.getNewColumn());
        }
        Map parameters = params == null ? null : params.getParametersFor(changedTable);
        sqlBuilder.writeRecreateTableStmt(currentModel, change.getTargetTable(), parameters);
        for (TableChange tableChange : change.getOriginalChanges()) {
            RemoveColumnChange removeColumnChange;
            Column removedColumn;
            if (tableChange instanceof ColumnDefinitionChange) {
                ColumnDefinitionChange colChange = (ColumnDefinitionChange)tableChange;
                Column origColumn = changedTable.findColumn(colChange.getChangedColumn(), this.isDelimitedIdentifierModeOn());
                Column newColumn = colChange.getNewColumn();
                if (!origColumn.isAutoIncrement() || newColumn.isAutoIncrement()) continue;
                sqlBuilder.dropAutoIncrementSequence(changedTable, origColumn);
                continue;
            }
            if (!(tableChange instanceof RemoveColumnChange) || !(removedColumn = changedTable.findColumn((removeColumnChange = (RemoveColumnChange)tableChange).getChangedColumn(), this.isDelimitedIdentifierModeOn())).isAutoIncrement()) continue;
            sqlBuilder.dropAutoIncrementSequence(changedTable, removedColumn);
        }
    }
}

