/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.mckoi;

import java.io.IOException;
import java.util.Map;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.SqlBuilder;

public class MckoiBuilder
extends SqlBuilder {
    public MckoiBuilder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("\\", "\\\\");
        this.addEscapedCharSequence("'", "\\'");
    }

    @Override
    public void createTable(Database database, Table table, Map parameters) throws IOException {
        Column[] columns = table.getAutoIncrementColumns();
        for (int idx = 0; idx < columns.length; ++idx) {
            this.createAutoIncrementSequence(table, columns[idx]);
        }
        super.createTable(database, table, parameters);
    }

    @Override
    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE IF EXISTS ");
        this.printIdentifier(this.getTableName(table));
        this.printEndOfStatement();
        Column[] columns = table.getAutoIncrementColumns();
        for (int idx = 0; idx < columns.length; ++idx) {
            this.dropAutoIncrementSequence(table, columns[idx]);
        }
    }

    protected void createAutoIncrementSequence(Table table, Column column) throws IOException {
        this.print("CREATE SEQUENCE ");
        this.printIdentifier(this.getConstraintName("seq", table, column.getName(), null));
        this.printEndOfStatement();
    }

    protected void dropAutoIncrementSequence(Table table, Column column) throws IOException {
        this.print("DROP SEQUENCE ");
        this.printIdentifier(this.getConstraintName("seq", table, column.getName(), null));
        this.printEndOfStatement();
    }

    @Override
    protected void writeColumnDefaultValue(Table table, Column column) throws IOException {
        if (column.isAutoIncrement()) {
            this.print("NEXTVAL('");
            this.print(this.getConstraintName("seq", table, column.getName(), null));
            this.print("')");
        } else {
            super.writeColumnDefaultValue(table, column);
        }
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        Column[] columns = table.getAutoIncrementColumns();
        if (columns.length > 0) {
            StringBuilder result = new StringBuilder();
            result.append("SELECT ");
            for (int idx = 0; idx < columns.length; ++idx) {
                if (idx > 0) {
                    result.append(",");
                }
                result.append("CURRVAL('");
                result.append(this.getConstraintName("seq", table, columns[idx].getName(), null));
                result.append("')");
            }
            return result.toString();
        }
        return null;
    }

    protected void writeRecreateTableStmt(Database model, Table table, Map parameters) throws IOException {
        this.print("ALTER ");
        super.createTable(model, table, parameters);
    }
}

