/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.interbase;

import java.io.IOException;
import java.util.Map;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.SqlBuilder;

public class InterbaseBuilder
extends SqlBuilder {
    public InterbaseBuilder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    @Override
    public void createTable(Database database, Table table, Map parameters) throws IOException {
        super.createTable(database, table, parameters);
        Column[] columns = table.getAutoIncrementColumns();
        for (int idx = 0; idx < columns.length; ++idx) {
            this.writeAutoIncrementCreateStmts(database, table, columns[idx]);
        }
    }

    @Override
    protected String getNativeDefaultValue(Column column) {
        if (column.getTypeCode() == -7 || column.getTypeCode() == 16) {
            return this.getDefaultValueHelper().convert(column.getDefaultValue(), column.getTypeCode(), 5);
        }
        return super.getNativeDefaultValue(column);
    }

    @Override
    public void dropTable(Table table) throws IOException {
        Column[] columns = table.getAutoIncrementColumns();
        for (int idx = 0; idx < columns.length; ++idx) {
            this.writeAutoIncrementDropStmts(table, columns[idx]);
        }
        super.dropTable(table);
    }

    @Override
    public void dropIndex(Table table, Index index) throws IOException {
        this.print("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }

    private void writeAutoIncrementCreateStmts(Database database, Table table, Column column) throws IOException {
        this.print("CREATE GENERATOR ");
        this.printIdentifier(this.getGeneratorName(table, column));
        this.printEndOfStatement();
        this.print("CREATE TRIGGER ");
        this.printIdentifier(this.getTriggerName(table, column));
        this.print(" FOR ");
        this.printlnIdentifier(this.getTableName(table));
        this.println("ACTIVE BEFORE INSERT POSITION 0 AS");
        this.print("BEGIN IF (NEW.");
        this.printIdentifier(this.getColumnName(column));
        this.print(" IS NULL) THEN NEW.");
        this.printIdentifier(this.getColumnName(column));
        this.print(" = GEN_ID(");
        this.printIdentifier(this.getGeneratorName(table, column));
        this.print(", 1); END");
        this.printEndOfStatement();
    }

    private void writeAutoIncrementDropStmts(Table table, Column column) throws IOException {
        this.print("DROP TRIGGER ");
        this.printIdentifier(this.getTriggerName(table, column));
        this.printEndOfStatement();
        this.print("DROP GENERATOR ");
        this.printIdentifier(this.getGeneratorName(table, column));
        this.printEndOfStatement();
    }

    protected String getTriggerName(Table table, Column column) {
        return this.getConstraintName("trg", table, column.getName(), null);
    }

    protected String getGeneratorName(Table table, Column column) {
        return this.getConstraintName("gen", table, column.getName(), null);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        Column[] columns = table.getAutoIncrementColumns();
        if (columns.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append("SELECT ");
        for (int idx = 0; idx < columns.length; ++idx) {
            result.append("GEN_ID(");
            result.append(this.getDelimitedIdentifier(this.getGeneratorName(table, columns[idx])));
            result.append(", 0)");
        }
        result.append(" FROM RDB$DATABASE");
        return result.toString();
    }

    public void insertColumn(Database model, Table table, Column newColumn, Column prevColumn) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("ADD ");
        this.writeColumn(table, newColumn);
        this.printEndOfStatement();
        if (prevColumn != null) {
            this.print("ALTER TABLE ");
            this.printlnIdentifier(this.getTableName(table));
            this.printIndent();
            this.print("ALTER ");
            this.printIdentifier(this.getColumnName(newColumn));
            this.print(" POSITION ");
            this.print(String.valueOf(table.getColumnIndex(prevColumn) + 2));
            this.printEndOfStatement();
        }
        if (newColumn.isAutoIncrement()) {
            this.writeAutoIncrementCreateStmts(model, table, newColumn);
        }
    }

    public void dropColumn(Table table, Column column) throws IOException {
        if (column.isAutoIncrement()) {
            this.writeAutoIncrementDropStmts(table, column);
        }
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP ");
        this.printIdentifier(this.getColumnName(column));
        this.printEndOfStatement();
    }
}

