/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.hsqldb;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.DefaultTableDefinitionChangesPredicate;
import org.apache.ddlutils.platform.PlatformImplBase;
import org.apache.ddlutils.platform.hsqldb.HsqlDbBuilder;
import org.apache.ddlutils.platform.hsqldb.HsqlDbModelReader;

public class HsqlDbPlatform
extends PlatformImplBase {
    public static final String DATABASENAME = "HsqlDb";
    public static final String JDBC_DRIVER = "org.hsqldb.jdbcDriver";
    public static final String JDBC_SUBPROTOCOL = "hsqldb";

    public HsqlDbPlatform() {
        PlatformInfo info = this.getPlatformInfo();
        info.setDefaultValueUsedForIdentitySpec(true);
        info.setNonPrimaryKeyIdentityColumnsSupported(false);
        info.setIdentityOverrideAllowed(false);
        info.setSystemForeignKeyIndicesAlwaysNonUnique(true);
        info.setPrimaryKeyColumnAutomaticallyRequired(true);
        info.setMixingIdentityAndNormalPrimaryKeyColumnsSupported(false);
        info.addNativeTypeMapping(2003, "LONGVARBINARY", -4);
        info.addNativeTypeMapping(-7, "BOOLEAN", 16);
        info.addNativeTypeMapping(2004, "LONGVARBINARY", -4);
        info.addNativeTypeMapping(2005, "LONGVARCHAR", -1);
        info.addNativeTypeMapping(70, "LONGVARBINARY", -4);
        info.addNativeTypeMapping(2001, "LONGVARBINARY", -4);
        info.addNativeTypeMapping(6, "DOUBLE", 8);
        info.addNativeTypeMapping(2000, "OBJECT");
        info.addNativeTypeMapping(0, "LONGVARBINARY", -4);
        info.addNativeTypeMapping(2006, "LONGVARBINARY", -4);
        info.addNativeTypeMapping(2002, "LONGVARBINARY", -4);
        info.addNativeTypeMapping(-6, "SMALLINT", 5);
        info.setDefaultSize(1, Integer.MAX_VALUE);
        info.setDefaultSize(12, Integer.MAX_VALUE);
        info.setDefaultSize(-2, Integer.MAX_VALUE);
        info.setDefaultSize(-3, Integer.MAX_VALUE);
        this.setSqlBuilder(new HsqlDbBuilder(this));
        this.setModelReader(new HsqlDbModelReader(this));
    }

    @Override
    public String getName() {
        return DATABASENAME;
    }

    @Override
    public void shutdownDatabase(Connection connection) {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate("SHUTDOWN");
        }
        catch (SQLException ex) {
            throw new DdlUtilsException(ex);
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    @Override
    protected TableDefinitionChangesPredicate getTableDefinitionChangesPredicate() {
        return new DefaultTableDefinitionChangesPredicate(){

            @Override
            protected boolean isSupported(Table intermediateTable, TableChange change) {
                if (change instanceof RemoveColumnChange) {
                    Column column = intermediateTable.findColumn(((RemoveColumnChange)change).getChangedColumn(), HsqlDbPlatform.this.isDelimitedIdentifierModeOn());
                    return !column.isPrimaryKey();
                }
                if (change instanceof AddColumnChange) {
                    AddColumnChange addColumnChange = (AddColumnChange)change;
                    return addColumnChange.isAtEnd() && (!addColumnChange.getNewColumn().isRequired() || addColumnChange.getNewColumn().getDefaultValue() != null);
                }
                return change instanceof AddPrimaryKeyChange;
            }
        };
    }

    @Override
    public void processChange(Database currentModel, CreationParameters params, AddColumnChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column nextColumn = null;
        if (change.getNextColumn() != null) {
            nextColumn = changedTable.findColumn(change.getNextColumn(), this.isDelimitedIdentifierModeOn());
        }
        ((HsqlDbBuilder)this.getSqlBuilder()).insertColumn(changedTable, change.getNewColumn(), nextColumn);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, RemoveColumnChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column removedColumn = changedTable.findColumn(change.getChangedColumn(), this.isDelimitedIdentifierModeOn());
        ((HsqlDbBuilder)this.getSqlBuilder()).dropColumn(changedTable, removedColumn);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }
}

