/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.gemfirexd;

import java.io.IOException;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ddlutils.DatabaseOperationException;
import org.apache.ddlutils.platform.SqlBuilder;
import org.apache.ddlutils.platform.derby.DerbyPlatform;
import org.apache.ddlutils.platform.gemfirexd.GemFireXDBuilder;
import org.apache.ddlutils.platform.gemfirexd.GemFireXDModelReader;

public class GemFireXDPlatform
extends DerbyPlatform {
    public static final String DATABASENAME = "GemFireXD";
    public static final String JDBC_CLIENT_DRIVER = "com.pivotal.gemfirexd.jdbc.ClientDriver";
    public static final String JDBC_SUBPROTOCOL = "gemfirexd";

    public GemFireXDPlatform() {
        this.getPlatformInfo().setIdentityOverrideAllowed(false);
        this.getPlatformInfo().setIdentityValueReadableUsingStatement(true);
        this.getPlatformInfo().setSupportsAddIdentityUsingAlterTable(true);
        this.getPlatformInfo().setDDLExportSupported(true);
        this.setSqlBuilder(new GemFireXDBuilder(this));
        this.setModelReader(new GemFireXDModelReader(this));
    }

    @Override
    public String getName() {
        return DATABASENAME;
    }

    protected String getDriver() {
        return JDBC_CLIENT_DRIVER;
    }

    @Override
    public void createDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password, Map parameters) throws DatabaseOperationException, UnsupportedOperationException {
        if (this.getDriver().equals(jdbcDriverClassName)) {
            StringBuilder creationUrl = new StringBuilder();
            Connection connection = null;
            creationUrl.append(connectionUrl);
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry entry : parameters.entrySet()) {
                    if ("create".equalsIgnoreCase(entry.getKey().toString())) continue;
                    creationUrl.append(";");
                    creationUrl.append(entry.getKey().toString());
                    creationUrl.append("=");
                    if (entry.getValue() == null) continue;
                    creationUrl.append(entry.getValue().toString());
                }
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("About to create database using this URL: " + creationUrl.toString()));
            }
            try {
                Class.forName(jdbcDriverClassName);
                connection = DriverManager.getConnection(creationUrl.toString(), username, password);
                this.logWarnings(connection);
            }
            catch (Exception ex) {
                throw new DatabaseOperationException("Error while trying to create a database", ex);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        throw new UnsupportedOperationException("Unable to create a GemFireXD database via the driver " + jdbcDriverClassName);
    }

    @Override
    protected void writeAllDDLs(Connection conn, Writer writer, boolean exportAll) throws SQLException, IOException {
        CallableStatement cstmt = conn.prepareCall("call SYS.EXPORT_DDLS(?)");
        cstmt.setBoolean(1, exportAll);
        ResultSet rs = cstmt.executeQuery();
        while (rs.next()) {
            writer.write(rs.getString(3));
            writer.write(59);
            writer.write(SqlBuilder.LINE_SEPARATOR);
            writer.write(SqlBuilder.LINE_SEPARATOR);
        }
        rs.close();
        writer.flush();
    }
}

