/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.gemfirexd;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.ModelException;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.derby.DerbyBuilder;

public final class GemFireXDBuilder
extends DerbyBuilder {
    private final Map<Integer, ColumnSizeSpec> _maxSizes = new HashMap<Integer, ColumnSizeSpec>();

    public GemFireXDBuilder(Platform platform) {
        super(platform);
        this._maxSizes.put(12, new ColumnSizeSpec(32672, "CLOB"));
        this._maxSizes.put(-1, new ColumnSizeSpec(32700, "CLOB"));
        this._maxSizes.put(-3, new ColumnSizeSpec(32672, "BLOB"));
        this._maxSizes.put(-4, new ColumnSizeSpec(32700, "BLOB"));
    }

    @Override
    protected String getNativeType(Column column) {
        String nativeType;
        ColumnSizeSpec sizeSpec;
        int columnSize = column.getSizeAsInt();
        int columnType = column.getTypeCode();
        if (columnSize > 0 && (sizeSpec = this._maxSizes.get(columnType)) != null && columnSize >= sizeSpec._size) {
            return sizeSpec._higherType;
        }
        if (column.isAutoIncrement()) {
            switch (column.getTypeCode()) {
                case -6: 
                case 5: {
                    return "INTEGER";
                }
            }
        }
        return (nativeType = this.getPlatformInfo().getNativeType(columnType)) != null ? nativeType : column.getType();
    }

    protected String getIndexName(Table table, Index index) {
        String tablePrefix = table.getName() + '_';
        String indexName = index.getName().startsWith(tablePrefix) ? index.getName() : tablePrefix + index.getName();
        return this.shortenName(indexName, this.getMaxConstraintNameLength());
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("GENERATED ALWAYS AS IDENTITY");
    }

    @Override
    public void createIndex(Table table, Index index) throws IOException {
        if (this.getPlatformInfo().isIndicesSupported()) {
            if (index.getName() == null) {
                this._log.warn((Object)("Cannot write unnamed index " + index));
            } else {
                this.print("CREATE");
                if (index.isUnique()) {
                    this.print(" UNIQUE");
                }
                this.print(" INDEX ");
                this.printIdentifier(this.getIndexName(table, index));
                this.print(" ON ");
                this.printIdentifier(this.getTableName(table));
                this.print(" (");
                for (int idx = 0; idx < index.getColumnCount(); ++idx) {
                    IndexColumn idxColumn = index.getColumn(idx);
                    Column col = table.findColumn(idxColumn.getName());
                    if (col == null) {
                        throw new ModelException("Invalid column '" + idxColumn.getName() + "' on index " + index.getName() + " for table " + table.getQualifiedName());
                    }
                    if (idx > 0) {
                        this.print(", ");
                    }
                    this.printIdentifier(this.getColumnName(col));
                }
                this.print(")");
                this.printEndOfStatement();
            }
        } else {
            throw new DdlUtilsException("This platform does not support indexes");
        }
    }

    @Override
    protected void writeEmbeddedIndexCreateStmt(Table table, Index index) throws IOException {
        if (index.getName() != null && index.getName().length() > 0) {
            this.print(" CONSTRAINT ");
            this.printIdentifier(this.getIndexName(table, index));
        }
        if (index.isUnique()) {
            this.print(" UNIQUE");
        } else {
            this.print(" INDEX ");
        }
        this.print(" (");
        for (int idx = 0; idx < index.getColumnCount(); ++idx) {
            IndexColumn idxColumn = index.getColumn(idx);
            Column col = table.findColumn(idxColumn.getName());
            if (col == null) {
                throw new ModelException("Invalid column '" + idxColumn.getName() + "' on index " + index.getName() + " for table " + table.getQualifiedName());
            }
            if (idx > 0) {
                this.print(", ");
            }
            this.printIdentifier(this.getColumnName(col));
        }
        this.print(")");
    }

    @Override
    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE IF EXISTS ");
        this.printIdentifier(this.getTableName(table));
        this.printEndOfStatement();
    }

    @Override
    public void dropIndex(Table table, Index index) throws IOException {
        this.print("DROP INDEX ");
        this.printIdentifier(this.getIndexName(table, index));
        this.printEndOfStatement();
    }

    @Override
    public void writeAddIdentityColumnUsingAlterTable(Table table, Column column) throws IOException {
        this.writeTableAlterStmt(table);
        this.print("ALTER COLUMN ");
        this.print(this.getColumnName(column));
        this.print(" SET GENERATED ALWAYS AS IDENTITY");
        this.printEndOfStatement();
    }

    final class ColumnSizeSpec {
        final int _size;
        final String _higherType;

        ColumnSizeSpec(int size, String higherType) {
            this._size = size;
            this._higherType = higherType;
        }
    }
}

