/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.firebird;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.ModelComparator;
import org.apache.ddlutils.alteration.PrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.DefaultTableDefinitionChangesPredicate;
import org.apache.ddlutils.platform.PlatformImplBase;
import org.apache.ddlutils.platform.firebird.FirebirdBuilder;
import org.apache.ddlutils.platform.firebird.FirebirdModelReader;

public class FirebirdPlatform
extends PlatformImplBase {
    public static final String DATABASENAME = "Firebird";
    public static final String JDBC_DRIVER = "org.firebirdsql.jdbc.FBDriver";
    public static final String JDBC_SUBPROTOCOL = "firebirdsql";

    public FirebirdPlatform() {
        PlatformInfo info = this.getPlatformInfo();
        info.setMaxIdentifierLength(31);
        info.setSystemForeignKeyIndicesAlwaysNonUnique(true);
        info.setPrimaryKeyColumnAutomaticallyRequired(true);
        info.setCommentPrefix("/*");
        info.setCommentSuffix("*/");
        info.setSupportedOnUpdateActions(new CascadeActionEnum[]{CascadeActionEnum.CASCADE, CascadeActionEnum.SET_DEFAULT, CascadeActionEnum.SET_NULL, CascadeActionEnum.NONE});
        info.setSupportedOnDeleteActions(new CascadeActionEnum[]{CascadeActionEnum.CASCADE, CascadeActionEnum.SET_DEFAULT, CascadeActionEnum.SET_NULL, CascadeActionEnum.NONE});
        info.addNativeTypeMapping(2003, "BLOB", -4);
        info.addNativeTypeMapping(-2, "BLOB", -4);
        info.addNativeTypeMapping(-7, "SMALLINT", 5);
        info.addNativeTypeMapping(2004, "BLOB", -4);
        info.addNativeTypeMapping(16, "SMALLINT", 5);
        info.addNativeTypeMapping(2005, "BLOB SUB_TYPE TEXT", -1);
        info.addNativeTypeMapping(70, "BLOB", -4);
        info.addNativeTypeMapping(2001, "BLOB", -4);
        info.addNativeTypeMapping(8, "DOUBLE PRECISION");
        info.addNativeTypeMapping(6, "DOUBLE PRECISION", 8);
        info.addNativeTypeMapping(2000, "BLOB", -4);
        info.addNativeTypeMapping(-4, "BLOB", -4);
        info.addNativeTypeMapping(-1, "BLOB SUB_TYPE TEXT");
        info.addNativeTypeMapping(0, "BLOB", -4);
        info.addNativeTypeMapping(1111, "BLOB", -4);
        info.addNativeTypeMapping(7, "FLOAT");
        info.addNativeTypeMapping(2006, "BLOB", -4);
        info.addNativeTypeMapping(2002, "BLOB", -4);
        info.addNativeTypeMapping(-6, "SMALLINT", 5);
        info.addNativeTypeMapping(-3, "BLOB", -4);
        info.setDefaultSize(12, 254);
        info.setDefaultSize(1, 254);
        this.setSqlBuilder(new FirebirdBuilder(this));
        this.setModelReader(new FirebirdModelReader(this));
    }

    @Override
    public String getName() {
        return DATABASENAME;
    }

    @Override
    protected ModelComparator getModelComparator() {
        ModelComparator comparator = super.getModelComparator();
        comparator.setCanDropPrimaryKeyColumns(false);
        return comparator;
    }

    @Override
    protected TableDefinitionChangesPredicate getTableDefinitionChangesPredicate() {
        return new DefaultTableDefinitionChangesPredicate(){

            @Override
            public boolean areSupported(Table intermediateTable, List changes) {
                if (super.areSupported(intermediateTable, changes)) {
                    HashSet<String> addedColumns = new HashSet<String>();
                    String[] pkColNames = null;
                    for (TableChange change : changes) {
                        if (change instanceof AddColumnChange) {
                            addedColumns.add(((AddColumnChange)change).getNewColumn().getName());
                            continue;
                        }
                        if (change instanceof AddPrimaryKeyChange) {
                            pkColNames = ((AddPrimaryKeyChange)change).getPrimaryKeyColumns();
                            continue;
                        }
                        if (!(change instanceof PrimaryKeyChange)) continue;
                        pkColNames = ((PrimaryKeyChange)change).getNewPrimaryKeyColumns();
                    }
                    if (pkColNames != null) {
                        for (int colIdx = 0; colIdx < pkColNames.length; ++colIdx) {
                            if (!addedColumns.contains(pkColNames[colIdx])) continue;
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }

            @Override
            protected boolean isSupported(Table intermediateTable, TableChange change) {
                if (change instanceof AddColumnChange) {
                    AddColumnChange addColumnChange = (AddColumnChange)change;
                    return !addColumnChange.getNewColumn().isAutoIncrement() && addColumnChange.getNewColumn().getDefaultValue() == null && !addColumnChange.getNewColumn().isRequired();
                }
                return change instanceof RemoveColumnChange || super.isSupported(intermediateTable, change);
            }
        };
    }

    @Override
    public void processChange(Database currentModel, CreationParameters params, AddColumnChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column prevColumn = null;
        if (change.getNextColumn() == null) {
            this.getSqlBuilder().addColumn(currentModel, changedTable, change.getNewColumn());
        } else {
            if (change.getPreviousColumn() != null) {
                prevColumn = changedTable.findColumn(change.getPreviousColumn(), this.isDelimitedIdentifierModeOn());
            }
            ((FirebirdBuilder)this.getSqlBuilder()).insertColumn(currentModel, changedTable, change.getNewColumn(), prevColumn);
        }
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, RemoveColumnChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column droppedColumn = changedTable.findColumn(change.getChangedColumn(), this.isDelimitedIdentifierModeOn());
        ((FirebirdBuilder)this.getSqlBuilder()).dropColumn(changedTable, droppedColumn);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }
}

