/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.db2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.DatabaseMetaDataWrapper;
import org.apache.ddlutils.platform.JdbcModelReader;

public class Db2ModelReader
extends JdbcModelReader {
    private static final String[] KNOWN_SYSTEM_TABLES = new String[]{"STMG_DBSIZE_INFO", "HMON_ATM_INFO", "HMON_COLLECTION", "POLICY"};
    private Pattern _db2TimePattern;
    private Pattern _db2TimestampPattern;

    public Db2ModelReader(Platform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        try {
            this._db2TimePattern = Pattern.compile("'(\\d{2}).(\\d{2}).(\\d{2})'");
            this._db2TimestampPattern = Pattern.compile("'(\\d{4}\\-\\d{2}\\-\\d{2})\\-(\\d{2}).(\\d{2}).(\\d{2})(\\.\\d{1,8})?'");
        }
        catch (PatternSyntaxException ex) {
            throw new DdlUtilsException(ex);
        }
    }

    @Override
    protected Table readTable(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        String tableName = (String)values.get("TABLE_NAME");
        for (int idx = 0; idx < KNOWN_SYSTEM_TABLES.length; ++idx) {
            if (!KNOWN_SYSTEM_TABLES[idx].equals(tableName)) continue;
            return null;
        }
        Table table = super.readTable(metaData, values);
        if (table != null) {
            this.determineAutoIncrementColumns(table);
        }
        return table;
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        if (column.getDefaultValue() != null) {
            if (column.getTypeCode() == 92) {
                Matcher matcher = this._db2TimePattern.matcher(column.getDefaultValue());
                if (matcher.matches()) {
                    StringBuilder newDefault = new StringBuilder();
                    newDefault.append("'");
                    newDefault.append(matcher.group(1));
                    newDefault.append(":");
                    newDefault.append(matcher.group(2));
                    newDefault.append(":");
                    newDefault.append(matcher.group(3));
                    newDefault.append("'");
                    column.setDefaultValue(newDefault.toString());
                }
            } else if (column.getTypeCode() == 93) {
                Matcher matcher = this._db2TimestampPattern.matcher(column.getDefaultValue());
                if (matcher.matches()) {
                    StringBuilder newDefault = new StringBuilder();
                    newDefault.append("'");
                    newDefault.append(matcher.group(1));
                    newDefault.append(" ");
                    newDefault.append(matcher.group(2));
                    newDefault.append(":");
                    newDefault.append(matcher.group(3));
                    newDefault.append(":");
                    newDefault.append(matcher.group(4));
                    if (matcher.groupCount() >= 5 && matcher.group(5) != null) {
                        newDefault.append(matcher.group(5));
                    }
                    newDefault.append("'");
                    column.setDefaultValue(newDefault.toString());
                }
            } else if (TypeMap.isTextType(column.getTypeCode())) {
                column.setDefaultValue(this.unescape(column.getDefaultValue(), "'", "''"));
            }
        }
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void determineAutoIncrementColumns(Table table) throws SQLException {
        String query = "SELECT COLNAME FROM SYSCAT.COLUMNS WHERE TABNAME = ? AND IDENTITY = 'Y' AND HIDDEN != 'S'";
        PreparedStatement stmt = null;
        try {
            stmt = this.getConnection().prepareStatement("SELECT COLNAME FROM SYSCAT.COLUMNS WHERE TABNAME = ? AND IDENTITY = 'Y' AND HIDDEN != 'S'");
            stmt.setString(1, table.getName());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String colName = rs.getString(1).trim();
                Column column = table.findColumn(colName, this.getPlatform().isDelimitedIdentifierModeOn());
                if (column == null) continue;
                column.setAutoIncrement(true);
            }
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isInternalPrimaryKeyIndex(DatabaseMetaDataWrapper metaData, Table table, Index index) throws SQLException {
        if (index.getName().startsWith("SQL")) {
            try {
                Long.parseLong(index.getName().substring(3));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        ResultSet pkData = null;
        HashSet pkNames = new HashSet();
        try {
            pkData = metaData.getPrimaryKeys(table.getName());
            while (pkData.next()) {
                Map values = this.readColumns(pkData, this.getColumnsForPK());
                pkNames.add(values.get("PK_NAME"));
            }
        }
        finally {
            this.closeResultSet(pkData);
        }
        return pkNames.contains(index.getName());
    }
}

