/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.DatabaseOperationException;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddForeignKeyChange;
import org.apache.ddlutils.alteration.AddIndexChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.AddTableChange;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.alteration.ColumnOrderChange;
import org.apache.ddlutils.alteration.ForeignKeyChange;
import org.apache.ddlutils.alteration.IndexChange;
import org.apache.ddlutils.alteration.ModelChange;
import org.apache.ddlutils.alteration.ModelComparator;
import org.apache.ddlutils.alteration.PrimaryKeyChange;
import org.apache.ddlutils.alteration.RecreateTableChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.RemoveForeignKeyChange;
import org.apache.ddlutils.alteration.RemoveIndexChange;
import org.apache.ddlutils.alteration.RemovePrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveTableChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.dynabean.SqlDynaClass;
import org.apache.ddlutils.dynabean.SqlDynaProperty;
import org.apache.ddlutils.model.CloneHelper;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.ModelException;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.DefaultTableDefinitionChangesPredicate;
import org.apache.ddlutils.platform.JdbcModelReader;
import org.apache.ddlutils.platform.ModelBasedResultSetIterator;
import org.apache.ddlutils.platform.SqlBuilder;
import org.apache.ddlutils.util.JdbcSupport;
import org.apache.ddlutils.util.SqlTokenizer;

public abstract class PlatformImplBase
extends JdbcSupport
implements Platform {
    protected static final String MODEL_DEFAULT_NAME = "default";
    private final Log _log = LogFactory.getLog(this.getClass());
    private final PlatformInfo _info = new PlatformInfo();
    private SqlBuilder _builder;
    private JdbcModelReader _modelReader;
    private boolean _scriptModeOn;
    private boolean _sqlCommentsOn = true;
    private boolean _delimitedIdentifierModeOn;
    private boolean _identityOverrideOn;
    private boolean _foreignKeysSorted;
    private boolean _useDefaultOnUpdateActionIfUnsupported = true;
    private boolean _useDefaultOnDeleteActionIfUnsupported = true;
    private boolean _addIdentityUsingAlterTable = false;

    @Override
    public SqlBuilder getSqlBuilder() {
        return this._builder;
    }

    protected void setSqlBuilder(SqlBuilder builder) {
        this._builder = builder;
    }

    @Override
    public JdbcModelReader getModelReader() {
        if (this._modelReader == null) {
            this._modelReader = new JdbcModelReader(this);
        }
        return this._modelReader;
    }

    protected void setModelReader(JdbcModelReader modelReader) {
        this._modelReader = modelReader;
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return this._info;
    }

    @Override
    public boolean isScriptModeOn() {
        return this._scriptModeOn;
    }

    @Override
    public void setScriptModeOn(boolean scriptModeOn) {
        this._scriptModeOn = scriptModeOn;
    }

    @Override
    public boolean isSqlCommentsOn() {
        return this._sqlCommentsOn;
    }

    @Override
    public void setSqlCommentsOn(boolean sqlCommentsOn) {
        if (!this.getPlatformInfo().isSqlCommentsSupported() && sqlCommentsOn) {
            throw new DdlUtilsException("Platform " + this.getName() + " does not support SQL comments");
        }
        this._sqlCommentsOn = sqlCommentsOn;
    }

    @Override
    public boolean isDelimitedIdentifierModeOn() {
        return this._delimitedIdentifierModeOn;
    }

    @Override
    public void setDelimitedIdentifierModeOn(boolean delimitedIdentifierModeOn) {
        if (!this.getPlatformInfo().isDelimitedIdentifiersSupported() && delimitedIdentifierModeOn) {
            throw new DdlUtilsException("Platform " + this.getName() + " does not support delimited identifier");
        }
        this._delimitedIdentifierModeOn = delimitedIdentifierModeOn;
    }

    @Override
    public boolean isIdentityOverrideOn() {
        return this._identityOverrideOn;
    }

    @Override
    public void setIdentityOverrideOn(boolean identityOverrideOn) {
        this._identityOverrideOn = identityOverrideOn;
    }

    @Override
    public boolean isForeignKeysSorted() {
        return this._foreignKeysSorted;
    }

    @Override
    public void setForeignKeysSorted(boolean foreignKeysSorted) {
        this._foreignKeysSorted = foreignKeysSorted;
    }

    @Override
    public boolean isDefaultOnUpdateActionUsedIfUnsupported() {
        return this._useDefaultOnUpdateActionIfUnsupported;
    }

    @Override
    public void setDefaultOnUpdateActionUsedIfUnsupported(boolean useDefault) {
        this._useDefaultOnUpdateActionIfUnsupported = useDefault;
    }

    @Override
    public boolean isDefaultOnDeleteActionUsedIfUnsupported() {
        return this._useDefaultOnDeleteActionIfUnsupported;
    }

    @Override
    public void setDefaultOnDeleteActionUsedIfUnsupported(boolean useDefault) {
        this._useDefaultOnDeleteActionIfUnsupported = useDefault;
    }

    protected Log getLog() {
        return this._log;
    }

    protected void logWarnings(Connection connection) throws SQLException {
        for (SQLWarning warning = connection.getWarnings(); warning != null; warning = warning.getNextWarning()) {
            this.getLog().warn((Object)warning.getLocalizedMessage(), warning.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int evaluateBatch(String sql, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            int n = this.evaluateBatch(connection, sql, continueOnError);
            return n;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public int evaluateBatch(Connection connection, String sql, boolean continueOnError) throws DatabaseOperationException {
        Statement statement = null;
        int errors = 0;
        int commandCount = 0;
        try {
            statement = connection.createStatement();
            SqlTokenizer tokenizer = new SqlTokenizer(sql);
            while (tokenizer.hasMoreStatements()) {
                String command = tokenizer.getNextStatement();
                if ((command = command.trim()).length() == 0) continue;
                ++commandCount;
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("About to execute SQL " + command));
                }
                try {
                    int results = statement.executeUpdate(command);
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("After execution, " + results + " row(s) have been changed"));
                    }
                }
                catch (SQLException ex) {
                    if (continueOnError) {
                        this._log.warn((Object)("SQL Command " + command + " failed with: " + ex.getMessage()));
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)ex);
                        }
                        ++errors;
                    }
                    throw new DatabaseOperationException("Error while executing SQL " + command, ex);
                }
                for (SQLWarning warning = connection.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    this._log.warn((Object)warning.toString());
                }
                connection.clearWarnings();
            }
            this._log.info((Object)("Executed " + commandCount + " SQL command(s) with " + errors + " error(s)"));
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException("Error while executing SQL", ex);
        }
        finally {
            this.closeStatement(statement);
        }
        return errors;
    }

    @Override
    public void shutdownDatabase() throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.shutdownDatabase(connection);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public void shutdownDatabase(Connection connection) throws DatabaseOperationException {
    }

    @Override
    public void createDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password, Map parameters) throws DatabaseOperationException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Database creation is not supported for the database platform " + this.getName());
    }

    @Override
    public void dropDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password) throws DatabaseOperationException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Database deletion is not supported for the database platform " + this.getName());
    }

    @Override
    public void createTables(Database model, boolean dropTablesFirst, boolean continueOnError) throws DatabaseOperationException {
        this.createModel(model, dropTablesFirst, continueOnError);
    }

    @Override
    public void createTables(Database model, CreationParameters params, boolean dropTablesFirst, boolean continueOnError) throws DatabaseOperationException {
        this.createModel(model, params, dropTablesFirst, continueOnError);
    }

    @Override
    public void createTables(Connection connection, Database model, boolean dropTablesFirst, boolean continueOnError) throws DatabaseOperationException {
        this.createModel(connection, model, dropTablesFirst, continueOnError);
    }

    @Override
    public void createTables(Connection connection, Database model, CreationParameters params, boolean dropTablesFirst, boolean continueOnError) throws DatabaseOperationException {
        this.createModel(connection, model, params, dropTablesFirst, continueOnError);
    }

    @Override
    public String getCreateTablesSql(Database model, boolean dropTablesFirst, boolean continueOnError) {
        return this.getCreateModelSql(model, dropTablesFirst, continueOnError);
    }

    @Override
    public String getCreateTablesSql(Database model, CreationParameters params, boolean dropTablesFirst, boolean continueOnError) {
        return this.getCreateModelSql(model, params, dropTablesFirst, continueOnError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createModel(Database model, boolean dropTablesFirst, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.createModel(connection, model, dropTablesFirst, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public void createModel(Connection connection, Database model, boolean dropTablesFirst, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getCreateModelSql(model, dropTablesFirst, continueOnError);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createModel(Database model, CreationParameters params, boolean dropTablesFirst, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.createModel(connection, model, params, dropTablesFirst, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public void createModel(Connection connection, Database model, CreationParameters params, boolean dropTablesFirst, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getCreateModelSql(model, params, dropTablesFirst, continueOnError);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    @Override
    public String getCreateModelSql(Database model, boolean dropTablesFirst, boolean continueOnError) {
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().createTables(model, dropTablesFirst);
            sql = buffer.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sql;
    }

    @Override
    public String getCreateModelSql(Database model, CreationParameters params, boolean dropTablesFirst, boolean continueOnError) {
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().createTables(model, params, dropTablesFirst);
            sql = buffer.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sql;
    }

    protected ModelComparator getModelComparator() {
        return new ModelComparator(this.getPlatformInfo(), this.getTableDefinitionChangesPredicate(), this.isDelimitedIdentifierModeOn());
    }

    protected TableDefinitionChangesPredicate getTableDefinitionChangesPredicate() {
        return new DefaultTableDefinitionChangesPredicate();
    }

    @Override
    public List getChanges(Database currentModel, Database desiredModel) {
        List changes = this.getModelComparator().compare(currentModel, desiredModel);
        return this.sortChanges(changes);
    }

    protected List sortChanges(List changes) {
        final HashMap<Class, Integer> typeOrder = new HashMap<Class, Integer>();
        typeOrder.put(RemoveForeignKeyChange.class, 0);
        typeOrder.put(RemoveIndexChange.class, 1);
        typeOrder.put(RemoveTableChange.class, 2);
        typeOrder.put(RecreateTableChange.class, 3);
        typeOrder.put(RemovePrimaryKeyChange.class, 3);
        typeOrder.put(RemoveColumnChange.class, 4);
        typeOrder.put(ColumnDefinitionChange.class, 5);
        typeOrder.put(ColumnOrderChange.class, 5);
        typeOrder.put(AddColumnChange.class, 5);
        typeOrder.put(PrimaryKeyChange.class, 5);
        typeOrder.put(AddPrimaryKeyChange.class, 6);
        typeOrder.put(AddTableChange.class, 7);
        typeOrder.put(AddIndexChange.class, 8);
        typeOrder.put(AddForeignKeyChange.class, 9);
        Collections.sort(changes, new Comparator(){

            public int compare(Object objA, Object objB) {
                Integer orderValueA = (Integer)typeOrder.get(objA.getClass());
                Integer orderValueB = (Integer)typeOrder.get(objB.getClass());
                if (orderValueA == null) {
                    return orderValueB == null ? 0 : 1;
                }
                if (orderValueB == null) {
                    return -1;
                }
                return orderValueA.compareTo(orderValueB);
            }
        });
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterTables(Database desiredModel, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName());
            this.alterModel(currentModel, desiredModel, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterTables(Database desiredModel, CreationParameters params, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName());
            this.alterModel(currentModel, desiredModel, params, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterTables(String catalog, String schema, String[] tableTypes, Database desiredModel, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName(), catalog, schema, tableTypes);
            this.alterModel(currentModel, desiredModel, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterTables(String catalog, String schema, String[] tableTypes, Database desiredModel, CreationParameters params, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName(), catalog, schema, tableTypes);
            this.alterModel(currentModel, desiredModel, params, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public void alterTables(Connection connection, Database desiredModel, boolean continueOnError) throws DatabaseOperationException {
        Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName());
        this.alterModel(currentModel, desiredModel, continueOnError);
    }

    @Override
    public void alterTables(Connection connection, Database desiredModel, CreationParameters params, boolean continueOnError) throws DatabaseOperationException {
        Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName());
        this.alterModel(currentModel, desiredModel, params, continueOnError);
    }

    @Override
    public void alterTables(Connection connection, String catalog, String schema, String[] tableTypes, Database desiredModel, boolean continueOnError) throws DatabaseOperationException {
        Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName(), catalog, schema, tableTypes);
        this.alterModel(currentModel, desiredModel, continueOnError);
    }

    @Override
    public void alterTables(Connection connection, String catalog, String schema, String[] tableTypes, Database desiredModel, CreationParameters params, boolean continueOnError) throws DatabaseOperationException {
        Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName(), catalog, schema, tableTypes);
        this.alterModel(currentModel, desiredModel, params, continueOnError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlterTablesSql(Database desiredModel) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName());
            String string = this.getAlterModelSql(currentModel, desiredModel);
            return string;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlterTablesSql(Database desiredModel, CreationParameters params) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName());
            String string = this.getAlterModelSql(currentModel, desiredModel, params);
            return string;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlterTablesSql(String catalog, String schema, String[] tableTypes, Database desiredModel) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName(), catalog, schema, tableTypes);
            String string = this.getAlterModelSql(currentModel, desiredModel);
            return string;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlterTablesSql(String catalog, String schema, String[] tableTypes, Database desiredModel, CreationParameters params) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName(), catalog, schema, tableTypes);
            String string = this.getAlterModelSql(currentModel, desiredModel, params);
            return string;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public String getAlterTablesSql(Connection connection, Database desiredModel) throws DatabaseOperationException {
        Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName());
        return this.getAlterModelSql(currentModel, desiredModel);
    }

    @Override
    public String getAlterTablesSql(Connection connection, Database desiredModel, CreationParameters params) throws DatabaseOperationException {
        Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName());
        return this.getAlterModelSql(currentModel, desiredModel, params);
    }

    @Override
    public String getAlterTablesSql(Connection connection, String catalog, String schema, String[] tableTypes, Database desiredModel) throws DatabaseOperationException {
        Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName(), catalog, schema, tableTypes);
        return this.getAlterModelSql(currentModel, desiredModel);
    }

    @Override
    public String getAlterTablesSql(Connection connection, String catalog, String schema, String[] tableTypes, Database desiredModel, CreationParameters params) throws DatabaseOperationException {
        Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName(), catalog, schema, tableTypes);
        return this.getAlterModelSql(currentModel, desiredModel, params);
    }

    @Override
    public String getAlterModelSql(Database currentModel, Database desiredModel) throws DatabaseOperationException {
        return this.getAlterModelSql(currentModel, desiredModel, null);
    }

    @Override
    public String getAlterModelSql(Database currentModel, Database desiredModel, CreationParameters params) throws DatabaseOperationException {
        List changes = this.getChanges(currentModel, desiredModel);
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.processChanges(currentModel, changes, params);
            sql = buffer.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterModel(Database currentModel, Database desiredModel, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.alterModel(connection, currentModel, desiredModel, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterModel(Database currentModel, Database desiredModel, CreationParameters params, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.alterModel(connection, currentModel, desiredModel, params, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public void alterModel(Connection connection, Database currentModel, Database desiredModel, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getAlterModelSql(currentModel, desiredModel);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    @Override
    public void alterModel(Connection connection, Database currentModel, Database desiredModel, CreationParameters params, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getAlterModelSql(currentModel, desiredModel, params);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    @Override
    public void dropTable(Connection connection, Database model, Table table, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getDropTableSql(model, table, continueOnError);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(Database model, Table table, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.dropTable(connection, model, table, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public String getDropTableSql(Database model, Table table, boolean continueOnError) {
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().dropTable(model, table);
            sql = buffer.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sql;
    }

    @Override
    public void dropTables(Database model, boolean continueOnError) throws DatabaseOperationException {
        this.dropModel(model, continueOnError);
    }

    @Override
    public void dropTables(Connection connection, Database model, boolean continueOnError) throws DatabaseOperationException {
        this.dropModel(connection, model, continueOnError);
    }

    @Override
    public String getDropTablesSql(Database model, boolean continueOnError) {
        return this.getDropModelSql(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropModel(Database model, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.dropModel(connection, model, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public void dropModel(Connection connection, Database model, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getDropModelSql(model);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    @Override
    public String getDropModelSql(Database model) {
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().dropTables(model);
            sql = buffer.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sql;
    }

    protected Database processChanges(Database model, Collection changes, CreationParameters params) throws IOException, DdlUtilsException {
        Database currentModel = new CloneHelper().clone(model);
        Iterator it = changes.iterator();
        while (it.hasNext()) {
            this.invokeChangeHandler(currentModel, params, (ModelChange)it.next());
        }
        return currentModel;
    }

    private void invokeChangeHandler(Database currentModel, CreationParameters params, ModelChange change) throws IOException {
        for (Class<?> curClass = this.getClass(); curClass != null && !Object.class.equals(curClass); curClass = curClass.getSuperclass()) {
            try {
                Method method = null;
                try {
                    method = curClass.getDeclaredMethod("processChange", Database.class, CreationParameters.class, change.getClass());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method == null) continue;
                method.invoke((Object)this, currentModel, params, change);
                return;
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof IOException) {
                    throw (IOException)ex.getTargetException();
                }
                throw new DdlUtilsException(ex.getTargetException());
            }
            catch (Exception ex) {
                throw new DdlUtilsException(ex);
            }
        }
        throw new DdlUtilsException("No handler for change of type " + change.getClass().getName() + " defined");
    }

    protected Table findChangedTable(Database currentModel, TableChange change) throws ModelException {
        Table table = currentModel.findTable(change.getChangedTable(), this.getPlatformInfo().isDelimitedIdentifiersSupported());
        if (table == null) {
            throw new ModelException("Could not find table " + change.getChangedTable() + " in the given model");
        }
        return table;
    }

    protected Index findChangedIndex(Database currentModel, IndexChange change) throws ModelException {
        Index index = change.findChangedIndex(currentModel, this.getPlatformInfo().isDelimitedIdentifiersSupported());
        if (index == null) {
            throw new ModelException("Could not find the index to change in table " + change.getChangedTable() + " in the given model");
        }
        return index;
    }

    protected ForeignKey findChangedForeignKey(Database currentModel, ForeignKeyChange change) throws ModelException {
        ForeignKey fk = change.findChangedForeignKey(currentModel, this.getPlatformInfo().isDelimitedIdentifiersSupported());
        if (fk == null) {
            throw new ModelException("Could not find the foreign key to change in table " + change.getChangedTable() + " in the given model");
        }
        return fk;
    }

    public void processChange(Database currentModel, CreationParameters params, AddTableChange change) throws IOException {
        this.getSqlBuilder().createTable(currentModel, change.getNewTable(), params == null ? null : params.getParametersFor(change.getNewTable()));
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, RemoveTableChange change) throws IOException, ModelException {
        Table changedTable = this.findChangedTable(currentModel, change);
        this.getSqlBuilder().dropTable(changedTable);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, AddForeignKeyChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        this.getSqlBuilder().createForeignKey(currentModel, changedTable, change.getNewForeignKey());
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, RemoveForeignKeyChange change) throws IOException, ModelException {
        Table changedTable = this.findChangedTable(currentModel, change);
        ForeignKey changedFk = this.findChangedForeignKey(currentModel, change);
        this.getSqlBuilder().dropForeignKey(changedTable, changedFk);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, AddIndexChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        this.getSqlBuilder().createIndex(changedTable, change.getNewIndex());
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, RemoveIndexChange change) throws IOException, ModelException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Index changedIndex = this.findChangedIndex(currentModel, change);
        this.getSqlBuilder().dropIndex(changedTable, changedIndex);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, AddColumnChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        this.getSqlBuilder().addColumn(currentModel, changedTable, change.getNewColumn());
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, AddPrimaryKeyChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        String[] pkColumnNames = change.getPrimaryKeyColumns();
        Column[] pkColumns = new Column[pkColumnNames.length];
        for (int colIdx = 0; colIdx < pkColumns.length; ++colIdx) {
            pkColumns[colIdx] = changedTable.findColumn(pkColumnNames[colIdx], this.isDelimitedIdentifierModeOn());
        }
        this.getSqlBuilder().createPrimaryKey(changedTable, pkColumns);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, RecreateTableChange change) throws IOException {
        Map parameters;
        boolean canMigrateData = true;
        Iterator it = change.getOriginalChanges().iterator();
        while (canMigrateData && it.hasNext()) {
            AddColumnChange addColumnChange;
            TableChange curChange = (TableChange)it.next();
            if (!(curChange instanceof AddColumnChange) || !(addColumnChange = (AddColumnChange)curChange).getNewColumn().isRequired() || addColumnChange.getNewColumn().isAutoIncrement() || addColumnChange.getNewColumn().getDefaultValue() != null) continue;
            this._log.warn((Object)("Data cannot be retained in table " + change.getChangedTable() + " because of the addition of the required column " + addColumnChange.getNewColumn().getName()));
            canMigrateData = false;
        }
        Table changedTable = this.findChangedTable(currentModel, change);
        Table targetTable = change.getTargetTable();
        Map map = parameters = params == null ? null : params.getParametersFor(targetTable);
        if (canMigrateData) {
            Table tempTable = this.getTemporaryTableFor(targetTable);
            this.getSqlBuilder().createTemporaryTable(currentModel, tempTable, parameters);
            this.getSqlBuilder().copyData(changedTable, tempTable);
            this.getSqlBuilder().dropTable(changedTable);
            this.getSqlBuilder().createTable(currentModel, targetTable, parameters);
            this.getSqlBuilder().copyData(tempTable, targetTable);
            this.getSqlBuilder().dropTemporaryTable(currentModel, tempTable);
        } else {
            this.getSqlBuilder().dropTable(changedTable);
            this.getSqlBuilder().createTable(currentModel, targetTable, parameters);
        }
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    protected Table getTemporaryTableFor(Table targetTable) {
        CloneHelper cloneHelper = new CloneHelper();
        Table table = new Table();
        table.setCatalog(targetTable.getCatalog());
        table.setSchema(targetTable.getSchema());
        table.setName(targetTable.getName() + "_");
        table.setType(targetTable.getType());
        for (int idx = 0; idx < targetTable.getColumnCount(); ++idx) {
            table.addColumn(cloneHelper.clone(targetTable.getColumn(idx), true));
        }
        return table;
    }

    @Override
    public Iterator query(Database model, String sql) throws DatabaseOperationException {
        return this.query(model, sql, (Table[])null);
    }

    @Override
    public Iterator query(Database model, String sql, Collection parameters) throws DatabaseOperationException {
        return this.query(model, sql, parameters, null);
    }

    @Override
    public Iterator query(Database model, String sql, Table[] queryHints) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        ModelBasedResultSetIterator answer = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            ModelBasedResultSetIterator modelBasedResultSetIterator = answer = this.createResultSetIterator(model, resultSet, queryHints);
            return modelBasedResultSetIterator;
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException("Error while performing a query", ex);
        }
        finally {
            if (answer == null) {
                this.closeStatement(statement);
                this.returnConnection(connection);
            }
        }
    }

    @Override
    public Iterator query(Database model, String sql, Collection parameters, Table[] queryHints) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        ModelBasedResultSetIterator answer = null;
        try {
            statement = connection.prepareStatement(sql);
            int paramIdx = 1;
            for (Object arg : parameters) {
                if (arg instanceof BigDecimal) {
                    statement.setBigDecimal(paramIdx, (BigDecimal)arg);
                } else {
                    statement.setObject(paramIdx, arg);
                }
                ++paramIdx;
            }
            resultSet = statement.executeQuery();
            ModelBasedResultSetIterator modelBasedResultSetIterator = answer = this.createResultSetIterator(model, resultSet, queryHints);
            return modelBasedResultSetIterator;
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException("Error while performing a query", ex);
        }
        finally {
            if (answer == null) {
                this.closeStatement(statement);
                this.returnConnection(connection);
            }
        }
    }

    @Override
    public List fetch(Database model, String sql) throws DatabaseOperationException {
        return this.fetch(model, sql, (Table[])null, 0, -1);
    }

    @Override
    public List fetch(Database model, String sql, Table[] queryHints) throws DatabaseOperationException {
        return this.fetch(model, sql, queryHints, 0, -1);
    }

    @Override
    public List fetch(Database model, String sql, int start, int end) throws DatabaseOperationException {
        return this.fetch(model, sql, (Table[])null, start, end);
    }

    @Override
    public List fetch(Database model, String sql, Table[] queryHints, int start, int end) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            ModelBasedResultSetIterator it = this.createResultSetIterator(model, resultSet, queryHints);
            for (int rowIdx = 0; (end < 0 || rowIdx <= end) && it.hasNext(); ++rowIdx) {
                if (rowIdx >= start) {
                    result.add(it.next());
                    continue;
                }
                it.advance();
            }
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException("Error while fetching data from the database", ex);
        }
        finally {
            this.closeStatement(statement);
            this.returnConnection(connection);
        }
        return result;
    }

    @Override
    public List fetch(Database model, String sql, Collection parameters) throws DatabaseOperationException {
        return this.fetch(model, sql, parameters, null, 0, -1);
    }

    @Override
    public List fetch(Database model, String sql, Collection parameters, int start, int end) throws DatabaseOperationException {
        return this.fetch(model, sql, parameters, null, start, end);
    }

    @Override
    public List fetch(Database model, String sql, Collection parameters, Table[] queryHints) throws DatabaseOperationException {
        return this.fetch(model, sql, parameters, queryHints, 0, -1);
    }

    @Override
    public List fetch(Database model, String sql, Collection parameters, Table[] queryHints, int start, int end) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            statement = connection.prepareStatement(sql);
            int paramIdx = 1;
            for (Object arg : parameters) {
                if (arg instanceof BigDecimal) {
                    statement.setBigDecimal(paramIdx, (BigDecimal)arg);
                } else {
                    statement.setObject(paramIdx, arg);
                }
                ++paramIdx;
            }
            resultSet = statement.executeQuery();
            ModelBasedResultSetIterator it = this.createResultSetIterator(model, resultSet, queryHints);
            for (int rowIdx = 0; (end < 0 || rowIdx <= end) && it.hasNext(); ++rowIdx) {
                if (rowIdx >= start) {
                    result.add(it.next());
                    continue;
                }
                it.advance();
            }
        }
        catch (SQLException ex) {
            this.closeStatement(statement);
            this.returnConnection(connection);
            throw new DatabaseOperationException("Error while fetching data from the database", ex);
        }
        return result;
    }

    protected String createInsertSql(Database model, SqlDynaClass dynaClass, SqlDynaProperty[] properties, DynaBean bean) {
        Table table = model.findTable(dynaClass.getTableName());
        HashMap columnValues = this.toColumnValues(properties, bean);
        return this._builder.getInsertSql(table, columnValues, bean == null);
    }

    protected String createSelectLastInsertIdSql(Database model, SqlDynaClass dynaClass) {
        Table table = model.findTable(dynaClass.getTableName());
        return this._builder.getSelectLastIdentityValues(table);
    }

    @Override
    public String getInsertSql(Database model, DynaBean dynaBean) {
        SqlDynaClass dynaClass = model.getDynaClassFor(dynaBean);
        SqlDynaProperty[] properties = dynaClass.getSqlDynaProperties();
        if (properties.length == 0) {
            this._log.info((Object)("Cannot insert instances of type " + (Object)((Object)dynaClass) + " because it has no properties"));
            return null;
        }
        return this.createInsertSql(model, dynaClass, properties, dynaBean);
    }

    private SqlDynaProperty[] getPropertiesForInsertion(Database model, SqlDynaClass dynaClass, final DynaBean bean) {
        SqlDynaProperty[] properties = dynaClass.getSqlDynaProperties();
        Collection result = CollectionUtils.select(Arrays.asList(properties), (Predicate)new Predicate(){

            public boolean evaluate(Object input) {
                SqlDynaProperty prop = (SqlDynaProperty)((Object)input);
                if (bean.get(prop.getName()) != null) {
                    return !prop.getColumn().isAutoIncrement() || PlatformImplBase.this.isIdentityOverrideOn() && PlatformImplBase.this.getPlatformInfo().isIdentityOverrideAllowed() || PlatformImplBase.this.isAddIdentityUsingAlterTableOn() && PlatformImplBase.this.getPlatformInfo().isAddingIdentityUsingAlterTableSupported();
                }
                return !prop.getColumn().isAutoIncrement() && prop.getColumn().getDefaultValue() == null;
            }
        });
        return result.toArray(new SqlDynaProperty[result.size()]);
    }

    private Column[] getRelevantIdentityColumns(Database model, SqlDynaClass dynaClass, final DynaBean bean) {
        SqlDynaProperty[] properties = dynaClass.getSqlDynaProperties();
        Collection relevantProperties = CollectionUtils.select(Arrays.asList(properties), (Predicate)new Predicate(){

            public boolean evaluate(Object input) {
                SqlDynaProperty prop = (SqlDynaProperty)((Object)input);
                return !(!prop.getColumn().isAutoIncrement() || PlatformImplBase.this.isAddIdentityUsingAlterTableOn() && PlatformImplBase.this.getPlatformInfo().isAddingIdentityUsingAlterTableSupported() || PlatformImplBase.this.isIdentityOverrideOn() && PlatformImplBase.this.getPlatformInfo().isIdentityOverrideAllowed() && bean.get(prop.getName()) != null);
            }
        });
        Column[] columns = new Column[relevantProperties.size()];
        int idx = 0;
        Iterator propIt = relevantProperties.iterator();
        while (propIt.hasNext()) {
            columns[idx] = ((SqlDynaProperty)((Object)propIt.next())).getColumn();
            ++idx;
        }
        return columns;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void insert(Connection connection, Database model, DynaBean dynaBean) throws DatabaseOperationException {
        PreparedStatement statement;
        boolean autoCommitMode;
        boolean queryIdentityUsingStatement;
        String queryIdentitySql;
        Column[] autoIncrColumns;
        block43: {
            SqlDynaClass dynaClass = model.getDynaClassFor(dynaBean);
            SqlDynaProperty[] properties = this.getPropertiesForInsertion(model, dynaClass, dynaBean);
            autoIncrColumns = this.getRelevantIdentityColumns(model, dynaClass, dynaBean);
            if (properties.length == 0 && autoIncrColumns.length == 0) {
                this._log.warn((Object)("Cannot insert instances of type " + (Object)((Object)dynaClass) + " because it has no usable properties"));
                return;
            }
            String insertSql = this.createInsertSql(model, dynaClass, properties, null);
            queryIdentitySql = null;
            queryIdentityUsingStatement = false;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("About to execute SQL: " + insertSql));
            }
            if (autoIncrColumns.length > 0) {
                if (!this.getPlatformInfo().isLastIdentityValueReadable()) {
                    this._log.warn((Object)"The database does not support querying for auto-generated column values");
                } else if (this.getPlatformInfo().isIdentityValueReadableUsingStatement()) {
                    queryIdentityUsingStatement = true;
                } else {
                    queryIdentitySql = this.createSelectLastInsertIdSql(model, dynaClass);
                }
            }
            autoCommitMode = false;
            statement = null;
            try {
                if (!this.getPlatformInfo().isAutoCommitModeForLastIdentityValueReading()) {
                    autoCommitMode = connection.getAutoCommit();
                    connection.setAutoCommit(false);
                }
                this.beforeInsert(connection, dynaClass.getTable());
                statement = queryIdentityUsingStatement ? connection.prepareStatement(insertSql, 1) : connection.prepareStatement(insertSql);
                for (int idx = 0; idx < properties.length; ++idx) {
                    this.setObject(statement, idx + 1, dynaBean, properties[idx]);
                }
                int count = statement.executeUpdate();
                this.afterInsert(connection, dynaClass.getTable());
                if (count != 1) {
                    this._log.warn((Object)("Attempted to insert a single row " + dynaBean + " in table " + dynaClass.getTableName() + " but changed " + count + " row(s)"));
                }
                if (queryIdentitySql != null || queryIdentityUsingStatement) break block43;
            }
            catch (SQLException ex) {
                try {
                    throw new DatabaseOperationException("Error while inserting into the database: " + ex.getMessage(), ex);
                }
                catch (Throwable throwable) {
                    if (queryIdentitySql != null) throw throwable;
                    if (queryIdentityUsingStatement) throw throwable;
                    this.closeStatement(statement);
                    throw throwable;
                }
            }
            this.closeStatement(statement);
        }
        if (queryIdentitySql != null || queryIdentityUsingStatement) {
            Statement queryStmt = null;
            ResultSet lastInsertedIds = null;
            try {
                if (!queryIdentityUsingStatement && this.getPlatformInfo().isAutoCommitModeForLastIdentityValueReading() && !connection.getAutoCommit()) {
                    connection.commit();
                }
                if (queryIdentityUsingStatement) {
                    lastInsertedIds = statement.getGeneratedKeys();
                } else {
                    queryStmt = connection.createStatement();
                    lastInsertedIds = queryStmt.executeQuery(queryIdentitySql);
                }
                lastInsertedIds.next();
                for (int idx = 0; idx < autoIncrColumns.length; ++idx) {
                    Object value = this.getObjectFromResultSet(lastInsertedIds, autoIncrColumns[idx], idx + 1);
                    PropertyUtils.setProperty((Object)dynaBean, (String)autoIncrColumns[idx].getName(), (Object)value);
                }
            }
            catch (NoSuchMethodException idx) {
            }
            catch (IllegalAccessException idx) {
            }
            catch (InvocationTargetException idx) {
            }
            catch (SQLException ex) {
                throw new DatabaseOperationException("Error while retrieving the identity column value(s) from the database", ex);
            }
            finally {
                if (lastInsertedIds != null) {
                    try {
                        lastInsertedIds.close();
                    }
                    catch (SQLException sQLException) {}
                }
                this.closeStatement(statement);
            }
        }
        if (queryIdentityUsingStatement) return;
        if (!this.getPlatformInfo().isAutoCommitModeForLastIdentityValueReading()) return;
        try {
            connection.commit();
            connection.setAutoCommit(autoCommitMode);
            return;
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Database model, DynaBean dynaBean) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.insert(connection, model, dynaBean);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public void insert(Connection connection, Database model, Collection dynaBeans) throws DatabaseOperationException {
        SqlDynaClass dynaClass = null;
        SqlDynaProperty[] properties = null;
        PreparedStatement statement = null;
        int addedStmts = 0;
        boolean identityWarningPrinted = false;
        Column[] autoIncrColumns = null;
        DynaBean[] batchDynaBeans = null;
        for (DynaBean dynaBean : dynaBeans) {
            SqlDynaClass curDynaClass = model.getDynaClassFor(dynaBean);
            if (curDynaClass != dynaClass) {
                if (dynaClass != null) {
                    this.executeBatch(statement, addedStmts, dynaClass.getTable(), batchDynaBeans, autoIncrColumns);
                    addedStmts = 0;
                }
                dynaClass = curDynaClass;
                properties = this.getPropertiesForInsertion(model, curDynaClass, dynaBean);
                if (properties.length == 0) {
                    this._log.warn((Object)("Cannot insert instances of type " + (Object)((Object)dynaClass) + " because it has no usable properties"));
                    continue;
                }
                if (!identityWarningPrinted && (autoIncrColumns = this.getRelevantIdentityColumns(model, curDynaClass, dynaBean)).length > 0) {
                    if (!this.getPlatformInfo().isIdentityValueReadableInBatchUsingStatement()) {
                        this._log.warn((Object)"Updating the bean properties corresponding to auto-increment columns is not supported in batch mode");
                    } else {
                        batchDynaBeans = new DynaBean[dynaBeans.size()];
                    }
                    identityWarningPrinted = true;
                }
                String insertSql = this.createInsertSql(model, dynaClass, properties, null);
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Starting new batch with SQL: " + insertSql));
                }
                try {
                    statement = batchDynaBeans != null ? connection.prepareStatement(insertSql, 1) : connection.prepareStatement(insertSql);
                }
                catch (SQLException ex) {
                    throw new DatabaseOperationException("Error while preparing insert statement", ex);
                }
            }
            try {
                for (int idx = 0; idx < properties.length; ++idx) {
                    this.setObject(statement, idx + 1, dynaBean, properties[idx]);
                }
                statement.addBatch();
                if (batchDynaBeans != null) {
                    batchDynaBeans[addedStmts] = dynaBean;
                }
                ++addedStmts;
            }
            catch (SQLException ex) {
                throw new DatabaseOperationException("Error while adding batch insert", ex);
            }
        }
        if (dynaClass != null) {
            this.executeBatch(statement, addedStmts, dynaClass.getTable(), batchDynaBeans, autoIncrColumns);
        }
    }

    private void executeBatch(PreparedStatement statement, int numRows, Table table, DynaBean[] batchDynaBeans, Column[] autoIncrColumns) throws DatabaseOperationException {
        if (statement != null) {
            try {
                Connection connection = statement.getConnection();
                this.beforeInsert(connection, table);
                int[] results = statement.executeBatch();
                if (batchDynaBeans != null) {
                    this.handleAutoIncrementValuesForBatch(statement, autoIncrColumns, batchDynaBeans, numRows);
                }
                this.closeStatement(statement);
                this.afterInsert(connection, table);
                boolean hasSum = true;
                int sum = 0;
                for (int idx = 0; results != null && idx < results.length; ++idx) {
                    if (results[idx] < 0) {
                        hasSum = false;
                        if (results[idx] == -3) {
                            this._log.warn((Object)("The batch insertion of row " + idx + " into table " + table.getQualifiedName() + " failed but the driver is able to continue processing"));
                            continue;
                        }
                        if (results[idx] == -2) continue;
                        this._log.warn((Object)("The batch insertion of row " + idx + " into table " + table.getQualifiedName() + " returned an undefined status value " + results[idx]));
                        continue;
                    }
                    sum += results[idx];
                }
                if (hasSum && sum != numRows) {
                    this._log.warn((Object)("Attempted to insert " + numRows + " rows into table " + table.getQualifiedName() + " but changed " + sum + " rows"));
                }
            }
            catch (SQLException ex) {
                if (ex instanceof BatchUpdateException) {
                    SQLException sqlEx = ((BatchUpdateException)ex).getNextException();
                    throw new DatabaseOperationException("Error while inserting into the database", sqlEx);
                }
                throw new DatabaseOperationException("Error while inserting into the database", ex);
            }
        }
    }

    private void handleAutoIncrementValuesForBatch(Statement statement, Column[] autoIncrColumns, DynaBean[] dynaBeans, int numRows) {
        ResultSet lastInsertedIds = null;
        try {
            lastInsertedIds = statement.getGeneratedKeys();
            for (DynaBean dynaBean : dynaBeans) {
                if (numRows-- <= 0) continue;
                lastInsertedIds.next();
                for (int idx = 0; idx < autoIncrColumns.length; ++idx) {
                    Object value = this.getObjectFromResultSet(lastInsertedIds, autoIncrColumns[idx], idx + 1);
                    PropertyUtils.setProperty((Object)dynaBean, (String)autoIncrColumns[idx].getName(), (Object)value);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException("Error while retrieving the identity column value(s) from the database", ex);
        }
        finally {
            if (lastInsertedIds != null) {
                try {
                    lastInsertedIds.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Database model, Collection dynaBeans) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.insert(connection, model, dynaBeans);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    protected void beforeInsert(Connection connection, Table table) throws SQLException {
    }

    protected void afterInsert(Connection connection, Table table) throws SQLException {
    }

    protected String createUpdateSql(Database model, SqlDynaClass dynaClass, SqlDynaProperty[] primaryKeys, SqlDynaProperty[] properties, DynaBean bean) {
        Table table = model.findTable(dynaClass.getTableName());
        HashMap columnValues = this.toColumnValues(properties, bean);
        columnValues.putAll(this.toColumnValues(primaryKeys, bean));
        return this._builder.getUpdateSql(table, columnValues, bean == null);
    }

    protected String createUpdateSql(Database model, SqlDynaClass dynaClass, SqlDynaProperty[] primaryKeys, SqlDynaProperty[] properties, DynaBean oldBean, DynaBean newBean) {
        Table table = model.findTable(dynaClass.getTableName());
        HashMap oldColumnValues = this.toColumnValues(primaryKeys, oldBean);
        HashMap newColumnValues = this.toColumnValues(properties, newBean);
        if (primaryKeys.length == 0) {
            this._log.info((Object)("Cannot update instances of type " + (Object)((Object)dynaClass) + " because it has no primary keys"));
            return null;
        }
        return this._builder.getUpdateSql(table, oldColumnValues, newColumnValues, newBean == null);
    }

    @Override
    public String getUpdateSql(Database model, DynaBean dynaBean) {
        SqlDynaClass dynaClass = model.getDynaClassFor(dynaBean);
        SqlDynaProperty[] primaryKeys = dynaClass.getPrimaryKeyProperties();
        SqlDynaProperty[] nonPrimaryKeys = dynaClass.getNonPrimaryKeyProperties();
        if (primaryKeys.length == 0) {
            this._log.info((Object)("Cannot update instances of type " + (Object)((Object)dynaClass) + " because it has no primary keys"));
            return null;
        }
        return this.createUpdateSql(model, dynaClass, primaryKeys, nonPrimaryKeys, dynaBean);
    }

    @Override
    public String getUpdateSql(Database model, DynaBean oldDynaBean, DynaBean newDynaBean) {
        SqlDynaClass dynaClass = model.getDynaClassFor(oldDynaBean);
        SqlDynaProperty[] primaryKeys = dynaClass.getPrimaryKeyProperties();
        SqlDynaProperty[] nonPrimaryKeys = dynaClass.getNonPrimaryKeyProperties();
        if (primaryKeys.length == 0) {
            this._log.info((Object)("Cannot update instances of type " + (Object)((Object)dynaClass) + " because it has no primary keys"));
            return null;
        }
        return this.createUpdateSql(model, dynaClass, primaryKeys, nonPrimaryKeys, oldDynaBean, newDynaBean);
    }

    @Override
    public void update(Connection connection, Database model, DynaBean dynaBean) throws DatabaseOperationException {
        SqlDynaClass dynaClass = model.getDynaClassFor(dynaBean);
        SqlDynaProperty[] primaryKeys = dynaClass.getPrimaryKeyProperties();
        if (primaryKeys.length == 0) {
            this._log.info((Object)("Cannot update instances of type " + (Object)((Object)dynaClass) + " because it has no primary keys"));
            return;
        }
        SqlDynaProperty[] properties = dynaClass.getNonPrimaryKeyProperties();
        String sql = this.createUpdateSql(model, dynaClass, primaryKeys, properties, null);
        PreparedStatement statement = null;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("About to execute SQL: " + sql));
        }
        try {
            int idx;
            this.beforeUpdate(connection, dynaClass.getTable());
            statement = connection.prepareStatement(sql);
            int sqlIndex = 1;
            for (idx = 0; idx < properties.length; ++idx) {
                this.setObject(statement, sqlIndex++, dynaBean, properties[idx]);
            }
            for (idx = 0; idx < primaryKeys.length; ++idx) {
                this.setObject(statement, sqlIndex++, dynaBean, primaryKeys[idx]);
            }
            int count = statement.executeUpdate();
            this.afterUpdate(connection, dynaClass.getTable());
            if (count != 1) {
                this._log.warn((Object)("Attempted to insert a single row " + dynaBean + " into table " + dynaClass.getTableName() + " but changed " + count + " row(s)"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseOperationException("Error while updating in the database", ex);
            }
            catch (Throwable throwable) {
                this.closeStatement(statement);
                throw throwable;
            }
        }
        this.closeStatement(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Database model, DynaBean dynaBean) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.update(connection, model, dynaBean);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public void update(Connection connection, Database model, DynaBean oldDynaBean, DynaBean newDynaBean) throws DatabaseOperationException {
        SqlDynaClass dynaClass = model.getDynaClassFor(oldDynaBean);
        SqlDynaProperty[] primaryKeys = dynaClass.getPrimaryKeyProperties();
        if (!dynaClass.getTable().equals(model.getDynaClassFor(newDynaBean).getTable())) {
            throw new DatabaseOperationException("The old and new dyna beans need to be for the same table");
        }
        if (primaryKeys.length == 0) {
            this._log.info((Object)("Cannot update instances of type " + (Object)((Object)dynaClass) + " because it has no primary keys"));
            return;
        }
        SqlDynaProperty[] properties = dynaClass.getSqlDynaProperties();
        String sql = this.createUpdateSql(model, dynaClass, primaryKeys, properties, null, null);
        PreparedStatement statement = null;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("About to execute SQL: " + sql));
        }
        try {
            int idx;
            this.beforeUpdate(connection, dynaClass.getTable());
            statement = connection.prepareStatement(sql);
            int sqlIndex = 1;
            for (idx = 0; idx < properties.length; ++idx) {
                this.setObject(statement, sqlIndex++, newDynaBean, properties[idx]);
            }
            for (idx = 0; idx < primaryKeys.length; ++idx) {
                this.setObject(statement, sqlIndex++, oldDynaBean, primaryKeys[idx]);
            }
            int count = statement.executeUpdate();
            this.afterUpdate(connection, dynaClass.getTable());
            if (count != 1) {
                this._log.warn((Object)("Attempted to insert a single row " + newDynaBean + " into table " + dynaClass.getTableName() + " but changed " + count + " row(s)"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseOperationException("Error while updating in the database", ex);
            }
            catch (Throwable throwable) {
                this.closeStatement(statement);
                throw throwable;
            }
        }
        this.closeStatement(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Database model, DynaBean oldDynaBean, DynaBean newDynaBean) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.update(connection, model, oldDynaBean, newDynaBean);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    protected void beforeUpdate(Connection connection, Table table) throws SQLException {
    }

    protected void afterUpdate(Connection connection, Table table) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Database model, DynaBean dynaBean) {
        Connection connection = this.borrowConnection();
        try {
            boolean bl = this.exists(connection, model, dynaBean);
            return bl;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public boolean exists(Connection connection, Database model, DynaBean dynaBean) {
        boolean bl;
        SqlDynaClass dynaClass = model.getDynaClassFor(dynaBean);
        SqlDynaProperty[] primaryKeys = dynaClass.getPrimaryKeyProperties();
        if (primaryKeys.length == 0) {
            return false;
        }
        PreparedStatement stmt = null;
        try {
            int idx;
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT * FROM ");
            sql.append(this._builder.getDelimitedIdentifier(dynaClass.getTable().getQualifiedName()));
            sql.append(" WHERE ");
            for (idx = 0; idx < primaryKeys.length; ++idx) {
                String key = primaryKeys[idx].getColumn().getName();
                if (idx > 0) {
                    sql.append(" AND ");
                }
                sql.append(this._builder.getDelimitedIdentifier(key));
                sql.append("=?");
            }
            stmt = connection.prepareStatement(sql.toString());
            for (idx = 0; idx < primaryKeys.length; ++idx) {
                this.setObject(stmt, idx + 1, dynaBean, primaryKeys[idx]);
            }
            ResultSet resultSet = stmt.executeQuery();
            bl = resultSet.next();
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseOperationException("Error while reading from the database", ex);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Database model, DynaBean dynaBean) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.store(connection, model, dynaBean);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public void store(Connection connection, Database model, DynaBean dynaBean) throws DatabaseOperationException {
        if (this.exists(connection, model, dynaBean)) {
            this.update(connection, model, dynaBean);
        } else {
            this.insert(connection, model, dynaBean);
        }
    }

    protected String createDeleteSql(Database model, SqlDynaClass dynaClass, SqlDynaProperty[] primaryKeys, DynaBean bean) {
        Table table = model.findTable(dynaClass.getTableName());
        HashMap pkValues = this.toColumnValues(primaryKeys, bean);
        return this._builder.getDeleteSql(table, pkValues, bean == null);
    }

    @Override
    public String getDeleteSql(Database model, DynaBean dynaBean) {
        SqlDynaClass dynaClass = model.getDynaClassFor(dynaBean);
        SqlDynaProperty[] primaryKeys = dynaClass.getPrimaryKeyProperties();
        if (primaryKeys.length == 0) {
            this._log.warn((Object)("Cannot delete instances of type " + (Object)((Object)dynaClass) + " because it has no primary keys"));
            return null;
        }
        return this.createDeleteSql(model, dynaClass, primaryKeys, dynaBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Database model, DynaBean dynaBean) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.delete(connection, model, dynaBean);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public void delete(Connection connection, Database model, DynaBean dynaBean) throws DatabaseOperationException {
        PreparedStatement statement = null;
        try {
            SqlDynaClass dynaClass = model.getDynaClassFor(dynaBean);
            SqlDynaProperty[] primaryKeys = dynaClass.getPrimaryKeyProperties();
            if (primaryKeys.length == 0) {
                this._log.warn((Object)("Cannot delete instances of type " + (Object)((Object)dynaClass) + " because it has no primary keys"));
                return;
            }
            String sql = this.createDeleteSql(model, dynaClass, primaryKeys, null);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("About to execute SQL " + sql));
            }
            statement = connection.prepareStatement(sql);
            for (int idx = 0; idx < primaryKeys.length; ++idx) {
                this.setObject(statement, idx + 1, dynaBean, primaryKeys[idx]);
            }
            int count = statement.executeUpdate();
            if (count != 1) {
                this._log.warn((Object)("Attempted to delete a single row " + dynaBean + " in table " + dynaClass.getTableName() + " but changed " + count + " row(s)."));
            }
            this.closeStatement(statement);
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException("Error while deleting from the database", ex);
        }
        finally {
            this.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Database readModelFromDatabase(String name) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            Database database = this.readModelFromDatabase(connection, name);
            return database;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public Database readModelFromDatabase(Connection connection, String name) throws DatabaseOperationException {
        try {
            Database model = this.getModelReader().getDatabase(connection, name);
            this.postprocessModelFromDatabase(model);
            return model;
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Database readModelFromDatabase(String name, String catalog, String schema, String[] tableTypes) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            Database database = this.readModelFromDatabase(connection, name, catalog, schema, tableTypes);
            return database;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public Database readModelFromDatabase(Connection connection, String name, String catalog, String schema, String[] tableTypes) throws DatabaseOperationException {
        try {
            JdbcModelReader reader = this.getModelReader();
            Database model = reader.getDatabase(connection, name, catalog, schema, tableTypes);
            this.postprocessModelFromDatabase(model);
            if (model.getName() == null || model.getName().length() == 0) {
                model.setName(MODEL_DEFAULT_NAME);
            }
            return model;
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException(ex);
        }
    }

    protected void postprocessModelFromDatabase(Database model) {
        for (int tableIdx = 0; tableIdx < model.getTableCount(); ++tableIdx) {
            Table table = model.getTable(tableIdx);
            for (int columnIdx = 0; columnIdx < table.getColumnCount(); ++columnIdx) {
                String defaultValue;
                Column column = table.getColumn(columnIdx);
                if (!TypeMap.isTextType(column.getTypeCode()) && !TypeMap.isDateTimeType(column.getTypeCode()) || (defaultValue = column.getDefaultValue()) == null || defaultValue.length() < 2 || !defaultValue.startsWith("'") || !defaultValue.endsWith("'")) continue;
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                column.setDefaultValue(defaultValue);
            }
        }
    }

    protected HashMap toColumnValues(SqlDynaProperty[] properties, DynaBean bean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int idx = 0; idx < properties.length; ++idx) {
            result.put(properties[idx].getName(), bean == null ? null : bean.get(properties[idx].getName()));
        }
        return result;
    }

    protected void setObject(PreparedStatement statement, int sqlIndex, DynaBean dynaBean, SqlDynaProperty property) throws SQLException {
        int typeCode = property.getColumn().getTypeCode();
        Object value = dynaBean.get(property.getName());
        this.setStatementParameterValue(statement, sqlIndex, typeCode, value);
    }

    protected void setStatementParameterValue(PreparedStatement statement, int sqlIndex, int typeCode, Object value) throws SQLException {
        if (value == null) {
            statement.setNull(sqlIndex, typeCode);
        } else if (value instanceof String) {
            statement.setString(sqlIndex, (String)value);
        } else if (value instanceof byte[]) {
            statement.setBytes(sqlIndex, (byte[])value);
        } else if (value instanceof Boolean) {
            statement.setBoolean(sqlIndex, (Boolean)value);
        } else if (value instanceof Byte) {
            statement.setByte(sqlIndex, (Byte)value);
        } else if (value instanceof Short) {
            statement.setShort(sqlIndex, (Short)value);
        } else if (value instanceof Integer) {
            statement.setInt(sqlIndex, (Integer)value);
        } else if (value instanceof Long) {
            statement.setLong(sqlIndex, (Long)value);
        } else if (value instanceof BigDecimal) {
            statement.setBigDecimal(sqlIndex, (BigDecimal)value);
        } else if (value instanceof Float) {
            statement.setFloat(sqlIndex, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            statement.setDouble(sqlIndex, (Double)value);
        } else {
            statement.setObject(sqlIndex, value, typeCode);
        }
    }

    protected Object getObjectFromResultSet(ResultSet resultSet, String columnName, Table table) throws SQLException {
        Column column = table == null ? null : table.findColumn(columnName, this.isDelimitedIdentifierModeOn());
        Object value = null;
        if (column != null) {
            int originalJdbcType = column.getTypeCode();
            int targetJdbcType = this.getPlatformInfo().getTargetJdbcType(originalJdbcType);
            int jdbcType = originalJdbcType;
            if (originalJdbcType == 2004 && targetJdbcType != 2004) {
                jdbcType = targetJdbcType;
            }
            if (originalJdbcType == 2005 && targetJdbcType != 2005) {
                jdbcType = targetJdbcType;
            }
            value = this.extractColumnValue(resultSet, columnName, 0, jdbcType);
        } else {
            value = resultSet.getObject(columnName);
        }
        return resultSet.wasNull() ? null : value;
    }

    protected Object getObjectFromResultSet(ResultSet resultSet, Column column, int idx) throws SQLException {
        int originalJdbcType = column.getTypeCode();
        int targetJdbcType = this.getPlatformInfo().getTargetJdbcType(originalJdbcType);
        int jdbcType = originalJdbcType;
        Object value = null;
        if (originalJdbcType == 2004 && targetJdbcType != 2004) {
            jdbcType = targetJdbcType;
        }
        if (originalJdbcType == 2005 && targetJdbcType != 2005) {
            jdbcType = targetJdbcType;
        }
        value = this.extractColumnValue(resultSet, null, idx, jdbcType);
        return resultSet.wasNull() ? null : value;
    }

    protected Object extractColumnValue(ResultSet resultSet, String columnName, int columnIdx, int jdbcType) throws SQLException {
        Object value;
        boolean useIdx = columnName == null;
        switch (jdbcType) {
            case -1: 
            case 1: 
            case 12: {
                value = useIdx ? resultSet.getString(columnIdx) : resultSet.getString(columnName);
                break;
            }
            case 2: 
            case 3: {
                value = useIdx ? resultSet.getBigDecimal(columnIdx) : resultSet.getBigDecimal(columnName);
                break;
            }
            case -7: 
            case 16: {
                value = useIdx ? resultSet.getBoolean(columnIdx) : resultSet.getBoolean(columnName);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                value = useIdx ? resultSet.getInt(columnIdx) : resultSet.getInt(columnName);
                break;
            }
            case -5: {
                value = useIdx ? resultSet.getLong(columnIdx) : resultSet.getLong(columnName);
                break;
            }
            case 7: {
                value = Float.valueOf(useIdx ? resultSet.getFloat(columnIdx) : resultSet.getFloat(columnName));
                break;
            }
            case 6: 
            case 8: {
                value = useIdx ? resultSet.getDouble(columnIdx) : resultSet.getDouble(columnName);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                value = useIdx ? resultSet.getBytes(columnIdx) : resultSet.getBytes(columnName);
                break;
            }
            case 91: {
                value = useIdx ? resultSet.getDate(columnIdx) : resultSet.getDate(columnName);
                break;
            }
            case 92: {
                value = useIdx ? resultSet.getTime(columnIdx) : resultSet.getTime(columnName);
                break;
            }
            case 93: {
                value = useIdx ? resultSet.getTimestamp(columnIdx) : resultSet.getTimestamp(columnName);
                break;
            }
            case 2005: {
                Clob clob;
                Clob clob2 = clob = useIdx ? resultSet.getClob(columnIdx) : resultSet.getClob(columnName);
                if (clob == null) {
                    value = null;
                    break;
                }
                long length = clob.length();
                if (length > Integer.MAX_VALUE) {
                    value = clob;
                    break;
                }
                if (length == 0L) {
                    value = "";
                    break;
                }
                value = clob.getSubString(1L, (int)length);
                break;
            }
            case 2004: {
                Blob blob;
                Blob blob2 = blob = useIdx ? resultSet.getBlob(columnIdx) : resultSet.getBlob(columnName);
                if (blob == null) {
                    value = null;
                    break;
                }
                long length = blob.length();
                if (length > Integer.MAX_VALUE) {
                    value = blob;
                    break;
                }
                if (length == 0L) {
                    value = new byte[0];
                    break;
                }
                value = blob.getBytes(1L, (int)length);
                break;
            }
            case 2003: {
                value = useIdx ? resultSet.getArray(columnIdx) : resultSet.getArray(columnName);
                break;
            }
            case 2006: {
                value = useIdx ? resultSet.getRef(columnIdx) : resultSet.getRef(columnName);
                break;
            }
            default: {
                value = useIdx ? resultSet.getObject(columnIdx) : resultSet.getObject(columnName);
            }
        }
        return resultSet.wasNull() ? null : value;
    }

    protected ModelBasedResultSetIterator createResultSetIterator(Database model, ResultSet resultSet, Table[] queryHints) {
        return new ModelBasedResultSetIterator(this, model, resultSet, queryHints, true);
    }

    @Override
    public final boolean isAddIdentityUsingAlterTableOn() {
        return this._addIdentityUsingAlterTable;
    }

    @Override
    public final void setAddIdentityUsingAlterTable(boolean v) {
        this._addIdentityUsingAlterTable = v;
    }

    @Override
    public String writeAllDDLs(boolean exportAll) throws DatabaseOperationException {
        if (!this.getPlatformInfo().isDDLExportSupported()) {
            throw new DdlUtilsException("Platform " + this.getName() + " does not support DDL export");
        }
        Connection connection = this.borrowConnection();
        try {
            StringWriter buffer = new StringWriter();
            this.writeAllDDLs(connection, buffer, exportAll);
            String string = buffer.toString();
            return string;
        }
        catch (IOException ioe) {
            throw new DatabaseOperationException("Unexpected IO error while exporting DDLs", ioe);
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException("Error while exporting DDLs", ex);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    protected void writeAllDDLs(Connection conn, Writer writer, boolean exportAll) throws SQLException, IOException {
    }
}

