/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class MetaDataColumnDescriptor {
    private String _columnName;
    private int _jdbcType;
    private Object _defaultValue;

    public MetaDataColumnDescriptor(String columnName, int jdbcType) {
        this(columnName, jdbcType, null);
    }

    public MetaDataColumnDescriptor(String columnName, int jdbcType, Object defaultValue) {
        this._columnName = columnName.toUpperCase();
        this._jdbcType = jdbcType;
        this._defaultValue = defaultValue;
    }

    public String getName() {
        return this._columnName;
    }

    public Object getDefaultValue() {
        return this._defaultValue;
    }

    public int getJdbcType() {
        return this._jdbcType;
    }

    public Object readColumn(ResultSet resultSet) throws SQLException {
        Object result = null;
        try {
            switch (this._jdbcType) {
                case -7: {
                    result = resultSet.getBoolean(this._columnName);
                    break;
                }
                case 4: {
                    result = resultSet.getInt(this._columnName);
                    break;
                }
                case -6: {
                    result = resultSet.getShort(this._columnName);
                    break;
                }
                default: {
                    result = resultSet.getString(this._columnName);
                }
            }
            if (resultSet.wasNull()) {
                result = null;
            }
        }
        catch (SQLException ex) {
            if (this.isColumnInResultSet(resultSet)) {
                throw ex;
            }
            result = this._defaultValue;
        }
        return result;
    }

    private boolean isColumnInResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        for (int idx = 1; idx <= metaData.getColumnCount(); ++idx) {
            if (!this._columnName.equals(metaData.getColumnName(idx).toUpperCase())) continue;
            return true;
        }
        return false;
    }
}

