/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Pattern;

public class DatabaseMetaDataWrapper {
    private final Pattern searchStringPattern = Pattern.compile("[_%]");
    private DatabaseMetaData _metaData;
    private String _catalog;
    private String _schemaPattern;
    private String[] _tableTypes;

    public DatabaseMetaData getMetaData() {
        return this._metaData;
    }

    public void setMetaData(DatabaseMetaData metaData) {
        this._metaData = metaData;
    }

    public String getCatalog() {
        return this._catalog;
    }

    public void setCatalog(String catalog) {
        this._catalog = catalog;
    }

    public String getSchemaPattern() {
        return this._schemaPattern;
    }

    public void setSchemaPattern(String schema) {
        this._schemaPattern = schema;
    }

    public String[] getTableTypes() {
        if (this._tableTypes == null) {
            return null;
        }
        String[] result = new String[this._tableTypes.length];
        System.arraycopy(this._tableTypes, 0, result, 0, this._tableTypes.length);
        return result;
    }

    public void setTableTypes(String[] types) {
        if (types == null) {
            this._tableTypes = null;
        } else {
            this._tableTypes = new String[types.length];
            System.arraycopy(types, 0, this._tableTypes, 0, types.length);
        }
    }

    public String escapeForSearch(String literalString) throws SQLException {
        String escape = this.getMetaData().getSearchStringEscape();
        if (escape == "") {
            return literalString;
        }
        StringBuilder quotedEscape = new StringBuilder();
        block4: for (int idx = 0; idx < escape.length(); ++idx) {
            char c = escape.charAt(idx);
            switch (c) {
                case '\\': {
                    quotedEscape.append("\\\\");
                    continue block4;
                }
                case '$': {
                    quotedEscape.append("\\$");
                    continue block4;
                }
                default: {
                    quotedEscape.append(c);
                }
            }
        }
        quotedEscape.append("$0");
        return this.searchStringPattern.matcher(literalString).replaceAll(quotedEscape.toString());
    }

    public ResultSet getTables(String tableNamePattern) throws SQLException {
        return this.getMetaData().getTables(this.getCatalog(), this.getSchemaPattern(), tableNamePattern, this.getTableTypes());
    }

    public ResultSet getColumns(String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.getMetaData().getColumns(this.getCatalog(), this.getSchemaPattern(), tableNamePattern, columnNamePattern);
    }

    public ResultSet getPrimaryKeys(String tableNamePattern) throws SQLException {
        return this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchemaPattern(), tableNamePattern);
    }

    public ResultSet getForeignKeys(String tableNamePattern) throws SQLException {
        return this.getMetaData().getImportedKeys(this.getCatalog(), this.getSchemaPattern(), tableNamePattern);
    }

    public ResultSet getIndices(String tableNamePattern, boolean unique, boolean approximate) throws SQLException {
        return this.getMetaData().getIndexInfo(this.getCatalog(), this.getSchemaPattern(), tableNamePattern, unique, approximate);
    }
}

