/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.ModelException;
import org.apache.ddlutils.model.Table;

public class ModelHelper {
    public void checkForForeignKeysToAndFromTables(Database model, Table[] tables) throws ModelException {
        List<Table> tableList = Arrays.asList(tables);
        for (int tableIdx = 0; tableIdx < model.getTableCount(); ++tableIdx) {
            Table curTable = model.getTable(tableIdx);
            boolean curTableIsInList = tableList.contains(curTable);
            for (int fkIdx = 0; fkIdx < curTable.getForeignKeyCount(); ++fkIdx) {
                ForeignKey curFk = curTable.getForeignKey(fkIdx);
                if (curTableIsInList == tableList.contains(curFk.getForeignTable())) continue;
                throw new ModelException("The table " + curTable.getQualifiedName() + " has a foreign key to table " + curFk.getForeignTable().getQualifiedName());
            }
        }
    }

    public void removeForeignKeysToAndFromTables(Database model, Table[] tables) {
        List<Table> tableList = Arrays.asList(tables);
        for (int tableIdx = 0; tableIdx < model.getTableCount(); ++tableIdx) {
            Table curTable = model.getTable(tableIdx);
            boolean curTableIsInList = tableList.contains(curTable);
            ArrayList<ForeignKey> fksToRemove = new ArrayList<ForeignKey>();
            for (int fkIdx = 0; fkIdx < curTable.getForeignKeyCount(); ++fkIdx) {
                ForeignKey curFk = curTable.getForeignKey(fkIdx);
                if (curTableIsInList != tableList.contains(curFk.getForeignTable())) {
                    fksToRemove.add(curFk);
                }
                Iterator fkIt = fksToRemove.iterator();
                while (fkIt.hasNext()) {
                    curTable.removeForeignKey((ForeignKey)fkIt.next());
                }
            }
        }
    }

    public static void getDelimitedName(String name, StringBuilder query, String delimiterToken) {
        int dotIndex = name.indexOf(46);
        if (dotIndex == -1) {
            query.append(delimiterToken).append(name).append(delimiterToken);
        } else {
            int startIndex;
            query.append(delimiterToken).append(name.substring(0, dotIndex));
            while (true) {
                startIndex = dotIndex + 1;
                dotIndex = name.indexOf(46, startIndex);
                query.append(delimiterToken).append('.').append(delimiterToken);
                if (dotIndex == -1) break;
                query.append(name.substring(startIndex, dotIndex));
            }
            query.append(name.substring(startIndex)).append(delimiterToken);
        }
    }
}

