/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.model;

import java.util.ArrayList;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.util.StringUtilsExt;

public abstract class IndexImplBase
implements Index {
    protected String _name;
    protected ArrayList _columns = new ArrayList();

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public int getColumnCount() {
        return this._columns.size();
    }

    @Override
    public IndexColumn getColumn(int idx) {
        return (IndexColumn)this._columns.get(idx);
    }

    @Override
    public IndexColumn[] getColumns() {
        return this._columns.toArray(new IndexColumn[this._columns.size()]);
    }

    @Override
    public boolean hasColumn(Column column) {
        for (int idx = 0; idx < this._columns.size(); ++idx) {
            IndexColumn curColumn = this.getColumn(idx);
            if (!column.equals(curColumn.getColumn())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasColumn(String columnName, boolean caseSensitive) {
        for (int idx = 0; idx < this._columns.size(); ++idx) {
            IndexColumn curColumn = this.getColumn(idx);
            if (!StringUtilsExt.equals(columnName, curColumn.getName(), caseSensitive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addColumn(IndexColumn column) {
        if (column != null) {
            for (int idx = 0; idx < this._columns.size(); ++idx) {
                IndexColumn curColumn = this.getColumn(idx);
                if (curColumn.getOrdinalPosition() <= column.getOrdinalPosition()) continue;
                this._columns.add(idx, column);
                return;
            }
            this._columns.add(column);
        }
    }

    @Override
    public void removeColumn(IndexColumn column) {
        this._columns.remove(column);
    }

    @Override
    public void removeColumn(int idx) {
        this._columns.remove(idx);
    }
}

