/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class DataDtdWriter {
    public void writeDtd(Database model, Writer output) throws IOException {
        int idx;
        PrintWriter writer = new PrintWriter(output);
        writer.println("<!-- DTD for XML data files for database " + model.getName() + " -->\n");
        writer.println("<!ELEMENT data (");
        for (idx = 0; idx < model.getTableCount(); ++idx) {
            Table table = model.getTable(idx);
            writer.print("    " + table.getQualifiedName());
            if (idx < model.getTableCount() - 1) {
                writer.println(" |");
                continue;
            }
            writer.println();
        }
        writer.println(")*>");
        for (idx = 0; idx < model.getTableCount(); ++idx) {
            this.writeTableElement(model.getTable(idx), writer);
        }
    }

    private void writeTableElement(Table table, PrintWriter writer) throws IOException {
        writer.println("\n<!ELEMENT " + table.getQualifiedName() + " EMPTY>");
        writer.println("<!ATTLIST " + table.getQualifiedName());
        for (int idx = 0; idx < table.getColumnCount(); ++idx) {
            this.writeColumnAttributeEntry(table.getColumn(idx), writer);
        }
        writer.println(">");
    }

    private void writeColumnAttributeEntry(Column column, PrintWriter writer) throws IOException {
        writer.print("    <!--");
        if (column.isPrimaryKey()) {
            writer.print(" primary key,");
        }
        if (column.isAutoIncrement()) {
            writer.print(" auto increment,");
        }
        writer.print(" JDBC type: " + column.getType());
        if (column.getSize() != null && column.getSize().length() > 0) {
            writer.print("(" + column.getSize() + ")");
        }
        writer.println(" -->");
        writer.print("    " + column.getName() + " CDATA ");
        if (column.getDefaultValue() != null && column.getDefaultValue().length() > 0) {
            writer.println("\"" + column.getDefaultValue() + "\"");
        } else {
            writer.println(column.isRequired() ? "#REQUIRED" : "#IMPLIED");
        }
    }
}

