/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.util.List;
import org.apache.ddlutils.alteration.TableChangeImplBase;
import org.apache.ddlutils.model.CloneHelper;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class RecreateTableChange
extends TableChangeImplBase {
    private Table _targetTable;
    private List _originalChanges;

    public RecreateTableChange(String tableName, Table targetTable, List originalChanges) {
        super(tableName);
        this._targetTable = targetTable;
        this._originalChanges = originalChanges;
    }

    public List getOriginalChanges() {
        return this._originalChanges;
    }

    public Table getTargetTable() {
        return this._targetTable;
    }

    @Override
    public void apply(Database database, boolean caseSensitive) {
        for (int tableIdx = 0; tableIdx < database.getTableCount(); ++tableIdx) {
            Table curTable = database.getTable(tableIdx);
            if ((!caseSensitive || !curTable.getQualifiedName().equals(this.getChangedTable())) && (caseSensitive || !curTable.getQualifiedName().equalsIgnoreCase(this.getChangedTable()))) continue;
            database.removeTable(tableIdx);
            database.addTable(tableIdx, new CloneHelper().clone(this._targetTable, true, false, database, caseSensitive));
            break;
        }
    }
}

