/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import org.apache.ddlutils.alteration.TableChangeImplBase;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class PrimaryKeyChange
extends TableChangeImplBase {
    private String[] _newPrimaryKeyColumns;

    public PrimaryKeyChange(String tableName, String[] newPrimaryKeyColumns) {
        super(tableName);
        if (newPrimaryKeyColumns == null) {
            this._newPrimaryKeyColumns = new String[0];
        } else {
            this._newPrimaryKeyColumns = new String[newPrimaryKeyColumns.length];
            System.arraycopy(newPrimaryKeyColumns, 0, this._newPrimaryKeyColumns, 0, newPrimaryKeyColumns.length);
        }
    }

    public String[] getNewPrimaryKeyColumns() {
        String[] result = new String[this._newPrimaryKeyColumns.length];
        System.arraycopy(this._newPrimaryKeyColumns, 0, result, 0, this._newPrimaryKeyColumns.length);
        return result;
    }

    @Override
    public void apply(Database model, boolean caseSensitive) {
        int idx;
        Table table = this.findChangedTable(model, caseSensitive);
        Column[] pkCols = table.getPrimaryKeyColumns();
        for (idx = 0; idx < pkCols.length; ++idx) {
            pkCols[idx].setPrimaryKey(false);
        }
        for (idx = 0; idx < this._newPrimaryKeyColumns.length; ++idx) {
            Column column = table.findColumn(this._newPrimaryKeyColumns[idx], caseSensitive);
            column.setPrimaryKey(true);
        }
    }
}

