/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddForeignKeyChange;
import org.apache.ddlutils.alteration.AddIndexChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.AddTableChange;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.alteration.ColumnOrderChange;
import org.apache.ddlutils.alteration.PrimaryKeyChange;
import org.apache.ddlutils.alteration.RecreateTableChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.RemoveForeignKeyChange;
import org.apache.ddlutils.alteration.RemoveIndexChange;
import org.apache.ddlutils.alteration.RemovePrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveTableChange;
import org.apache.ddlutils.alteration.TableChangeImplBase;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.CloneHelper;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.util.StringUtilsExt;

public class ModelComparator {
    private final Log _log = LogFactory.getLog(ModelComparator.class);
    private PlatformInfo _platformInfo;
    private TableDefinitionChangesPredicate _tableDefCangePredicate;
    private CloneHelper _cloneHelper = new CloneHelper();
    private boolean _caseSensitive;
    private boolean _generatePrimaryKeyChanges = true;
    private boolean _canDropPrimaryKeyColumns = true;

    public ModelComparator(PlatformInfo platformInfo, TableDefinitionChangesPredicate tableDefChangePredicate, boolean caseSensitive) {
        this._platformInfo = platformInfo;
        this._caseSensitive = caseSensitive;
        this._tableDefCangePredicate = tableDefChangePredicate;
    }

    public void setGeneratePrimaryKeyChanges(boolean generatePrimaryKeyChanges) {
        this._generatePrimaryKeyChanges = generatePrimaryKeyChanges;
    }

    public void setCanDropPrimaryKeyColumns(boolean canDropPrimaryKeyColumns) {
        this._canDropPrimaryKeyColumns = canDropPrimaryKeyColumns;
    }

    protected PlatformInfo getPlatformInfo() {
        return this._platformInfo;
    }

    protected boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public List compare(Database sourceModel, Database targetModel) {
        Database intermediateModel = this._cloneHelper.clone(sourceModel);
        return this.compareModels(sourceModel, intermediateModel, targetModel);
    }

    protected List compareModels(Database sourceModel, Database intermediateModel, Database targetModel) {
        ArrayList changes = new ArrayList();
        changes.addAll(this.checkForRemovedForeignKeys(sourceModel, intermediateModel, targetModel));
        changes.addAll(this.checkForRemovedTables(sourceModel, intermediateModel, targetModel));
        for (int tableIdx = 0; tableIdx < intermediateModel.getTableCount(); ++tableIdx) {
            Table intermediateTable = intermediateModel.getTable(tableIdx);
            Table sourceTable = sourceModel.findTable(intermediateTable.getQualifiedName(), this._caseSensitive);
            Table targetTable = targetModel.findTable(intermediateTable.getQualifiedName(), this._caseSensitive);
            List tableChanges = this.compareTables(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable);
            changes.addAll(tableChanges);
        }
        changes.addAll(this.checkForAddedTables(sourceModel, intermediateModel, targetModel));
        changes.addAll(this.checkForAddedForeignKeys(sourceModel, intermediateModel, targetModel));
        return changes;
    }

    protected List checkForRemovedForeignKeys(Database sourceModel, Database intermediateModel, Database targetModel) {
        ArrayList<RemoveForeignKeyChange> changes = new ArrayList<RemoveForeignKeyChange>();
        for (int tableIdx = 0; tableIdx < intermediateModel.getTableCount(); ++tableIdx) {
            Table intermediateTable = intermediateModel.getTable(tableIdx);
            Table targetTable = targetModel.findTable(intermediateTable.getQualifiedName(), this._caseSensitive);
            ForeignKey[] intermediateFks = intermediateTable.getForeignKeys();
            for (int fkIdx = 0; fkIdx < intermediateFks.length; ++fkIdx) {
                ForeignKey targetFk;
                ForeignKey sourceFk = intermediateFks[fkIdx];
                ForeignKey foreignKey = targetFk = targetTable == null ? null : this.findCorrespondingForeignKey(targetTable, sourceFk);
                if (targetFk != null) continue;
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Foreign key " + sourceFk + " needs to be removed from table " + intermediateTable.getQualifiedName()));
                }
                RemoveForeignKeyChange fkChange = new RemoveForeignKeyChange(intermediateTable.getQualifiedName(), sourceFk);
                changes.add(fkChange);
                fkChange.apply(intermediateModel, this._caseSensitive);
            }
        }
        return changes;
    }

    protected List checkForAddedForeignKeys(Database sourceModel, Database intermediateModel, Database targetModel) {
        ArrayList<AddForeignKeyChange> changes = new ArrayList<AddForeignKeyChange>();
        for (int tableIdx = 0; tableIdx < targetModel.getTableCount(); ++tableIdx) {
            Table targetTable = targetModel.getTable(tableIdx);
            Table intermediateTable = intermediateModel.findTable(targetTable.getQualifiedName(), this._caseSensitive);
            for (int fkIdx = 0; fkIdx < targetTable.getForeignKeyCount(); ++fkIdx) {
                ForeignKey targetFk = targetTable.getForeignKey(fkIdx);
                ForeignKey intermediateFk = this.findCorrespondingForeignKey(intermediateTable, targetFk);
                if (intermediateFk != null) continue;
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Foreign key " + targetFk + " needs to be added to table " + intermediateTable.getQualifiedName()));
                }
                intermediateFk = this._cloneHelper.clone(targetFk, intermediateTable, intermediateModel, this._caseSensitive);
                AddForeignKeyChange fkChange = new AddForeignKeyChange(intermediateTable.getQualifiedName(), intermediateFk);
                changes.add(fkChange);
                fkChange.apply(intermediateModel, this._caseSensitive);
            }
        }
        return changes;
    }

    protected List checkForRemovedTables(Database sourceModel, Database intermediateModel, Database targetModel) {
        ArrayList<RemoveTableChange> changes = new ArrayList<RemoveTableChange>();
        Table[] intermediateTables = intermediateModel.getTables();
        for (int tableIdx = 0; tableIdx < intermediateTables.length; ++tableIdx) {
            Table intermediateTable = intermediateTables[tableIdx];
            Table targetTable = targetModel.findTable(intermediateTable.getQualifiedName(), this._caseSensitive);
            if (targetTable != null) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Table " + intermediateTable.getQualifiedName() + " needs to be removed"));
            }
            RemoveTableChange tableChange = new RemoveTableChange(intermediateTable.getQualifiedName());
            changes.add(tableChange);
            tableChange.apply(intermediateModel, this._caseSensitive);
        }
        return changes;
    }

    protected List checkForAddedTables(Database sourceModel, Database intermediateModel, Database targetModel) {
        ArrayList<AddTableChange> changes = new ArrayList<AddTableChange>();
        for (int tableIdx = 0; tableIdx < targetModel.getTableCount(); ++tableIdx) {
            Table targetTable = targetModel.getTable(tableIdx);
            Table intermediateTable = intermediateModel.findTable(targetTable.getQualifiedName(), this._caseSensitive);
            if (intermediateTable != null) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Table " + targetTable.getQualifiedName() + " needs to be added"));
            }
            intermediateTable = this._cloneHelper.clone(targetTable, true, false, intermediateModel, this._caseSensitive);
            AddTableChange tableChange = new AddTableChange(intermediateTable);
            changes.add(tableChange);
            tableChange.apply(intermediateModel, this._caseSensitive);
        }
        return changes;
    }

    protected List compareTables(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        ArrayList changes = new ArrayList();
        changes.addAll(this.checkForRemovedIndexes(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable));
        ArrayList tableDefinitionChanges = new ArrayList();
        Table tmpTable = this._cloneHelper.clone(intermediateTable, true, false, intermediateModel, this._caseSensitive);
        tableDefinitionChanges.addAll(this.checkForRemovedColumns(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable));
        tableDefinitionChanges.addAll(this.checkForChangeOfColumnOrder(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable));
        tableDefinitionChanges.addAll(this.checkForChangedColumns(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable));
        tableDefinitionChanges.addAll(this.checkForAddedColumns(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable));
        tableDefinitionChanges.addAll(this.checkForPrimaryKeyChanges(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable));
        if (!tableDefinitionChanges.isEmpty()) {
            if (this._tableDefCangePredicate == null || this._tableDefCangePredicate.areSupported(tmpTable, tableDefinitionChanges)) {
                changes.addAll(tableDefinitionChanges);
            } else {
                ForeignKey[] fks = intermediateTable.getForeignKeys();
                for (int fkIdx = 0; fkIdx < fks.length; ++fkIdx) {
                    RemoveForeignKeyChange fkChange = new RemoveForeignKeyChange(intermediateTable.getQualifiedName(), fks[fkIdx]);
                    changes.add(fkChange);
                    fkChange.apply(intermediateModel, this._caseSensitive);
                }
                for (int tableIdx = 0; tableIdx < intermediateModel.getTableCount(); ++tableIdx) {
                    Table curTable = intermediateModel.getTable(tableIdx);
                    if (curTable == intermediateTable) continue;
                    ForeignKey[] curFks = curTable.getForeignKeys();
                    for (int fkIdx = 0; fkIdx < curFks.length; ++fkIdx) {
                        if ((!this._caseSensitive || !curFks[fkIdx].getForeignTableName().equals(intermediateTable.getQualifiedName())) && (this._caseSensitive || !curFks[fkIdx].getForeignTableName().equalsIgnoreCase(intermediateTable.getQualifiedName()))) continue;
                        RemoveForeignKeyChange fkChange = new RemoveForeignKeyChange(curTable.getQualifiedName(), curFks[fkIdx]);
                        changes.add(fkChange);
                        fkChange.apply(intermediateModel, this._caseSensitive);
                    }
                }
                RecreateTableChange tableChange = new RecreateTableChange(intermediateTable.getQualifiedName(), intermediateTable, new ArrayList(tableDefinitionChanges));
                changes.add(tableChange);
                tableChange.apply(intermediateModel, this._caseSensitive);
            }
        }
        changes.addAll(this.checkForAddedIndexes(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable));
        return changes;
    }

    protected String[] getIntermediateColumnNamesFor(Column[] columns, Table intermediateTable) {
        String[] result = new String[columns.length];
        for (int idx = 0; idx < columns.length; ++idx) {
            result[idx] = intermediateTable.findColumn(columns[idx].getName(), this._caseSensitive).getName();
        }
        return result;
    }

    protected List checkForRemovedIndexes(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        ArrayList<RemoveIndexChange> changes = new ArrayList<RemoveIndexChange>();
        Index[] indexes = intermediateTable.getIndices();
        for (int indexIdx = 0; indexIdx < indexes.length; ++indexIdx) {
            Index sourceIndex = indexes[indexIdx];
            Index targetIndex = this.findCorrespondingIndex(targetTable, sourceIndex);
            if (targetIndex != null) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Index " + sourceIndex.getName() + " needs to be removed from table " + intermediateTable.getQualifiedName()));
            }
            RemoveIndexChange change = new RemoveIndexChange(intermediateTable.getQualifiedName(), sourceIndex);
            changes.add(change);
            change.apply(intermediateModel, this._caseSensitive);
        }
        return changes;
    }

    protected List checkForAddedIndexes(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        ArrayList<AddIndexChange> changes = new ArrayList<AddIndexChange>();
        for (int indexIdx = 0; indexIdx < targetTable.getIndexCount(); ++indexIdx) {
            Index targetIndex = targetTable.getIndex(indexIdx);
            Index intermediateIndex = this.findCorrespondingIndex(intermediateTable, targetIndex);
            Index sourceIndex = this.findCorrespondingIndex(sourceTable, targetIndex);
            if (sourceIndex != null || intermediateIndex != null) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Index " + targetIndex.getName() + " needs to be created for table " + intermediateTable.getQualifiedName()));
            }
            Index clonedIndex = this._cloneHelper.clone(targetIndex, intermediateTable, this._caseSensitive);
            AddIndexChange change = new AddIndexChange(intermediateTable.getQualifiedName(), clonedIndex);
            changes.add(change);
            change.apply(intermediateModel, this._caseSensitive);
        }
        return changes;
    }

    protected List checkForChangeOfColumnOrder(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        Column sourceColumn;
        ArrayList<TableChangeImplBase> changes = new ArrayList<TableChangeImplBase>();
        ArrayList<Column> targetOrder = new ArrayList<Column>();
        int numChangedPKs = 0;
        for (int columnIdx = 0; columnIdx < targetTable.getColumnCount(); ++columnIdx) {
            Column targetColumn = targetTable.getColumn(columnIdx);
            sourceColumn = intermediateTable.findColumn(targetColumn.getName(), this._caseSensitive);
            if (sourceColumn == null) continue;
            targetOrder.add(sourceColumn);
        }
        HashMap<String, Integer> newPositions = new HashMap<String, Integer>();
        for (int columnIdx = 0; columnIdx < intermediateTable.getColumnCount(); ++columnIdx) {
            sourceColumn = intermediateTable.getColumn(columnIdx);
            int targetIdx = targetOrder.indexOf(sourceColumn);
            if (targetIdx < 0 || targetIdx == columnIdx) continue;
            newPositions.put(sourceColumn.getName(), targetIdx);
            if (!sourceColumn.isPrimaryKey()) continue;
            ++numChangedPKs;
        }
        if (!newPositions.isEmpty()) {
            ColumnOrderChange change = new ColumnOrderChange(intermediateTable.getQualifiedName(), newPositions);
            change.apply(intermediateModel, this._caseSensitive);
            if (numChangedPKs > 1) {
                changes.add(new PrimaryKeyChange(intermediateTable.getQualifiedName(), this.getIntermediateColumnNamesFor(intermediateTable.getPrimaryKeyColumns(), intermediateTable)));
            }
            changes.add(change);
        }
        return changes;
    }

    protected List checkForRemovedColumns(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        ArrayList<RemoveColumnChange> changes = new ArrayList<RemoveColumnChange>();
        Column[] columns = intermediateTable.getColumns();
        for (int columnIdx = 0; columnIdx < columns.length; ++columnIdx) {
            Column sourceColumn = columns[columnIdx];
            Column targetColumn = targetTable.findColumn(sourceColumn.getName(), this._caseSensitive);
            if (targetColumn != null) continue;
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Column " + sourceColumn.getName() + " needs to be removed from table " + intermediateTable.getQualifiedName()));
            }
            RemoveColumnChange change = new RemoveColumnChange(intermediateTable.getQualifiedName(), sourceColumn.getName());
            changes.add(change);
            change.apply(intermediateModel, this._caseSensitive);
        }
        return changes;
    }

    protected List checkForAddedColumns(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        ArrayList<AddColumnChange> changes = new ArrayList<AddColumnChange>();
        for (int columnIdx = 0; columnIdx < targetTable.getColumnCount(); ++columnIdx) {
            Column targetColumn = targetTable.getColumn(columnIdx);
            Column sourceColumn = intermediateTable.findColumn(targetColumn.getName(), this._caseSensitive);
            if (sourceColumn != null) continue;
            String prevColumn = columnIdx > 0 ? intermediateTable.getColumn(columnIdx - 1).getName() : null;
            String nextColumn = columnIdx < intermediateTable.getColumnCount() ? intermediateTable.getColumn(columnIdx).getName() : null;
            Column clonedColumn = this._cloneHelper.clone(targetColumn, false);
            AddColumnChange change = new AddColumnChange(intermediateTable.getQualifiedName(), clonedColumn, prevColumn, nextColumn);
            changes.add(change);
            change.apply(intermediateModel, this._caseSensitive);
        }
        return changes;
    }

    protected List checkForChangedColumns(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        ArrayList<ColumnDefinitionChange> changes = new ArrayList<ColumnDefinitionChange>();
        for (int columnIdx = 0; columnIdx < targetTable.getColumnCount(); ++columnIdx) {
            ColumnDefinitionChange change;
            Column targetColumn = targetTable.getColumn(columnIdx);
            Column sourceColumn = intermediateTable.findColumn(targetColumn.getName(), this._caseSensitive);
            if (sourceColumn == null || (change = this.compareColumns(intermediateTable, sourceColumn, targetTable, targetColumn)) == null) continue;
            changes.add(change);
            change.apply(intermediateModel, this._caseSensitive);
        }
        return changes;
    }

    protected List checkForPrimaryKeyChanges(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        ArrayList<TableChangeImplBase> changes = new ArrayList<TableChangeImplBase>();
        Column[] sourcePK = sourceTable.getPrimaryKeyColumns();
        Column[] curPK = intermediateTable.getPrimaryKeyColumns();
        Column[] targetPK = targetTable.getPrimaryKeyColumns();
        if (curPK.length == 0 && targetPK.length > 0) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("A primary key needs to be added to the table " + intermediateTable.getQualifiedName()));
            }
            AddPrimaryKeyChange change = new AddPrimaryKeyChange(intermediateTable.getQualifiedName(), this.getIntermediateColumnNamesFor(targetPK, intermediateTable));
            changes.add(change);
            change.apply(intermediateModel, this._caseSensitive);
        } else if (targetPK.length == 0 && curPK.length > 0) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("The primary key needs to be removed from the table " + intermediateTable.getQualifiedName()));
            }
            RemovePrimaryKeyChange change = new RemovePrimaryKeyChange(intermediateTable.getQualifiedName());
            changes.add(change);
            change.apply(intermediateModel, this._caseSensitive);
        } else {
            boolean changePK = false;
            if (curPK.length != targetPK.length || !this._canDropPrimaryKeyColumns && sourcePK.length > targetPK.length) {
                changePK = true;
            } else if (curPK.length > 0 && targetPK.length > 0) {
                for (int pkColumnIdx = 0; pkColumnIdx < curPK.length && !changePK; ++pkColumnIdx) {
                    if (StringUtilsExt.equals(curPK[pkColumnIdx].getName(), targetPK[pkColumnIdx].getName(), this._caseSensitive)) continue;
                    changePK = true;
                }
            }
            if (changePK) {
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("The primary key of table " + intermediateTable.getQualifiedName() + " needs to be changed"));
                }
                if (this._generatePrimaryKeyChanges) {
                    PrimaryKeyChange change = new PrimaryKeyChange(intermediateTable.getQualifiedName(), this.getIntermediateColumnNamesFor(targetPK, intermediateTable));
                    changes.add(change);
                    change.apply(intermediateModel, changePK);
                } else {
                    RemovePrimaryKeyChange removePKChange = new RemovePrimaryKeyChange(intermediateTable.getQualifiedName());
                    AddPrimaryKeyChange addPKChange = new AddPrimaryKeyChange(intermediateTable.getQualifiedName(), this.getIntermediateColumnNamesFor(targetPK, intermediateTable));
                    changes.add(removePKChange);
                    changes.add(addPKChange);
                    removePKChange.apply(intermediateModel, this._caseSensitive);
                    addPKChange.apply(intermediateModel, this._caseSensitive);
                }
            }
        }
        return changes;
    }

    protected ColumnDefinitionChange compareColumns(Table sourceTable, Column sourceColumn, Table targetTable, Column targetColumn) {
        if (ColumnDefinitionChange.isChanged(this.getPlatformInfo(), sourceColumn, targetColumn)) {
            Column newColumnDef = this._cloneHelper.clone(sourceColumn, true);
            int targetTypeCode = this._platformInfo.getTargetJdbcType(targetColumn.getTypeCode());
            boolean sizeMatters = this._platformInfo.hasSize(targetTypeCode);
            boolean scaleMatters = this._platformInfo.hasPrecisionAndScale(targetTypeCode);
            newColumnDef.setTypeCode(targetColumn.getTypeCode());
            newColumnDef.setSize(sizeMatters || scaleMatters ? targetColumn.getSize() : null);
            newColumnDef.setAutoIncrement(targetColumn.isAutoIncrement());
            newColumnDef.setRequired(targetColumn.isRequired());
            newColumnDef.setDescription(targetColumn.getDescription());
            newColumnDef.setDefaultValue(targetColumn.getDefaultValue());
            return new ColumnDefinitionChange(sourceTable.getQualifiedName(), sourceColumn.getName(), newColumnDef);
        }
        return null;
    }

    protected ForeignKey findCorrespondingForeignKey(Table table, ForeignKey fk) {
        for (int fkIdx = 0; fkIdx < table.getForeignKeyCount(); ++fkIdx) {
            ForeignKey curFk = table.getForeignKey(fkIdx);
            if ((!this._caseSensitive || !fk.equals(curFk)) && (this._caseSensitive || !fk.equalsIgnoreCase(curFk))) continue;
            return curFk;
        }
        return null;
    }

    protected Index findCorrespondingIndex(Table table, Index index) {
        for (int indexIdx = 0; indexIdx < table.getIndexCount(); ++indexIdx) {
            Index curIndex = table.getIndex(indexIdx);
            if ((!this._caseSensitive || !index.equals(curIndex)) && (this._caseSensitive || !index.equalsIgnoreCase(curIndex))) continue;
            return curIndex;
        }
        return null;
    }
}

